/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.lifecycle;

import com.adobe.marketing.mobile.lifecycle.LifecycleConstants;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.NamedCollection;
import java.util.HashMap;
import java.util.Map;

class LifecycleSession {
    private static final String SELF_LOG_TAG = "LifecycleSession";
    private final NamedCollection dataStore;
    private boolean lifecycleHasRun;

    LifecycleSession(NamedCollection dataStore) {
        this.dataStore = dataStore;
    }

    SessionInfo start(long startTimestampInSeconds, long sessionTimeoutInSeconds, Map<String, String> coreData) {
        long pausedTimeInSecond;
        boolean previousSessionCrashed;
        if (this.lifecycleHasRun) {
            return null;
        }
        if (this.dataStore == null) {
            Log.debug((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"Failed to start session, %s (persisted data)", (Object[])new Object[]{"Unexpected Null Value"});
            return null;
        }
        this.lifecycleHasRun = true;
        long previousSessionStartTimeInSeconds = this.dataStore.getLong("SessionStart", 0L);
        long previousSessionPauseTimeInSeconds = this.dataStore.getLong("PauseDate", 0L);
        boolean bl = previousSessionCrashed = !this.dataStore.getBoolean("SuccessfulClose", true);
        if (previousSessionPauseTimeInSeconds > 0L && (pausedTimeInSecond = startTimestampInSeconds - previousSessionPauseTimeInSeconds) < sessionTimeoutInSeconds && previousSessionStartTimeInSeconds > 0L) {
            this.dataStore.setLong("SessionStart", previousSessionStartTimeInSeconds + pausedTimeInSecond);
            this.dataStore.setBoolean("SuccessfulClose", false);
            this.dataStore.remove("PauseDate");
            return null;
        }
        this.dataStore.setLong("SessionStart", startTimestampInSeconds);
        this.dataStore.remove("PauseDate");
        this.dataStore.setBoolean("SuccessfulClose", false);
        int launches = this.dataStore.getInt("Launches", 0) + 1;
        this.dataStore.setInt("Launches", launches);
        this.dataStore.setString("OsVersion", coreData.get("osversion"));
        this.dataStore.setString("AppId", coreData.get("appid"));
        Log.trace((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"New lifecycle session started", (Object[])new Object[0]);
        return new SessionInfo(previousSessionStartTimeInSeconds, previousSessionPauseTimeInSeconds, previousSessionCrashed);
    }

    void pause(long pauseTimestampInSeconds) {
        if (this.dataStore == null) {
            Log.debug((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"Failed to pause session, %s (persisted data)", (Object[])new Object[]{"Unexpected Null Value"});
            return;
        }
        this.dataStore.setBoolean("SuccessfulClose", true);
        this.dataStore.setLong("PauseDate", pauseTimestampInSeconds);
        Log.trace((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"Lifecycle session paused", (Object[])new Object[0]);
        this.lifecycleHasRun = false;
    }

    Map<String, String> getSessionData(long startTimestampInSeconds, long sessionTimeoutInSeconds, SessionInfo previousSessionInfo) {
        HashMap<String, String> sessionContextData = new HashMap<String, String>();
        if (this.dataStore == null) {
            Log.debug((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"%s (data store), Failed to get session length data", (Object[])new Object[]{"Unexpected Null Value"});
            return sessionContextData;
        }
        if (previousSessionInfo == null) {
            Log.debug((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"%s (previous session info), Failed to get session length data", (Object[])new Object[]{"Unexpected Null Value"});
            return sessionContextData;
        }
        long timeSincePauseInSeconds = startTimestampInSeconds - previousSessionInfo.getPauseTimestampInSeconds();
        long lastSessionTimeSeconds = previousSessionInfo.getPauseTimestampInSeconds() - previousSessionInfo.getStartTimestampInSeconds();
        if (timeSincePauseInSeconds < sessionTimeoutInSeconds) {
            return sessionContextData;
        }
        if (lastSessionTimeSeconds > 0L && lastSessionTimeSeconds < LifecycleConstants.MAX_SESSION_LENGTH_SECONDS) {
            sessionContextData.put("prevsessionlength", Long.toString(lastSessionTimeSeconds));
        } else {
            sessionContextData.put("ignoredsessionlength", Long.toString(lastSessionTimeSeconds));
        }
        return sessionContextData;
    }

    static class SessionInfo {
        private final long startTimestampInSeconds;
        private final long pauseTimestampInSeconds;
        private final boolean isCrash;

        SessionInfo(long startTimestampInSeconds, long pauseTimestampInSeconds, boolean isCrash) {
            this.startTimestampInSeconds = startTimestampInSeconds;
            this.pauseTimestampInSeconds = pauseTimestampInSeconds;
            this.isCrash = isCrash;
        }

        long getStartTimestampInSeconds() {
            return this.startTimestampInSeconds;
        }

        long getPauseTimestampInSeconds() {
            return this.pauseTimestampInSeconds;
        }

        boolean isCrash() {
            return this.isCrash;
        }
    }
}

