/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.lifecycle;

import com.adobe.marketing.mobile.lifecycle.LifecycleConstants;
import com.adobe.marketing.mobile.lifecycle.LifecycleUtil;
import com.adobe.marketing.mobile.services.DeviceInforming;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.NamedCollection;
import com.adobe.marketing.mobile.util.StringUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

final class LifecycleMetricsBuilder {
    private static final String SELF_LOG_TAG = "LifecycleMetricsBuilder";
    private final DateFormat sdfDate = new SimpleDateFormat("M/d/yyyy", Locale.US);
    private final Map<String, String> lifecycleData = new HashMap<String, String>();
    private final DeviceInforming deviceInfoService;
    private final NamedCollection lifecycleDataStore;
    private final long timestampInSeconds;

    LifecycleMetricsBuilder(DeviceInforming deviceInfoService, NamedCollection dataStore, long timestampInSeconds) {
        this.deviceInfoService = deviceInfoService;
        this.lifecycleDataStore = dataStore;
        this.timestampInSeconds = timestampInSeconds;
        if (dataStore == null) {
            Log.debug((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"%s (Data Store), while creating LifecycleExtension Metrics Builder.", (Object[])new Object[]{"Unexpected Null Value"});
        }
        if (deviceInfoService == null) {
            Log.debug((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"%s (Device Info Services), while creating LifecycleExtension Metrics Builder", (Object[])new Object[]{"Unexpected Null Value"});
        }
    }

    Map<String, String> build() {
        return this.lifecycleData;
    }

    LifecycleMetricsBuilder addInstallData() {
        Log.trace((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"Adding install data to lifecycle data map", (Object[])new Object[0]);
        this.lifecycleData.put("dailyenguserevent", "DailyEngUserEvent");
        this.lifecycleData.put("monthlyenguserevent", "MonthlyEngUserEvent");
        this.lifecycleData.put("installevent", "InstallEvent");
        this.lifecycleData.put("installdate", this.stringFromTimestamp(this.timestampInSeconds));
        return this;
    }

    LifecycleMetricsBuilder addLaunchData() {
        Log.trace((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"Adding launch data to the lifecycle data map", (Object[])new Object[0]);
        if (this.lifecycleDataStore == null) {
            return this;
        }
        long lastLaunchDate = this.lifecycleDataStore.getLong("LastDateUsed", 0L);
        long firstLaunchDate = this.lifecycleDataStore.getLong("InstallDate", 0L);
        Calendar calendarCurrentTimestamp = this.calendarFromTimestampInSeconds(this.timestampInSeconds);
        Calendar calendarPersistedTimestamp = this.calendarFromTimestampInSeconds(lastLaunchDate);
        int daysSinceLastUse = this.calculateDaysBetween(lastLaunchDate, this.timestampInSeconds);
        int daysSinceFirstUse = this.calculateDaysBetween(firstLaunchDate, this.timestampInSeconds);
        if (calendarCurrentTimestamp.get(2) != calendarPersistedTimestamp.get(2) || calendarCurrentTimestamp.get(1) != calendarPersistedTimestamp.get(1)) {
            this.lifecycleData.put("dailyenguserevent", "DailyEngUserEvent");
            this.lifecycleData.put("monthlyenguserevent", "MonthlyEngUserEvent");
        } else if (calendarCurrentTimestamp.get(5) != calendarPersistedTimestamp.get(5)) {
            this.lifecycleData.put("dailyenguserevent", "DailyEngUserEvent");
        }
        if (daysSinceLastUse >= 0) {
            this.lifecycleData.put("dayssincelastuse", Integer.toString(daysSinceLastUse));
        }
        if (daysSinceFirstUse >= 0) {
            this.lifecycleData.put("dayssincefirstuse", Integer.toString(daysSinceFirstUse));
        }
        return this;
    }

    LifecycleMetricsBuilder addGenericData() {
        int launches;
        Log.trace((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"Adding generic data to the lifecycle data map", (Object[])new Object[0]);
        if (this.lifecycleDataStore != null && (launches = this.lifecycleDataStore.getInt("Launches", -1)) != -1) {
            this.lifecycleData.put("launches", Integer.toString(launches));
        }
        Calendar calendarCurrentTimestamp = this.calendarFromTimestampInSeconds(this.timestampInSeconds);
        this.lifecycleData.put("dayofweek", Integer.toString(calendarCurrentTimestamp.get(7)));
        this.lifecycleData.put("hourofday", Integer.toString(calendarCurrentTimestamp.get(11)));
        this.lifecycleData.put("launchevent", "LaunchEvent");
        return this;
    }

    LifecycleMetricsBuilder addUpgradeData(boolean upgrade) {
        Log.trace((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"Adding upgrade data to lifecycle data map", (Object[])new Object[0]);
        if (upgrade) {
            this.lifecycleData.put("upgradeevent", "UpgradeEvent");
        }
        if (this.lifecycleDataStore == null) {
            return this;
        }
        long upgradeDate = this.lifecycleDataStore.getLong("UpgradeDate", 0L);
        if (upgrade) {
            this.lifecycleDataStore.setLong("UpgradeDate", this.timestampInSeconds);
            this.lifecycleDataStore.setInt("LaunchesAfterUpgrade", 0);
        } else if (upgradeDate > 0L) {
            int daysSinceUpgrade = this.calculateDaysBetween(upgradeDate, this.timestampInSeconds);
            int launchesAfterUpgrade = this.lifecycleDataStore.getInt("LaunchesAfterUpgrade", 0) + 1;
            this.lifecycleDataStore.setInt("LaunchesAfterUpgrade", launchesAfterUpgrade);
            this.lifecycleData.put("launchessinceupgrade", Integer.toString(launchesAfterUpgrade));
            if (daysSinceUpgrade >= 0) {
                this.lifecycleData.put("dayssincelastupgrade", Integer.toString(daysSinceUpgrade));
            }
        }
        return this;
    }

    LifecycleMetricsBuilder addCrashData(boolean previousSessionCrash) {
        Log.trace((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"Adding crash data to lifecycle data map", (Object[])new Object[0]);
        if (previousSessionCrash) {
            this.lifecycleData.put("crashevent", "CrashEvent");
        }
        return this;
    }

    LifecycleMetricsBuilder addCoreData() {
        String runMode;
        String systemLocale;
        String locale;
        String resolution;
        String operatingSystem;
        String appId;
        String carrierName;
        Log.trace((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"Adding core data to lifecycle data map", (Object[])new Object[0]);
        if (this.deviceInfoService == null) {
            return this;
        }
        String deviceName = this.deviceInfoService.getDeviceName();
        if (!StringUtils.isNullOrEmpty((String)deviceName)) {
            this.lifecycleData.put("devicename", deviceName);
        }
        if (!StringUtils.isNullOrEmpty((String)(carrierName = this.deviceInfoService.getMobileCarrierName()))) {
            this.lifecycleData.put("carriername", carrierName);
        }
        if (!StringUtils.isNullOrEmpty((String)(appId = this.getApplicationIdentifier()))) {
            this.lifecycleData.put("appid", appId);
        }
        if (!StringUtils.isNullOrEmpty((String)(operatingSystem = this.deviceInfoService.getOperatingSystemName() + " " + this.deviceInfoService.getOperatingSystemVersion()))) {
            this.lifecycleData.put("osversion", operatingSystem);
        }
        if (!StringUtils.isNullOrEmpty((String)(resolution = this.getResolution()))) {
            this.lifecycleData.put("resolution", resolution);
        }
        if (!StringUtils.isNullOrEmpty((String)(locale = LifecycleUtil.formatLocale(this.deviceInfoService.getActiveLocale())))) {
            this.lifecycleData.put("locale", locale);
        }
        if (!StringUtils.isNullOrEmpty((String)(systemLocale = LifecycleUtil.formatLocale(this.deviceInfoService.getSystemLocale())))) {
            this.lifecycleData.put("systemlocale", systemLocale);
        }
        if (!StringUtils.isNullOrEmpty((String)(runMode = this.deviceInfoService.getRunMode()))) {
            this.lifecycleData.put("runmode", runMode);
        }
        return this;
    }

    private int calculateDaysBetween(long startTimestampInSeconds, long endTimestampInSeconds) {
        if (startTimestampInSeconds < LifecycleConstants.WRONG_EPOCH_MAX_LENGTH_SECONDS || endTimestampInSeconds < LifecycleConstants.WRONG_EPOCH_MAX_LENGTH_SECONDS) {
            Log.debug((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"Invalid timestamp - startTimestampInSeconds (%d), endTimestampInSeconds (%d)", (Object[])new Object[]{startTimestampInSeconds, endTimestampInSeconds});
            return -1;
        }
        Calendar calendarStartDate = this.calendarFromTimestampInSeconds(startTimestampInSeconds);
        Calendar calendarEndDate = this.calendarFromTimestampInSeconds(endTimestampInSeconds);
        int yearsDifference = calendarEndDate.get(1) - calendarStartDate.get(1);
        int daysDifference = calendarEndDate.get(6) - calendarStartDate.get(6);
        int startYear = calendarStartDate.get(1);
        int endYear = calendarEndDate.get(1);
        if (yearsDifference == 0) {
            return daysDifference;
        }
        int daysInYearsDifference = 0;
        int leapYearDays = 366;
        int otherYearDays = 365;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        for (int year = startYear; year < endYear; ++year) {
            if (gregorianCalendar.isLeapYear(year)) {
                daysInYearsDifference += 366;
                continue;
            }
            daysInYearsDifference += 365;
        }
        return daysDifference + daysInYearsDifference;
    }

    private Calendar calendarFromTimestampInSeconds(long timestampInSeconds) {
        Calendar calendarStartDate = Calendar.getInstance();
        calendarStartDate.setTimeInMillis(TimeUnit.SECONDS.toMillis(timestampInSeconds));
        return calendarStartDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String stringFromTimestamp(long timestampInSeconds) {
        DateFormat dateFormat = this.sdfDate;
        synchronized (dateFormat) {
            return this.sdfDate.format(TimeUnit.SECONDS.toMillis(timestampInSeconds));
        }
    }

    private String getApplicationIdentifier() {
        if (this.deviceInfoService == null) {
            return null;
        }
        String applicationName = this.deviceInfoService.getApplicationName();
        String applicationVersion = this.deviceInfoService.getApplicationVersion();
        String applicationVersionCode = this.deviceInfoService.getApplicationVersionCode();
        return String.format("%s%s%s", applicationName, !StringUtils.isNullOrEmpty((String)applicationVersion) ? String.format(" %s", applicationVersion) : "", !StringUtils.isNullOrEmpty((String)applicationVersionCode) ? String.format(" (%s)", applicationVersionCode) : "");
    }

    private String getResolution() {
        if (this.deviceInfoService == null) {
            return null;
        }
        DeviceInforming.DisplayInformation displayInfo = this.deviceInfoService.getDisplayInformation();
        if (displayInfo == null) {
            Log.debug((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"Failed to get resolution %s for DisplayInformation", (Object[])new Object[]{"Unexpected Null Value"});
            return null;
        }
        return String.format(Locale.US, "%dx%d", displayInfo.getWidthPixels(), displayInfo.getHeightPixels());
    }
}

