/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.auth.impl.cug;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;

class CugRoot {
    private static final String PROP_CUG_ENABLED = "jcr:content/cq:cugEnabled";
    private static final String PROP_CUG_REALM = "jcr:content/cq:cugRealm";
    private static final String PROP_CUG_LOGIN_PAGE = "jcr:content/cq:cugLoginPage";
    private static final String PROP_CUG_PRINCIPALS = "jcr:content/cq:cugPrincipals";
    private final String root;
    private final String realm;
    private final String loginPage;
    private final String[] principals;
    private final String registrationPath;

    static boolean isEnabled(Node node) throws RepositoryException {
        return node.hasProperty(PROP_CUG_ENABLED) && node.getProperty(PROP_CUG_ENABLED).getBoolean();
    }

    CugRoot(String registrationPath, Node node) throws RepositoryException {
        this.root = node.getPath();
        this.realm = CugRoot.getProperty(node, PROP_CUG_REALM);
        this.loginPage = CugRoot.getProperty(node, PROP_CUG_LOGIN_PAGE);
        this.principals = CugRoot.getProperties(node, PROP_CUG_PRINCIPALS);
        this.registrationPath = registrationPath;
    }

    String getRoot() {
        return this.root;
    }

    String getRealm() {
        return this.realm;
    }

    String getLoginPath() {
        return this.loginPage;
    }

    String[] getPrincipals() {
        return this.principals;
    }

    String getRegistrationPath() {
        return this.registrationPath;
    }

    private static String getProperty(Node node, String relPath) throws RepositoryException {
        if (node.hasProperty(relPath)) {
            return node.getProperty(relPath).getString();
        }
        return null;
    }

    private static String[] getProperties(Node node, String relPath) throws RepositoryException {
        if (node.hasProperty(relPath)) {
            Property prop = node.getProperty(relPath);
            if (prop.getDefinition().isMultiple()) {
                Value[] values = prop.getValues();
                String[] result = new String[values.length];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = values[i].getString();
                }
                return result;
            }
            return new String[]{prop.getString()};
        }
        return null;
    }
}

