////////////////////////////////////////////////////////////////////////////////
//
//  Copyright (C) 2003-2006 Adobe Macromedia Software LLC and its licensors.
//  All Rights Reserved. The following is Source Code and is subject to all
//  restrictions on such code as contained in the End User License Agreement
//  accompanying this product.
//
////////////////////////////////////////////////////////////////////////////////

package mx.charts.chartClasses
{

/**
 *  A bounded value is used to represent a datapoint
 *  that a chart element intends to render on screen.
 *  ChartElements report BoundedValues describing their data
 *  to  an Axis object that the axis computes autogenerated ranges.
 *  A BoundedValue encapsulates both the value of the datapoint
 *  in a particualr dimension, as well as a margin, in pixels,
 *  that a ChartElement needs above or below the value
 *  in order to render it.
 *  Plots on a plot chart, for example, report their data
 *  with margins to accomodate the size of the plots.
 *  A column chart might report a margin in the Y axis
 *  to accomodate a label rendered above the chart.
 */
public class BoundedValue
{
    include "../../core/Version.as";

	//--------------------------------------------------------------------------
	//
	//  Constructor
	//
	//--------------------------------------------------------------------------

	/**
	 *  Constructor.
	 *
	 *  @param value The value to be rendered.
	 *
	 *  @param lowerMargin The lower margin.
	 *
	 *  @param upperMargin The upper margin.
	 */
	public function BoundedValue(value:Number,
								 lowerMargin:Number = 0,
								 upperMargin:Number = 0)
	{
		super();

		this.value = value;
		this.lowerMargin = lowerMargin;
		this.upperMargin = upperMargin;
	}

	//--------------------------------------------------------------------------
	//
	//  Properties
	//
	//--------------------------------------------------------------------------

	//----------------------------------
	//  lowerMargin
	//----------------------------------

	[Inspectable(environment="none")]

	/**
	 *  The margin, in pixels, required below the value
	 *  in order to render properly.
	 */
	public var lowerMargin:Number;

	//----------------------------------
	//  upperMargin
	//----------------------------------

	[Inspectable(environment="none")]

	/** 
	 *  The margin, in pixels, required above the value
	 *  in order to render properly.
	 */
	public var upperMargin:Number;
	
	//----------------------------------
	//  value
	//----------------------------------

	[Inspectable(environment="none")]

	/**
	 *  The value to be rendered.
	 */
	public var value:Number;
}

}
