////////////////////////////////////////////////////////////////////////////////
//
//  Copyright (C) 2003-2006 Adobe Macromedia Software LLC and its licensors.
//  All Rights Reserved. The following is Source Code and is subject to all
//  restrictions on such code as contained in the End User License Agreement
//  accompanying this product.
//
////////////////////////////////////////////////////////////////////////////////

package mx.charts.chartClasses
{

/**
 *  An AxisLabelSet represents the label and tick data
 *  generated by an implementation of IAxis.
 */
public class AxisLabelSet
{
    include "../../core/Version.as";

    //--------------------------------------------------------------------------
    //
    //  Constructor
    //
    //--------------------------------------------------------------------------
    
    /**
     *  Constructor.
     */
    public function AxisLabelSet()
    {
        super();
    }

    //--------------------------------------------------------------------------
    //
    //  Properties
    //
    //--------------------------------------------------------------------------

    //----------------------------------
    //  accurate
    //----------------------------------

    [Inspectable(environment="none")]

    /**
     *  When returned from the <code>getLabelEstimate()</code> method,
     *  set to <code>true</code> if the estimate accurately represents
     *  the final labels to be rendered. This property is irrelevant 
     *  in other contexts.
     */
    public var accurate:Boolean;

    //----------------------------------
    //  labels
    //----------------------------------

    [Inspectable(environment="none")]

    /**
     *  An array of AxisLabel objects
     *  representing the values of the generating axis.
     */
    public var labels:Array /* of AxisLabel */;
    
    //----------------------------------
    //  minorTicks
    //----------------------------------

    [Inspectable(environment="none")]

    /**
     *  An array of values from 0 to 1
     *  representing where to place minor tick marks along the axis.
     */
    public var minorTicks:Array /* of Number */;    
    
    //----------------------------------
    //  ticks
    //----------------------------------

    [Inspectable(environment="none")]

    /**
     *  An array of values from 0 to 1
     *  representing where to place tick marks along the axis.
     */
    public var ticks:Array /* of Number */; 
}

}
