/*
 * Decompiled with CFR 0.152.
 */
package flash.fonts;

import flash.fonts.CachedFontFace;
import flash.swf.tags.DefineFont3;
import flash.swf.types.GlyphEntry;

public class DefineFont3Face
extends CachedFontFace {
    private final DefineFont3 tag;
    private final char[] indicies;
    private char firstChar;

    public DefineFont3Face(DefineFont3 tag) {
        super(tag.codeTable.length + 1);
        this.tag = tag;
        this.style = DefineFont3Face.getStyle(tag);
        this.firstChar = tag.codeTable[0];
        int charCount = tag.codeTable.length;
        char lastChar = tag.codeTable[charCount - 1];
        this.indicies = new char[lastChar + '\u0001'];
        for (int i = 0; i < charCount; i = (int)((char)(i + 1))) {
            char c = tag.codeTable[i];
            this.indicies[c] = i;
        }
        if (tag.license != null) {
            this.copyright = tag.license.copyright;
        }
        if (tag.zones != null && tag.zones.zoneTable != null) {
            this.useTwips = true;
        }
    }

    public boolean canDisplay(char c) {
        if (c < this.indicies.length) {
            char index = this.indicies[c];
            if (c == this.firstChar || index > '\u0000') {
                return true;
            }
        }
        return false;
    }

    public int getAdvance(char c) {
        char index = this.indicies[c];
        return this.tag.advanceTable[index];
    }

    public int getAscent() {
        return this.tag.ascent;
    }

    public int getDescent() {
        return this.tag.descent;
    }

    public double getEmScale() {
        return 1.0;
    }

    public String getFamily() {
        return DefineFont3Face.getFamily(this.tag);
    }

    public int getFirstChar() {
        return this.firstChar;
    }

    public GlyphEntry getGlyphEntry(char c) {
        return (GlyphEntry)this.glyphCache.get(c);
    }

    public int getLineGap() {
        return this.tag.leading;
    }

    public int getMissingGlyphCode() {
        return 0;
    }

    public int getNumGlyphs() {
        return this.tag.codeTable.length;
    }

    public double getPointSize() {
        return 1.0;
    }

    public String getPostscriptName() {
        return DefineFont3Face.getFamily(this.tag);
    }

    public static String getFamily(DefineFont3 tag) {
        String fontName;
        String family = tag.fontName;
        if (tag.license != null && (fontName = tag.license.fontName) != null && !"".equals(fontName)) {
            family = tag.license.fontName;
        }
        return family;
    }

    public static int getStyle(DefineFont3 tag) {
        int style = 0;
        if (tag.bold) {
            ++style;
        }
        if (tag.italic) {
            style += 2;
        }
        return style;
    }

    public static GlyphEntry createGlyphEntryFromDefineFont(char c, char index, DefineFont3 tag) {
        GlyphEntry ge = new GlyphEntry();
        ge.character = c;
        ge.setIndex(index);
        if (tag.glyphShapeTable != null) {
            ge.shape = tag.glyphShapeTable[index];
        }
        if (tag.advanceTable != null) {
            ge.advance = tag.advanceTable[index];
        }
        if (tag.boundsTable != null) {
            ge.bounds = tag.boundsTable[index];
        }
        if (tag.zones != null && tag.zones.zoneTable != null) {
            ge.zoneRecord = tag.zones.zoneTable[index];
        }
        return ge;
    }

    protected GlyphEntry createGlyphEntry(char c) {
        char index = this.indicies[c];
        return DefineFont3Face.createGlyphEntryFromDefineFont(c, index, this.tag);
    }

    protected GlyphEntry createGlyphEntry(char c, char referenceChar) {
        return this.createGlyphEntry(c);
    }
}

