/*
 * Decompiled with CFR 0.152.
 */
package flash.swf;

import flash.swf.Action;
import flash.swf.ActionConstants;
import flash.swf.ActionFactory;
import flash.swf.SwfDecoder;
import flash.swf.SwfFormatException;
import flash.swf.actions.Branch;
import flash.swf.actions.ConstantPool;
import flash.swf.actions.DefineFunction;
import flash.swf.actions.GetURL;
import flash.swf.actions.GetURL2;
import flash.swf.actions.GotoFrame;
import flash.swf.actions.GotoFrame2;
import flash.swf.actions.GotoLabel;
import flash.swf.actions.Push;
import flash.swf.actions.SetTarget;
import flash.swf.actions.StoreRegister;
import flash.swf.actions.StrictMode;
import flash.swf.actions.Try;
import flash.swf.actions.Unknown;
import flash.swf.actions.WaitForFrame;
import flash.swf.actions.With;
import flash.swf.debug.DebugTable;
import flash.swf.debug.LineRecord;
import flash.swf.debug.RegisterRecord;
import flash.swf.types.ActionList;
import flash.swf.types.ClipActionRecord;
import flash.swf.types.ClipActions;
import java.io.IOException;
import java.util.ArrayList;

public class ActionDecoder
implements ActionConstants {
    private SwfDecoder reader;
    private DebugTable debug;
    private boolean keepOffsets;
    private int actionCount;

    public ActionDecoder(SwfDecoder reader) {
        this(reader, null);
    }

    public ActionDecoder(SwfDecoder reader, DebugTable debug) {
        this.reader = reader;
        this.debug = debug;
    }

    public void setKeepOffsets(boolean b) {
        this.keepOffsets = b;
    }

    public ActionList decode(int length) throws IOException {
        return this.decode(length, true);
    }

    public ActionList decode(int length, boolean throwExceptions) throws IOException {
        ActionFactory factory;
        block8: {
            int startOffset = this.reader.getOffset();
            int end = startOffset + length;
            boolean ending = false;
            factory = new ActionFactory(length, startOffset, this.actionCount);
            try {
                int offset = startOffset;
                while (offset < end) {
                    int opcode = this.reader.readUI8();
                    if (opcode > 0) {
                        if (ending) {
                            throw new SwfFormatException("unexpected bytes after sactionEnd: " + opcode);
                        }
                        factory.setActionOffset(this.actionCount, offset);
                        this.decodeAction(opcode, offset, factory);
                        ++this.actionCount;
                    } else {
                        if (opcode != 0) break;
                        ending = true;
                    }
                    offset = this.reader.getOffset();
                }
                factory.setActionOffset(this.actionCount, this.reader.getOffset());
            }
            catch (ArrayIndexOutOfBoundsException aio) {
                if (throwExceptions) {
                    throw aio;
                }
            }
            catch (SwfFormatException swf) {
                if (!throwExceptions) break block8;
                throw swf;
            }
        }
        return factory.createActionList(this.keepOffsets);
    }

    public ClipActions decodeClipActions(int length) throws IOException {
        ClipActions a = new ClipActions();
        this.reader.readUI16();
        a.allEventFlags = this.decodeClipEventFlags(this.reader);
        ArrayList<ClipActionRecord> list = new ArrayList<ClipActionRecord>();
        ClipActionRecord record = this.decodeClipActionRecord();
        while (record != null) {
            list.add(record);
            record = this.decodeClipActionRecord();
        }
        a.clipActionRecords = list;
        return a;
    }

    private ClipActionRecord decodeClipActionRecord() throws IOException {
        int flags = this.decodeClipEventFlags(this.reader);
        if (flags != 0) {
            ClipActionRecord c = new ClipActionRecord();
            c.eventFlags = flags;
            int size = (int)this.reader.readUI32();
            if ((flags & 0x20000) != 0) {
                --size;
                c.keyCode = this.reader.readUI8();
            }
            c.actionList = this.decode(size);
            return c;
        }
        return null;
    }

    private int decodeClipEventFlags(SwfDecoder r) throws IOException {
        int flags = r.swfVersion >= 6 ? (int)r.readUI32() : r.readUI16();
        return flags;
    }

    private void decodeAction(int opcode, int offset, ActionFactory factory) throws IOException {
        Action a;
        RegisterRecord record;
        LineRecord line;
        LineRecord lineRecord = line = this.debug != null ? this.debug.getLine(offset) : null;
        if (line != null) {
            factory.setLine(offset, line);
        }
        RegisterRecord registerRecord = record = this.debug != null ? this.debug.getRegisters(offset) : null;
        if (record != null) {
            factory.setRegister(offset, record);
        }
        if (opcode < 128) {
            Action a2 = ActionFactory.createAction(opcode);
            factory.setAction(offset, a2);
            return;
        }
        int len = this.reader.readUI16();
        int pos = offset + 3;
        switch (opcode) {
            case 155: {
                DefineFunction a3 = this.decodeDefineFunction(pos, len);
                factory.setAction(offset, a3);
                return;
            }
            case 142: {
                DefineFunction a4 = this.decodeDefineFunction2(pos, len);
                factory.setAction(offset, a4);
                return;
            }
            case 148: {
                a = this.decodeWith(factory);
                break;
            }
            case 143: {
                a = this.decodeTry(factory);
                break;
            }
            case 150: {
                Push p = this.decodePush(offset, pos + len, factory);
                this.checkConsumed(pos, len, p);
                return;
            }
            case 137: {
                a = this.decodeStrictMode();
                break;
            }
            case 158: {
                a = ActionFactory.createCall();
                break;
            }
            case 129: {
                a = this.decodeGotoFrame();
                break;
            }
            case 131: {
                a = this.decodeGetURL();
                break;
            }
            case 135: {
                a = this.decodeStoreRegister();
                break;
            }
            case 136: {
                a = this.decodeConstantPool();
                break;
            }
            case 138: {
                a = this.decodeWaitForFrame(opcode, factory);
                break;
            }
            case 139: {
                a = this.decodeSetTarget();
                break;
            }
            case 140: {
                a = this.decodeGotoLabel();
                break;
            }
            case 141: {
                a = this.decodeWaitForFrame(opcode, factory);
                break;
            }
            case 154: {
                a = this.decodeGetURL2();
                break;
            }
            case 153: 
            case 157: {
                a = this.decodeBranch(opcode, factory);
                break;
            }
            case 159: {
                a = this.decodeGotoFrame2();
                break;
            }
            default: {
                a = this.decodeUnknown(opcode, len);
            }
        }
        this.checkConsumed(pos, len, a);
        factory.setAction(offset, a);
    }

    private Try decodeTry(ActionFactory factory) throws IOException {
        Try a = new Try();
        a.flags = this.reader.readUI8();
        int trySize = this.reader.readUI16();
        int catchSize = this.reader.readUI16();
        int finallySize = this.reader.readUI16();
        if (a.hasRegister()) {
            a.catchReg = this.reader.readUI8();
        } else {
            a.catchName = this.reader.readString();
        }
        int tryEnd = this.reader.getOffset() + trySize;
        a.endTry = factory.getLabel(tryEnd);
        if (a.hasCatch()) {
            a.endCatch = factory.getLabel(tryEnd + catchSize);
        }
        if (a.hasFinally()) {
            a.endFinally = factory.getLabel(tryEnd + finallySize + (a.hasCatch() ? catchSize : 0));
        }
        return a;
    }

    private GotoFrame2 decodeGotoFrame2() throws IOException {
        GotoFrame2 a = new GotoFrame2();
        a.playFlag = this.reader.readUI8();
        return a;
    }

    private Branch decodeBranch(int code, ActionFactory factory) throws IOException {
        Branch a = new Branch(code);
        int offset = this.reader.readSI16();
        int target = offset + this.reader.getOffset();
        a.target = factory.getLabel(target);
        return a;
    }

    private WaitForFrame decodeWaitForFrame(int opcode, ActionFactory factory) throws IOException {
        WaitForFrame a = new WaitForFrame(opcode);
        if (opcode == 138) {
            a.frame = this.reader.readUI16();
        }
        int skipCount = this.reader.readUI8();
        int skipTarget = this.actionCount + 1 + skipCount;
        factory.addSkipEntry(a, skipTarget);
        return a;
    }

    private GetURL2 decodeGetURL2() throws IOException {
        GetURL2 a = new GetURL2();
        a.method = this.reader.readUI8();
        return a;
    }

    private GotoLabel decodeGotoLabel() throws IOException {
        GotoLabel a = new GotoLabel();
        a.label = this.reader.readString();
        return a;
    }

    private SetTarget decodeSetTarget() throws IOException {
        SetTarget a = new SetTarget();
        a.targetName = this.reader.readString();
        return a;
    }

    private ConstantPool decodeConstantPool() throws IOException {
        ConstantPool cpool = new ConstantPool();
        int count = this.reader.readUI16();
        cpool.pool = new String[count];
        for (int i = 0; i < count; ++i) {
            cpool.pool[i] = this.reader.readString();
        }
        return cpool;
    }

    private StoreRegister decodeStoreRegister() throws IOException {
        int register = this.reader.readUI8();
        return ActionFactory.createStoreRegister(register);
    }

    private GetURL decodeGetURL() throws IOException {
        GetURL a = new GetURL();
        a.url = this.reader.readString();
        a.target = this.reader.readString();
        return a;
    }

    private GotoFrame decodeGotoFrame() throws IOException {
        GotoFrame a = new GotoFrame();
        a.frame = this.reader.readUI16();
        return a;
    }

    private Unknown decodeUnknown(int opcode, int length) throws IOException {
        Unknown a = new Unknown(opcode);
        a.data = new byte[length];
        this.reader.readFully(a.data);
        return a;
    }

    private StrictMode decodeStrictMode() throws IOException {
        boolean mode = this.reader.readUI8() != 0;
        return ActionFactory.createStrictMode(mode);
    }

    /*
     * WARNING - void declaration
     */
    private Push decodePush(int offset, int end, ActionFactory factory) throws IOException {
        void var4_4;
        do {
            int pushType = this.reader.readUI8();
            switch (pushType) {
                case 0: {
                    Push p = ActionFactory.createPush(this.reader.readString());
                    break;
                }
                case 1: {
                    float fvalue = Float.intBitsToFloat((int)this.reader.readUI32());
                    Push p = ActionFactory.createPush(fvalue);
                    break;
                }
                case 2: {
                    Push p = ActionFactory.createPushNull();
                    break;
                }
                case 3: {
                    Push p = ActionFactory.createPushUndefined();
                    break;
                }
                case 4: {
                    Push p = ActionFactory.createPushRegister(this.reader.readUI8());
                    break;
                }
                case 5: {
                    Push p = ActionFactory.createPush(this.reader.readUI8() != 0);
                    break;
                }
                case 6: {
                    long hx = this.reader.readUI32();
                    long lx = this.reader.readUI32();
                    Push p = ActionFactory.createPush(Double.longBitsToDouble(hx << 32 | lx & 0xFFFFFFFFL));
                    break;
                }
                case 7: {
                    Push p = ActionFactory.createPush((int)this.reader.readUI32());
                    break;
                }
                case 8: {
                    Push p = ActionFactory.createPushCpool(this.reader.readUI8());
                    break;
                }
                case 9: {
                    Push p = ActionFactory.createPushCpool(this.reader.readUI16());
                    break;
                }
                default: {
                    throw new SwfFormatException("Unknown push data type " + pushType);
                }
            }
            factory.setAction(offset, (Action)var4_4);
        } while ((offset = this.reader.getOffset()) < end);
        return var4_4;
    }

    private DefineFunction decodeDefineFunction(int pos, int len) throws IOException {
        DefineFunction a = new DefineFunction(155);
        a.name = this.reader.readString();
        int number = this.reader.readUI16();
        a.params = new String[number];
        for (int i = 0; i < number; ++i) {
            a.params[i] = this.reader.readString();
        }
        a.codeSize = this.reader.readUI16();
        this.checkConsumed(pos, len, a);
        a.actionList = this.decode(a.codeSize);
        return a;
    }

    private DefineFunction decodeDefineFunction2(int pos, int len) throws IOException {
        DefineFunction a = new DefineFunction(142);
        a.name = this.reader.readString();
        int number = this.reader.readUI16();
        a.params = new String[number];
        a.paramReg = new int[number];
        a.regCount = this.reader.readUI8();
        a.flags = this.reader.readUI16();
        for (int i = 0; i < number; ++i) {
            a.paramReg[i] = this.reader.readUI8();
            a.params[i] = this.reader.readString();
        }
        a.codeSize = this.reader.readUI16();
        this.checkConsumed(pos, len, a);
        a.actionList = this.decode(a.codeSize);
        return a;
    }

    private void checkConsumed(int pos, int len, Action a) throws IOException {
        int consumed = this.reader.getOffset() - pos;
        if (consumed != len) {
            throw new SwfFormatException(a.getClass().getName() + ": " + consumed + " was read. " + len + " was required.");
        }
    }

    private With decodeWith(ActionFactory factory) throws IOException {
        With a = new With();
        int size = this.reader.readUI16();
        int target = size + this.reader.getOffset();
        a.endWith = factory.getLabel(target);
        return a;
    }
}

