/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom.text;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.internal.fxg.dom.DOMParserHelper;
import com.adobe.internal.fxg.dom.text.AbstractTextNode;
import com.adobe.internal.fxg.dom.types.Kerning;
import com.adobe.internal.fxg.dom.types.LineBreak;
import com.adobe.internal.fxg.dom.types.WhiteSpaceCollapse;

public abstract class AbstractCharacterTextNode
extends AbstractTextNode {
    protected static final double FONTSIZE_MIN_INCLUSIVE = 1.0;
    protected static final double FONTSIZE_MAX_INCLUSIVE = 720.0;
    public String fontFamily = "Times New Roman";
    public double fontSize = 12.0;
    public String fontStyle = "normal";
    public String fontWeight = "normal";
    public double lineHeight = 120.0;
    public String textDecoration = "none";
    public WhiteSpaceCollapse whiteSpaceCollapse = WhiteSpaceCollapse.PRESERVE;
    public LineBreak lineBreak = LineBreak.TOFIT;
    public double tracking = 0.0;
    public Kerning kerning = Kerning.AUTO;
    public double textAlpha = 1.0;
    public int color = -16777216;
    public boolean lineThrough = false;

    public void setAttribute(String name, String value) {
        if ("fontFamily".equals(name)) {
            this.fontFamily = value;
        } else if ("fontSize".equals(name)) {
            this.fontSize = DOMParserHelper.parseDouble(this, value, name, 1.0, 720.0, this.fontSize);
        } else if ("fontStyle".equals(name)) {
            this.fontStyle = value;
        } else if ("fontWeight".equals(name)) {
            this.fontWeight = value;
        } else if ("lineHeight".equals(name)) {
            this.lineHeight = DOMParserHelper.parsePercent(this, value, name);
        } else if ("textDecoration".equals(name)) {
            this.textDecoration = value;
        } else if ("whiteSpaceCollapse".equals(name)) {
            this.whiteSpaceCollapse = AbstractCharacterTextNode.getWhiteSpaceCollapse(this, value);
        } else if ("lineBreak".equals(name)) {
            this.lineBreak = AbstractCharacterTextNode.getLineBreak(this, value);
        } else if ("tracking".equals(name)) {
            this.tracking = DOMParserHelper.parsePercent(this, value, name);
        } else if ("kerning".equals(name)) {
            this.kerning = AbstractCharacterTextNode.getKerning(this, value);
        } else if ("textAlpha".equals(name)) {
            this.textAlpha = DOMParserHelper.parseDouble(this, value, name, 0.0, 1.0, this.textAlpha);
        } else if ("color".equals(name)) {
            this.color = DOMParserHelper.parseRGB(this, value, name);
        } else if ("lineThrough".equals(name)) {
            this.lineThrough = DOMParserHelper.parseBoolean(this, value, name);
        } else {
            super.setAttribute(name, value);
            return;
        }
        this.rememberAttribute(name, value);
    }

    public static Kerning getKerning(FXGNode node, String value) {
        if ("auto".equals(value)) {
            return Kerning.AUTO;
        }
        if ("on".equals(value)) {
            return Kerning.ON;
        }
        if ("off".equals(value)) {
            return Kerning.OFF;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownKerning", value);
    }

    public static LineBreak getLineBreak(FXGNode node, String value) {
        if ("toFit".equals(value)) {
            return LineBreak.TOFIT;
        }
        if ("explicit".equals(value)) {
            return LineBreak.EXPLICIT;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownLineBreak", value);
    }

    public static WhiteSpaceCollapse getWhiteSpaceCollapse(FXGNode node, String value) {
        if ("preserve".equals(value)) {
            return WhiteSpaceCollapse.PRESERVE;
        }
        if ("collapse".equals(value)) {
            return WhiteSpaceCollapse.COLLAPSE;
        }
        throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownWhiteSpaceCollapse", value);
    }
}

