/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.internal.fxg.dom.types.InterpolationMethod;
import com.adobe.internal.fxg.dom.types.MaskType;
import com.adobe.internal.fxg.dom.types.SpreadMethod;

public abstract class AbstractFXGNode
implements FXGNode {
    protected static final double ALPHA_MIN_INCLUSIVE = 0.0;
    protected static final double ALPHA_MAX_INCLUSIVE = 1.0;
    protected static final int COLOR_BLACK = -16777216;
    protected static final int COLOR_WHITE = -1;
    protected static final int COLOR_RED = -65536;
    protected static final int GRADIENT_ENTRIES_MAX_INCLUSIVE = 16;
    protected FXGNode documentNode;
    protected String uri;
    protected int startLine;
    protected int startColumn;
    protected int endLine;
    protected int endColumn;
    public static final double EPSILON = 1.0E-5;

    public void addChild(FXGNode child) {
        if (child == null) {
            throw new FXGException("InvalidChildNode", null, this.getNodeName());
        }
        throw new FXGException(child.getStartLine(), child.getStartColumn(), "InvalidChildNode", child.getNodeName(), this.getNodeName());
    }

    public void setAttribute(String name, String value) {
        throw new FXGException(this.getStartLine(), this.getStartColumn(), "InvalidNodeAttribute", name, this.getNodeName());
    }

    public FXGNode getDocumentNode() {
        return this.documentNode;
    }

    public void setDocumentNode(FXGNode root) {
        this.documentNode = root;
    }

    public String getNodeURI() {
        return this.uri;
    }

    public void setNodeURI(String uri) {
        this.uri = uri;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public void setStartLine(int line) {
        this.startLine = line;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public void setStartColumn(int column) {
        this.startColumn = column;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void setEndLine(int line) {
        this.endLine = line;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public void setEndColumn(int column) {
        this.endColumn = column;
    }

    protected boolean parseBoolean(String value) {
        return Boolean.parseBoolean(value);
    }

    protected int parseRGB(String value) {
        if ((value = value.trim()).charAt(0) == '#') {
            value = value.substring(1);
        } else if (value.startsWith("0x")) {
            value = value.substring(2);
        }
        int a = 255;
        int r = 0;
        int g = 0;
        int b = 0;
        if (value.length() != 6) {
            throw new FXGException(this.getStartLine(), this.getStartColumn(), "InvalidColorValue", new Object[0]);
        }
        r = Integer.parseInt(value.substring(0, 2), 16) & 0xFF;
        g = Integer.parseInt(value.substring(2, 4), 16) & 0xFF;
        b = Integer.parseInt(value.substring(4, 6), 16) & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    protected double parseDouble(String value) {
        return Double.parseDouble(value);
    }

    protected double parsePercent(String value) {
        if ((value = value.trim()).charAt(value.length() - 1) == '%') {
            value = value.substring(0, value.length() - 1);
            value = value.trim();
        }
        return Double.parseDouble(value);
    }

    protected float parseFloat(String value) {
        return Float.parseFloat(value);
    }

    protected double parseDouble(String value, double min, double max) {
        double d = Double.parseDouble(value);
        if (d >= min && d <= max) {
            return d;
        }
        throw new FXGException(this.getStartLine(), this.getStartColumn(), "OutOfRangeValue", value, min, max);
    }

    protected int parseInt(String value, int min, int max) {
        int i = Integer.parseInt(value);
        if (i >= min && i <= max) {
            return i;
        }
        throw new FXGException(this.getStartLine(), this.getStartColumn(), "OutOfRangeValue", value, min, max);
    }

    protected InterpolationMethod parseInterpolationMethod(String value) {
        if ("rgb".equals(value)) {
            return InterpolationMethod.RGB;
        }
        if ("linearRGB".equals(value)) {
            return InterpolationMethod.LINEAR_RGB;
        }
        throw new FXGException(this.getStartLine(), this.getStartColumn(), "UnknownInterpolationMethod", value);
    }

    protected MaskType parseMaskType(String value) {
        if ("clip".equals(value)) {
            return MaskType.CLIP;
        }
        if ("alpha".equals(value)) {
            return MaskType.ALPHA;
        }
        throw new FXGException(this.getStartLine(), this.getStartColumn(), "UnknownMaskType", value);
    }

    protected SpreadMethod parseSpreadMethod(String value) {
        if ("pad".equals(value)) {
            return SpreadMethod.PAD;
        }
        if ("reflect".equals(value)) {
            return SpreadMethod.REFLECT;
        }
        if ("repeat".equals(value)) {
            return SpreadMethod.REPEAT;
        }
        throw new FXGException(this.getStartLine(), this.getStartColumn(), "UnknownSpreadMethod", value);
    }
}

