/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fxg.swf;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.FXGTranscoder;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.fxg.util.FXGResourceResolver;
import com.adobe.internal.fxg.dom.AbstractShapeNode;
import com.adobe.internal.fxg.dom.BitmapGraphicNode;
import com.adobe.internal.fxg.dom.DefinitionNode;
import com.adobe.internal.fxg.dom.EllipseNode;
import com.adobe.internal.fxg.dom.FillNode;
import com.adobe.internal.fxg.dom.FilterNode;
import com.adobe.internal.fxg.dom.GradientEntryNode;
import com.adobe.internal.fxg.dom.GraphicContentNode;
import com.adobe.internal.fxg.dom.GraphicContext;
import com.adobe.internal.fxg.dom.GraphicNode;
import com.adobe.internal.fxg.dom.GroupDefinitionNode;
import com.adobe.internal.fxg.dom.GroupNode;
import com.adobe.internal.fxg.dom.LineNode;
import com.adobe.internal.fxg.dom.MaskableNode;
import com.adobe.internal.fxg.dom.MaskingNode;
import com.adobe.internal.fxg.dom.PathNode;
import com.adobe.internal.fxg.dom.PlaceObjectNode;
import com.adobe.internal.fxg.dom.RectNode;
import com.adobe.internal.fxg.dom.StrokeNode;
import com.adobe.internal.fxg.dom.TextGraphicNode;
import com.adobe.internal.fxg.dom.fills.BitmapFillNode;
import com.adobe.internal.fxg.dom.fills.LinearGradientFillNode;
import com.adobe.internal.fxg.dom.fills.RadialGradientFillNode;
import com.adobe.internal.fxg.dom.fills.SolidColorFillNode;
import com.adobe.internal.fxg.dom.filters.AbstractFilterNode;
import com.adobe.internal.fxg.dom.filters.BevelFilterNode;
import com.adobe.internal.fxg.dom.filters.BlurFilterNode;
import com.adobe.internal.fxg.dom.filters.ColorMatrixFilterNode;
import com.adobe.internal.fxg.dom.filters.DropShadowFilterNode;
import com.adobe.internal.fxg.dom.filters.GlowFilterNode;
import com.adobe.internal.fxg.dom.filters.GradientBevelFilterNode;
import com.adobe.internal.fxg.dom.filters.GradientGlowFilterNode;
import com.adobe.internal.fxg.dom.strokes.LinearGradientStrokeNode;
import com.adobe.internal.fxg.dom.strokes.RadialGradientStrokeNode;
import com.adobe.internal.fxg.dom.strokes.SolidColorStrokeNode;
import com.adobe.internal.fxg.dom.transforms.ColorTransformNode;
import com.adobe.internal.fxg.dom.types.BevelType;
import com.adobe.internal.fxg.dom.types.BlendMode;
import com.adobe.internal.fxg.dom.types.Caps;
import com.adobe.internal.fxg.dom.types.InterpolationMethod;
import com.adobe.internal.fxg.dom.types.Joints;
import com.adobe.internal.fxg.dom.types.MaskType;
import com.adobe.internal.fxg.dom.types.ScaleMode;
import com.adobe.internal.fxg.dom.types.ScalingGrid;
import com.adobe.internal.fxg.dom.types.SpreadMethod;
import com.adobe.internal.fxg.dom.types.Winding;
import com.adobe.internal.fxg.swf.ImageHelper;
import com.adobe.internal.fxg.swf.ShapeHelper;
import com.adobe.internal.fxg.swf.TypeHelper;
import flash.swf.builder.types.PathIteratorWrapper;
import flash.swf.builder.types.ShapeBuilder;
import flash.swf.builder.types.ShapeIterator;
import flash.swf.tags.DefineBits;
import flash.swf.tags.DefineScalingGrid;
import flash.swf.tags.DefineShape;
import flash.swf.tags.DefineSprite;
import flash.swf.tags.DefineTag;
import flash.swf.tags.PlaceObject;
import flash.swf.types.BevelFilter;
import flash.swf.types.BlurFilter;
import flash.swf.types.CXForm;
import flash.swf.types.CXFormWithAlpha;
import flash.swf.types.ColorMatrixFilter;
import flash.swf.types.DropShadowFilter;
import flash.swf.types.FillStyle;
import flash.swf.types.Filter;
import flash.swf.types.FocalGradient;
import flash.swf.types.GlowFilter;
import flash.swf.types.GradRecord;
import flash.swf.types.Gradient;
import flash.swf.types.GradientBevelFilter;
import flash.swf.types.GradientGlowFilter;
import flash.swf.types.LineStyle;
import flash.swf.types.Matrix;
import flash.swf.types.Rect;
import flash.swf.types.ShapeRecord;
import flash.swf.types.ShapeWithStyle;
import flash.swf.types.TagList;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FXG2SWFTranscoder
implements FXGTranscoder {
    protected HashMap<String, DefineSprite> definitions;
    protected Stack<DefineSprite> spriteStack = new Stack();
    protected FXGResourceResolver resourceResolver;
    protected int spriteCount;

    public FXG2SWFTranscoder newInstance() {
        return new FXG2SWFTranscoder();
    }

    @Override
    public void setResourceResolver(FXGResourceResolver resolver) {
        this.resourceResolver = resolver;
    }

    @Override
    public Object transcode(FXGNode fxgNode) {
        GraphicNode node = (GraphicNode)fxgNode;
        DefineSprite sprite = this.createDefineSprite();
        this.spriteStack.push(sprite);
        if (node.mask != null) {
            this.mask(node, sprite);
        }
        if (node.definesScaleGrid()) {
            DefineScalingGrid grid = this.createDefineScalingGrid(node.getScalingGrid());
            grid.scalingTarget = sprite;
            sprite.scalingGrid = grid;
        }
        if (node.children != null) {
            this.graphicContentNodes(node.children);
        }
        this.spriteStack.pop();
        return sprite;
    }

    protected PlaceObject bitmap(BitmapGraphicNode node) {
        double width = node.width;
        double height = node.height;
        GraphicContext context = node.createGraphicContext();
        if (node.visible) {
            DefineShape imageShape;
            String source = this.parseSource(node.source);
            DefineBits imageTag = this.createDefineBits(node, source, width, height);
            ScalingGrid scalingGrid = context.scalingGrid;
            if (scalingGrid != null) {
                Rect grid = TypeHelper.rect(scalingGrid.scaleGridLeft, scalingGrid.scaleGridTop, scalingGrid.scaleGridRight, scalingGrid.scaleGridBottom);
                imageShape = ImageHelper.create9SlicedShape(imageTag, grid, Double.NaN, Double.NaN);
            } else {
                imageShape = ImageHelper.createShapeForImage(imageTag, width, height, node.repeat);
            }
            PlaceObject po3 = this.placeObject((DefineTag)imageShape, context);
            return po3;
        }
        List<ShapeRecord> shapeRecords = ShapeHelper.rectangle(0.0, 0.0, width, height);
        DefineShape shape = this.createDefineShape(shapeRecords, null, null, context.getAffineTransform());
        PlaceObject po3 = this.placeObject((DefineTag)shape, context);
        return po3;
    }

    protected void graphicContentNodes(List<GraphicContentNode> nodes) {
        for (GraphicContentNode node : nodes) {
            this.graphicContentNode(node);
        }
    }

    protected PlaceObject graphicContentNode(GraphicContentNode node) {
        PlaceObject po3 = null;
        if (!node.visible) {
            ColorTransformNode ct = new ColorTransformNode();
            ct.alphaMultiplier = 0.0;
            ct.alphaOffset = 0.0;
            ct.blueMultiplier = 1.0;
            ct.blueOffset = 0.0;
            ct.greenMultiplier = 1.0;
            ct.greenOffset = 0.0;
            ct.redMultiplier = 1.0;
            ct.redOffset = 0.0;
            node.colorTransform = ct;
            if (node instanceof AbstractShapeNode) {
                AbstractShapeNode shapeNode = (AbstractShapeNode)node;
                shapeNode.fill = null;
                shapeNode.stroke = null;
            }
        }
        if (node instanceof GroupNode) {
            this.group((GroupNode)node);
        } else {
            if (node.mask != null) {
                DefineSprite parentSprite = this.spriteStack.peek();
                this.mask(node, parentSprite);
            }
            if (node instanceof EllipseNode) {
                po3 = this.ellipse((EllipseNode)node);
            } else if (node instanceof LineNode) {
                po3 = this.line((LineNode)node);
            } else if (node instanceof PathNode) {
                po3 = this.path((PathNode)node);
            } else if (node instanceof RectNode) {
                po3 = this.rect((RectNode)node);
            } else if (node instanceof PlaceObjectNode) {
                po3 = this.placeObjectInstance((PlaceObjectNode)node);
            } else if (node instanceof BitmapGraphicNode) {
                po3 = this.bitmap((BitmapGraphicNode)node);
            } else if (node instanceof TextGraphicNode) {
                po3 = this.text((TextGraphicNode)node);
            }
        }
        return po3;
    }

    protected PlaceObject ellipse(EllipseNode node) {
        Ellipse2D.Double ellipse = new Ellipse2D.Double(0.0, 0.0, node.width, node.height);
        GraphicContext context = node.createGraphicContext();
        DefineShape shape = this.createDefineShape(ellipse, node.fill, node.stroke, context.getAffineTransform());
        PlaceObject po3 = this.placeObject((DefineTag)shape, context);
        return po3;
    }

    protected PlaceObject group(GroupNode node) {
        DefineSprite groupSprite = this.createDefineSprite();
        GraphicContext context = node.createGraphicContext();
        if (node.definesScaleGrid()) {
            DefineScalingGrid grid = this.createDefineScalingGrid(context.scalingGrid);
            grid.scalingTarget = groupSprite;
            groupSprite.scalingGrid = grid;
        }
        PlaceObject po3 = this.placeObject((DefineTag)groupSprite, context);
        this.spriteStack.push(groupSprite);
        if (node.mask != null) {
            this.mask(node, groupSprite);
        }
        if (node.children != null) {
            this.graphicContentNodes(node.children);
        }
        this.spriteStack.pop();
        return po3;
    }

    protected PlaceObject line(LineNode node) {
        List<ShapeRecord> shapeRecords = ShapeHelper.line(node.xFrom, node.yFrom, node.xTo, node.yTo);
        GraphicContext context = node.createGraphicContext();
        DefineShape shape = this.createDefineShape(shapeRecords, node.fill, node.stroke, context.getAffineTransform());
        PlaceObject po3 = this.placeObject((DefineTag)shape, context);
        return po3;
    }

    protected PlaceObject mask(MaskableNode node, DefineSprite parentSprite) {
        PlaceObject po3 = null;
        MaskingNode mask = node.getMask();
        if (mask instanceof GroupNode) {
            po3 = this.group((GroupNode)mask);
        } else if (mask instanceof PlaceObjectNode) {
            po3 = this.placeObjectInstance((PlaceObjectNode)mask);
        }
        if (po3 != null) {
            int clipDepth = 1;
            if (node instanceof GroupNode) {
                GroupNode group = (GroupNode)node;
                if (group.children != null) {
                    clipDepth = parentSprite.depthCounter + group.children.size();
                }
            } else if (node instanceof GraphicNode) {
                GraphicNode graphic = (GraphicNode)node;
                if (graphic.children != null) {
                    clipDepth = parentSprite.depthCounter + graphic.children.size();
                }
            } else {
                clipDepth = po3.depth + 1;
            }
            po3.setClipDepth(clipDepth);
            if (node.getMaskType() == MaskType.ALPHA) {
                po3.setCacheAsBitmap(true);
            }
        }
        return po3;
    }

    protected PlaceObject path(PathNode node) {
        List<ShapeRecord> shapeRecords = ShapeHelper.path(node.data, node.fill != null);
        GraphicContext context = node.createGraphicContext();
        DefineShape shape = this.createDefineShape(shapeRecords, node.fill, node.winding, node.stroke, context.getAffineTransform());
        PlaceObject po3 = this.placeObject((DefineTag)shape, context);
        return po3;
    }

    protected PlaceObject placeObject(DefineTag symbol, GraphicContext context) {
        DefineSprite sprite = this.spriteStack.peek();
        PlaceObject po3 = new PlaceObject(70);
        po3.setRef(symbol);
        po3.depth = ++sprite.depthCounter;
        if (context.blendMode != null) {
            int blendMode = this.createBlendMode(context.blendMode);
            po3.setBlendMode(blendMode);
        }
        if (context.filters != null) {
            List<Filter> filters = this.createFilters(context.filters);
            po3.setFilterList(filters);
        }
        Matrix matrix = TypeHelper.matrix(context.getAffineTransform(), true);
        po3.setMatrix(matrix);
        if (context.colorTransform != null) {
            ColorTransformNode t = context.colorTransform;
            CXFormWithAlpha cx = TypeHelper.cxFormWithAlpha(t.alphaMultiplier, t.redMultiplier, t.greenMultiplier, t.blueMultiplier, t.alphaOffset, t.redOffset, t.greenOffset, t.blueOffset);
            po3.setCxform((CXForm)cx);
        }
        if (context.maskType == MaskType.ALPHA) {
            po3.setCacheAsBitmap(true);
        }
        sprite.tagList.placeObject3(po3);
        return po3;
    }

    protected PlaceObject rect(RectNode node) {
        GraphicContext context = node.createGraphicContext();
        List<ShapeRecord> shapeRecords = node.radiusX != 0.0 || node.radiusY != 0.0 ? ShapeHelper.rectangle(0.0, 0.0, node.width, node.height, node.radiusX, node.radiusY) : ShapeHelper.rectangle(0.0, 0.0, node.width, node.height);
        DefineShape shape = this.createDefineShape(shapeRecords, node.fill, node.stroke, context.getAffineTransform());
        PlaceObject po3 = this.placeObject((DefineTag)shape, context);
        return po3;
    }

    protected PlaceObject text(TextGraphicNode node) {
        return null;
    }

    protected PlaceObject placeObjectInstance(PlaceObjectNode node) {
        DefineSprite definitionSprite;
        String definitionName = node.getNodeName();
        if (this.definitions == null) {
            this.definitions = new HashMap();
        }
        if ((definitionSprite = this.definitions.get(definitionName)) == null) {
            definitionSprite = this.createDefineSprite();
            FXG2SWFTranscoder graphics = this.newInstance();
            graphics.setResourceResolver(this.resourceResolver);
            this.definitions.put(definitionName, definitionSprite);
            graphics.definitions = this.definitions;
            graphics.definition(node.definition, definitionSprite);
        }
        PlaceObject po3 = this.placeObject((DefineTag)definitionSprite, node.createGraphicContext());
        return po3;
    }

    protected void definition(DefinitionNode node, DefineSprite definitionSprite) {
        GroupDefinitionNode groupDefinition = node.groupDefinition;
        if (groupDefinition == null) {
            throw new FXGException(node.getStartLine(), node.getStartColumn(), "MissingGroupChildNode", new Object[0]);
        }
        this.spriteStack.push(definitionSprite);
        if (groupDefinition.definesScaleGrid()) {
            definitionSprite.scalingGrid = this.createDefineScalingGrid(groupDefinition.getScalingGrid());
            definitionSprite.scalingGrid.scalingTarget = definitionSprite;
        }
        this.graphicContentNodes(groupDefinition.children);
        this.spriteStack.pop();
    }

    protected DefineBits createDefineBits(FXGNode node, String source, double width, double height) {
        try {
            InputStream stream = this.resourceResolver.openStream(source);
            DefineBits imageTag = ImageHelper.createDefineBits(stream, ImageHelper.guessMimeType(source));
            return imageTag;
        }
        catch (IOException ioe) {
            throw new FXGException(node.getStartLine(), node.getStartColumn(), "ErrorEmbeddingImage", ioe.getMessage(), source);
        }
    }

    protected DefineScalingGrid createDefineScalingGrid(ScalingGrid grid) {
        DefineScalingGrid scalingGrid = new DefineScalingGrid();
        scalingGrid.rect = TypeHelper.rect(grid.scaleGridLeft, grid.scaleGridTop, grid.scaleGridRight, grid.scaleGridBottom);
        return scalingGrid;
    }

    protected DefineSprite createDefineSprite() {
        DefineSprite sprite = new DefineSprite();
        sprite.tagList = new TagList();
        sprite.framecount = 1;
        sprite.name = "FXGSprite" + this.spriteCount++;
        return sprite;
    }

    protected DefineShape createDefineShape(Shape shape2d, FillNode fill, StrokeNode stroke, AffineTransform transform) {
        ShapeBuilder builder = new ShapeBuilder();
        PathIteratorWrapper iterator = new PathIteratorWrapper(shape2d.getPathIterator(null));
        builder.processShape((ShapeIterator)iterator);
        flash.swf.types.Shape shape = builder.build();
        return this.createDefineShape(shape.shapeRecords, fill, stroke, transform);
    }

    protected DefineShape createDefineShape(List<ShapeRecord> shapeRecords, FillNode fill, StrokeNode stroke, AffineTransform transform) {
        Rect edgeBounds;
        Rect bounds = edgeBounds = ShapeHelper.getBounds(shapeRecords, null);
        ShapeWithStyle sws = new ShapeWithStyle();
        sws.shapeRecords = shapeRecords;
        int lineStyleIndex = stroke == null ? 0 : 1;
        int fillStyle0Index = fill == null ? 0 : 1;
        int fillStyle1Index = 0;
        ShapeHelper.setStyles(shapeRecords, lineStyleIndex, fillStyle0Index, fillStyle1Index);
        if (fill != null) {
            FillStyle fillStyle = this.createFillStyle(fill, edgeBounds);
            sws.fillstyles = new ArrayList(1);
            sws.fillstyles.add(fillStyle);
        }
        if (stroke != null) {
            LineStyle lineStyle = this.createLineStyle(stroke, edgeBounds);
            sws.linestyles = new ArrayList(1);
            sws.linestyles.add(lineStyle);
            bounds = ShapeHelper.getBounds(shapeRecords, sws.linestyles);
        }
        DefineShape defineShape4 = new DefineShape(83);
        defineShape4.shapeWithStyle = sws;
        defineShape4.bounds = bounds;
        defineShape4.edgeBounds = edgeBounds;
        return defineShape4;
    }

    protected DefineShape createDefineShape(List<ShapeRecord> shapeRecords, FillNode fill, Winding windingValue, StrokeNode stroke, AffineTransform transform) {
        Rect edgeBounds;
        Rect bounds = edgeBounds = ShapeHelper.getBounds(shapeRecords, null);
        ShapeWithStyle sws = new ShapeWithStyle();
        sws.shapeRecords = shapeRecords;
        int lineStyleIndex = stroke == null ? 0 : 1;
        int fillStyle0Index = fill == null ? 0 : 1;
        int fillStyle1Index = 0;
        ShapeHelper.setPathStyles(shapeRecords, lineStyleIndex, fillStyle0Index, fillStyle1Index);
        if (fill != null) {
            FillStyle fillStyle = this.createFillStyle(fill, edgeBounds);
            sws.fillstyles = new ArrayList(1);
            sws.fillstyles.add(fillStyle);
        }
        if (stroke != null) {
            LineStyle lineStyle = this.createLineStyle(stroke, edgeBounds);
            sws.linestyles = new ArrayList();
            sws.linestyles.add(lineStyle);
            bounds = ShapeHelper.getBounds(shapeRecords, sws.linestyles);
        }
        DefineShape defineShape4 = new DefineShape(83);
        defineShape4.shapeWithStyle = sws;
        defineShape4.bounds = bounds;
        defineShape4.edgeBounds = edgeBounds;
        if (fill != null) {
            defineShape4.usesFillWindingRule = windingValue == Winding.NON_ZERO;
        }
        return defineShape4;
    }

    protected FillStyle createFillStyle(FillNode fill, Rect bounds) {
        if (fill instanceof SolidColorFillNode) {
            return this.createFillStyle((SolidColorFillNode)fill);
        }
        if (fill instanceof LinearGradientFillNode) {
            return this.createFillStyle((LinearGradientFillNode)fill, bounds);
        }
        if (fill instanceof RadialGradientFillNode) {
            return this.createFillStyle((RadialGradientFillNode)fill, bounds);
        }
        if (fill instanceof BitmapFillNode) {
            return this.createFillStyle((BitmapFillNode)fill);
        }
        return null;
    }

    protected FillStyle createFillStyle(SolidColorFillNode fill) {
        FillStyle fs = new FillStyle();
        fs.color = TypeHelper.colorARGB(fill.color, fill.alpha);
        fs.type = 0;
        return fs;
    }

    protected FillStyle createFillStyle(BitmapFillNode fill) {
        FillStyle fs = new FillStyle();
        fs.type = fill.repeat ? 64 : 65;
        String source = this.parseSource(fill.source);
        fs.bitmap = this.createDefineBits(fill, source, Double.NaN, Double.NaN);
        fs.matrix = TypeHelper.bitmapFillMatrix(fill);
        return fs;
    }

    protected FillStyle createFillStyle(LinearGradientFillNode node, Rect bounds) {
        FillStyle fs = new FillStyle();
        fs.type = 16;
        fs.matrix = TypeHelper.linearGradientMatrix(node, bounds);
        Gradient gradient = new Gradient();
        this.populateGradient(gradient, node.entries, node.interpolationMethod, node.spreadMethod);
        fs.gradient = gradient;
        return fs;
    }

    protected FillStyle createFillStyle(LinearGradientStrokeNode node, Rect bounds) {
        FillStyle fs = new FillStyle();
        fs.type = 16;
        fs.matrix = TypeHelper.linearGradientMatrix(node, bounds);
        Gradient gradient = new Gradient();
        this.populateGradient(gradient, node.entries, node.interpolationMethod, node.spreadMethod);
        fs.gradient = gradient;
        return fs;
    }

    protected FillStyle createFillStyle(RadialGradientFillNode node, Rect bounds) {
        double width = (double)bounds.getWidth() / 20.0;
        double height = (double)bounds.getHeight() / 20.0;
        FillStyle fs = new FillStyle();
        fs.type = 19;
        fs.matrix = TypeHelper.radialGradientMatrix(width, height, node);
        FocalGradient gradient = new FocalGradient();
        this.populateGradient((Gradient)gradient, node.entries, node.interpolationMethod, node.spreadMethod);
        gradient.focalPoint = (float)node.focalPointRatio;
        fs.gradient = gradient;
        return fs;
    }

    protected FillStyle createFillStyle(RadialGradientStrokeNode node, double width, double height) {
        FillStyle fs = new FillStyle();
        fs.type = 19;
        fs.matrix = TypeHelper.radialGradientMatrix(width, height, node);
        FocalGradient gradient = new FocalGradient();
        this.populateGradient((Gradient)gradient, node.entries, node.interpolationMethod, node.spreadMethod);
        gradient.focalPoint = (float)node.focalPointRatio;
        fs.gradient = gradient;
        return fs;
    }

    protected LineStyle createLineStyle(StrokeNode stroke, Rect bounds) {
        if (stroke instanceof SolidColorStrokeNode) {
            return this.createLineStyle((SolidColorStrokeNode)stroke);
        }
        if (stroke instanceof LinearGradientStrokeNode) {
            return this.createLineStyle((LinearGradientStrokeNode)stroke, bounds);
        }
        if (stroke instanceof RadialGradientStrokeNode) {
            return this.createLineStyle((RadialGradientStrokeNode)stroke, bounds);
        }
        return null;
    }

    protected LineStyle createLineStyle(SolidColorStrokeNode stroke) {
        int startCapStyle;
        LineStyle ls = new LineStyle();
        ls.width = (int)StrictMath.rint(stroke.weight * 20.0);
        ls.color = TypeHelper.colorARGB(stroke.color, stroke.alpha);
        int flags = 0;
        int endCapStyle = startCapStyle = this.createCaps(stroke.caps);
        int jointStyle = this.createJoints(stroke.joints);
        int noHorizonalScale = 1;
        int noVerticalScale = 1;
        if (stroke.scaleMode == ScaleMode.VERTICAL || stroke.scaleMode == ScaleMode.NONE) {
            flags |= noHorizonalScale << 1;
        }
        if (stroke.scaleMode == ScaleMode.HORIZONTAL || stroke.scaleMode == ScaleMode.NONE) {
            flags |= noVerticalScale << 2;
        }
        flags |= jointStyle << 4;
        flags |= startCapStyle << 6;
        flags |= endCapStyle << 8;
        if (jointStyle == 2) {
            ls.miterLimit = TypeHelper.fixed8(stroke.miterLimit);
        }
        ls.flags = flags;
        return ls;
    }

    protected LineStyle createLineStyle(LinearGradientStrokeNode stroke, Rect bounds) {
        int startCapStyle;
        LineStyle ls = new LineStyle();
        ls.width = (int)StrictMath.rint(stroke.weight * 20.0);
        ls.fillStyle = this.createFillStyle(stroke, bounds);
        int flags = 0;
        int hasFillStyle = 1;
        int endCapStyle = startCapStyle = this.createCaps(stroke.caps);
        int jointStyle = this.createJoints(stroke.joints);
        int noHorizonalScale = 1;
        int noVerticalScale = 1;
        if (stroke.scaleMode == ScaleMode.VERTICAL || stroke.scaleMode == ScaleMode.NONE) {
            flags |= noHorizonalScale << 1;
        }
        if (stroke.scaleMode == ScaleMode.HORIZONTAL || stroke.scaleMode == ScaleMode.NONE) {
            flags |= noVerticalScale << 2;
        }
        flags |= hasFillStyle << 3;
        flags |= jointStyle << 4;
        flags |= startCapStyle << 6;
        flags |= endCapStyle << 8;
        if (jointStyle == 2) {
            ls.miterLimit = TypeHelper.fixed8(stroke.miterLimit);
        }
        ls.flags = flags;
        return ls;
    }

    protected LineStyle createLineStyle(RadialGradientStrokeNode stroke, Rect edgeBounds) {
        int startCapStyle;
        LineStyle ls = new LineStyle();
        ls.width = (int)StrictMath.rint(stroke.weight * 20.0);
        double width = (double)edgeBounds.getWidth() / 20.0;
        double height = (double)edgeBounds.getHeight() / 20.0;
        ls.fillStyle = this.createFillStyle(stroke, width, height);
        int flags = 0;
        int hasFillStyle = 1;
        int endCapStyle = startCapStyle = this.createCaps(stroke.caps);
        int jointStyle = this.createJoints(stroke.joints);
        int noHorizonalScale = 1;
        int noVerticalScale = 1;
        if (stroke.scaleMode == ScaleMode.VERTICAL || stroke.scaleMode == ScaleMode.NONE) {
            flags |= noHorizonalScale << 1;
        }
        if (stroke.scaleMode == ScaleMode.HORIZONTAL || stroke.scaleMode == ScaleMode.NONE) {
            flags |= noVerticalScale << 2;
        }
        flags |= hasFillStyle << 3;
        flags |= jointStyle << 4;
        flags |= startCapStyle << 6;
        flags |= endCapStyle << 8;
        if (jointStyle == 2) {
            ls.miterLimit = TypeHelper.fixed8(stroke.miterLimit);
        }
        ls.flags = flags;
        return ls;
    }

    protected int createCaps(Caps value) {
        if (value != null) {
            return value.ordinal();
        }
        return Caps.NONE.ordinal();
    }

    protected int createJoints(Joints value) {
        if (value != null) {
            return value.ordinal();
        }
        return Joints.ROUND.ordinal();
    }

    protected int createSpreadMode(SpreadMethod value) {
        return value.ordinal();
    }

    protected int createBlendMode(BlendMode value) {
        return value.ordinal();
    }

    protected int createInterpolationMode(InterpolationMethod value) {
        return value.ordinal();
    }

    protected List<Filter> createFilters(List<FilterNode> list) {
        ArrayList<Filter> filters = new ArrayList<Filter>(list.size());
        for (FilterNode f : list) {
            BevelFilter filter;
            AbstractFilterNode node;
            if (f instanceof BevelFilterNode) {
                node = (BevelFilterNode)f;
                filter = this.createBevelFilter((BevelFilterNode)node);
                filters.add((Filter)filter);
                continue;
            }
            if (f instanceof BlurFilterNode) {
                node = (BlurFilterNode)f;
                filter = this.createBlurFilter((BlurFilterNode)node);
                filters.add((Filter)filter);
                continue;
            }
            if (f instanceof ColorMatrixFilterNode) {
                node = (ColorMatrixFilterNode)f;
                filter = new ColorMatrixFilter();
                filter.values = ((ColorMatrixFilterNode)node).matrix;
                filters.add((Filter)filter);
                continue;
            }
            if (f instanceof DropShadowFilterNode) {
                node = (DropShadowFilterNode)f;
                filter = this.createDropShadowFilter((DropShadowFilterNode)node);
                filters.add((Filter)filter);
                continue;
            }
            if (f instanceof GlowFilterNode) {
                node = (GlowFilterNode)f;
                filter = this.createGlowFilter((GlowFilterNode)node);
                filters.add((Filter)filter);
                continue;
            }
            if (f instanceof GradientBevelFilterNode) {
                node = (GradientBevelFilterNode)f;
                filter = this.createGradientBevelFilter((GradientBevelFilterNode)node);
                filters.add((Filter)filter);
                continue;
            }
            if (!(f instanceof GradientGlowFilterNode)) continue;
            node = (GradientGlowFilterNode)f;
            filter = this.createGradientGlowFilter((GradientGlowFilterNode)node);
            filters.add((Filter)filter);
        }
        return filters;
    }

    protected BevelFilter createBevelFilter(BevelFilterNode node) {
        BevelFilter filter = new BevelFilter();
        filter.angle = TypeHelper.fixed(node.angle * Math.PI / 180.0);
        filter.blurX = TypeHelper.fixed(node.blurX);
        filter.blurY = TypeHelper.fixed(node.blurY);
        filter.distance = TypeHelper.fixed(node.distance);
        filter.strength = TypeHelper.fixed8(node.strength);
        filter.shadowColor = TypeHelper.colorARGB(node.shadowColor, node.shadowAlpha);
        filter.highlightColor = TypeHelper.colorARGB(node.highlightColor, node.highlightAlpha);
        filter.flags = node.quality;
        if (node.type == BevelType.FULL) {
            filter.flags |= 0x10;
        }
        filter.flags |= 0x20;
        if (node.knockout) {
            filter.flags |= 0x40;
        }
        if (node.type == BevelType.INNER) {
            filter.flags |= 0x80;
        }
        return filter;
    }

    protected BlurFilter createBlurFilter(BlurFilterNode node) {
        BlurFilter filter = new BlurFilter();
        filter.blurX = TypeHelper.fixed(node.blurX);
        filter.blurY = TypeHelper.fixed(node.blurY);
        filter.passes = node.quality << 3;
        return filter;
    }

    protected DropShadowFilter createDropShadowFilter(DropShadowFilterNode node) {
        DropShadowFilter filter = new DropShadowFilter();
        filter.color = TypeHelper.colorARGB(node.color, node.alpha);
        filter.angle = TypeHelper.fixed(node.angle * Math.PI / 180.0);
        filter.blurX = TypeHelper.fixed(node.blurX);
        filter.blurY = TypeHelper.fixed(node.blurY);
        filter.distance = TypeHelper.fixed(node.distance);
        filter.strength = TypeHelper.fixed8(node.strength);
        filter.flags = node.quality;
        filter.flags |= 0x20;
        if (node.knockout) {
            filter.flags |= 0x40;
        }
        if (node.inner) {
            filter.flags |= 0x80;
        }
        return filter;
    }

    protected GlowFilter createGlowFilter(GlowFilterNode node) {
        GlowFilter filter = new GlowFilter();
        filter.color = TypeHelper.colorARGB(node.color, node.alpha);
        filter.blurX = TypeHelper.fixed(node.blurX);
        filter.blurY = TypeHelper.fixed(node.blurY);
        filter.strength = TypeHelper.fixed8(node.strength);
        filter.flags = node.quality;
        filter.flags |= 0x20;
        if (node.knockout) {
            filter.flags |= 0x40;
        }
        if (node.inner) {
            filter.flags |= 0x80;
        }
        return filter;
    }

    protected GradientBevelFilter createGradientBevelFilter(GradientBevelFilterNode node) {
        GradientBevelFilter filter = new GradientBevelFilter();
        if (node.entries != null) {
            byte count = (byte)node.entries.size();
            filter.numcolors = count;
            filter.gradientColors = new int[count];
            filter.gradientRatio = new int[count];
            GradRecord[] records = this.createGradRecords(node.entries);
            for (int i = 0; i < records.length; ++i) {
                GradRecord record = records[i];
                filter.gradientColors[i] = record.color;
                filter.gradientRatio[i] = record.ratio;
            }
        }
        filter.angle = TypeHelper.fixed(node.angle * Math.PI / 180.0);
        filter.blurX = TypeHelper.fixed(node.blurX);
        filter.blurY = TypeHelper.fixed(node.blurY);
        filter.distance = TypeHelper.fixed(node.distance);
        filter.strength = TypeHelper.fixed8(node.strength);
        filter.flags = node.quality;
        if (node.type == BevelType.FULL) {
            filter.flags |= 0x10;
        }
        filter.flags |= 0x20;
        if (node.knockout) {
            filter.flags |= 0x40;
        }
        if (node.type == BevelType.INNER) {
            filter.flags |= 0x80;
        }
        return filter;
    }

    protected GradientGlowFilter createGradientGlowFilter(GradientGlowFilterNode node) {
        GradientGlowFilter filter = new GradientGlowFilter();
        if (node.entries != null) {
            byte count = (byte)node.entries.size();
            filter.numcolors = count;
            filter.gradientColors = new int[count];
            filter.gradientRatio = new int[count];
            GradRecord[] records = this.createGradRecords(node.entries);
            for (int i = 0; i < records.length; ++i) {
                GradRecord record = records[i];
                filter.gradientColors[i] = record.color;
                filter.gradientRatio[i] = record.ratio;
            }
        }
        filter.angle = TypeHelper.fixed(node.angle * Math.PI / 180.0);
        filter.blurX = TypeHelper.fixed(node.blurX);
        filter.blurY = TypeHelper.fixed(node.blurY);
        filter.distance = TypeHelper.fixed(node.distance);
        filter.strength = TypeHelper.fixed8(node.strength);
        filter.flags = node.quality;
        filter.flags |= 0x20;
        if (node.knockout) {
            filter.flags |= 0x40;
        }
        if (node.inner) {
            filter.flags |= 0x80;
        }
        return filter;
    }

    protected void populateGradient(Gradient gradient, List<GradientEntryNode> entries, InterpolationMethod interpolation, SpreadMethod spread) {
        gradient.records = this.createGradRecords(entries);
        if (interpolation != null) {
            gradient.interpolationMode = this.createInterpolationMode(interpolation);
        }
        if (spread != null) {
            gradient.spreadMode = this.createSpreadMode(spread);
        }
    }

    protected GradRecord[] createGradRecords(List<GradientEntryNode> entries) {
        int count = entries.size();
        GradRecord[] records = new GradRecord[count];
        double previousRatio = 0.0;
        for (int currentIndex = 0; currentIndex < count; ++currentIndex) {
            GradientEntryNode entry = entries.get(currentIndex);
            double thisRatio = entry.ratio;
            if (Double.isNaN(thisRatio)) {
                if (currentIndex == 0) {
                    thisRatio = 0.0;
                } else if (currentIndex == count - 1) {
                    thisRatio = 1.0;
                } else {
                    int entryGap;
                    double nextRatio = 1.0;
                    int nextIndex = count - 1;
                    for (int i = currentIndex; i < count; ++i) {
                        GradientEntryNode nextEntry = entries.get(i);
                        if (Double.isNaN(nextEntry.ratio)) continue;
                        nextRatio = nextEntry.ratio;
                        nextIndex = i;
                        break;
                    }
                    thisRatio = (entryGap = nextIndex - (currentIndex - 1)) > 0 ? previousRatio + (nextRatio - previousRatio) / (double)entryGap : previousRatio;
                }
            }
            GradRecord record = new GradRecord();
            record.color = TypeHelper.colorARGB(entry.color, entry.alpha);
            record.ratio = TypeHelper.gradientRatio(thisRatio);
            records[currentIndex] = record;
            previousRatio = thisRatio;
        }
        return records;
    }

    protected String parseSource(String source) {
        if (source != null && (source = source.trim()).startsWith("@Embed(")) {
            if ((source = source.substring(7).trim()).endsWith(")")) {
                source = source.substring(0, source.length() - 1).trim();
            }
            if (source.charAt(0) == '\'' && source.charAt(source.length() - 1) == '\'') {
                source = source.substring(1, source.length() - 1).trim();
            }
        }
        return source;
    }
}

