/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.pdfops;

import com.adobe.pdfservices.operation.ExecutionContext;
import com.adobe.pdfservices.operation.Operation;
import com.adobe.pdfservices.operation.exception.ServiceApiException;
import com.adobe.pdfservices.operation.exception.ServiceUsageException;
import com.adobe.pdfservices.operation.internal.ExtensionMediaTypeMapping;
import com.adobe.pdfservices.operation.internal.FileRefImpl;
import com.adobe.pdfservices.operation.internal.InternalExecutionContext;
import com.adobe.pdfservices.operation.internal.MediaType;
import com.adobe.pdfservices.operation.internal.api.FileDownloadApi;
import com.adobe.pdfservices.operation.internal.cpf.dto.response.platform.CPFContentAnalyzerResponse;
import com.adobe.pdfservices.operation.internal.exception.OperationException;
import com.adobe.pdfservices.operation.internal.service.SplitPDFService;
import com.adobe.pdfservices.operation.internal.util.StringUtil;
import com.adobe.pdfservices.operation.internal.util.ValidationUtil;
import com.adobe.pdfservices.operation.io.FileRef;
import com.adobe.pdfservices.operation.pdfops.options.PageRanges;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitPDFOperation
implements Operation {
    private static final Logger LOGGER = LoggerFactory.getLogger(SplitPDFOperation.class);
    private static final Set<String> SUPPORTED_SOURCE_MEDIA_TYPES = new HashSet<String>(Collections.singletonList(ExtensionMediaTypeMapping.PDF.getMediaType()));
    private static final String TARGET_FILE_EXTENSION = ExtensionMediaTypeMapping.PDF.getExtension();
    private boolean isInvoked = false;
    private FileRefImpl sourceFileRef;
    private PageRanges pageRanges;
    private Integer pageCount;
    private Integer fileCount;

    private SplitPDFOperation() {
    }

    public static SplitPDFOperation createNew() {
        return new SplitPDFOperation();
    }

    public void setInput(FileRef sourceFileRef) {
        Objects.requireNonNull(sourceFileRef, "No input was set for operation");
        this.sourceFileRef = (FileRefImpl)sourceFileRef;
    }

    public void setPageRanges(PageRanges pageRanges) {
        this.pageRanges = pageRanges;
    }

    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }

    public void setFileCount(int fileCount) {
        this.fileCount = fileCount;
    }

    @Override
    public List<FileRef> execute(ExecutionContext context) throws ServiceApiException, IOException, ServiceUsageException {
        this.validateInvocationCount();
        InternalExecutionContext internalExecutionContext = (InternalExecutionContext)context;
        this.validate(internalExecutionContext);
        try {
            LOGGER.info("All validations successfully done. Beginning Split PDF operation execution");
            long startTimeMs = System.currentTimeMillis();
            String location = SplitPDFService.splitPDF(internalExecutionContext, this.sourceFileRef, this.pageRanges, this.pageCount, this.fileCount, this.getClass().getSimpleName());
            List<String> temporaryDestinationPaths = FileDownloadApi.downloadAndSaveMultiple(internalExecutionContext, location, TARGET_FILE_EXTENSION, CPFContentAnalyzerResponse.class);
            LOGGER.info("Operation successfully completed. Stored requisite PDF at {}", (Object)temporaryDestinationPaths.toString());
            LOGGER.debug("Operation Success Info - Request ID: {}, Latency(ms): {}", (Object)StringUtil.getRequestIdFromLocation(location), (Object)(System.currentTimeMillis() - startTimeMs));
            this.isInvoked = true;
            ArrayList<FileRef> fileRefList = new ArrayList<FileRef>();
            for (String path : temporaryDestinationPaths) {
                fileRefList.add(FileRef.createFromLocalFile(path));
            }
            return fileRefList;
        }
        catch (OperationException oe) {
            throw new ServiceApiException(oe.getErrorMessage(), oe.getRequestTrackingId(), oe.getStatusCode(), oe.getReportErrorCode());
        }
    }

    private void validateInvocationCount() {
        if (this.isInvoked) {
            LOGGER.error("Operation instance must only be invoked once");
            throw new IllegalStateException("Operation instance must not be reused, can only be invoked once");
        }
    }

    private void validate(InternalExecutionContext context) {
        if (this.sourceFileRef == null) {
            throw new IllegalArgumentException("No input was set for operation");
        }
        if (this.sourceFileRef.getSourceURL() != null) {
            throw new IllegalArgumentException("Input for the Split PDF Operation can not be sourced from a URL");
        }
        ValidationUtil.validateSplitPDFOperationParams(this.pageRanges, this.pageCount, this.fileCount);
        ValidationUtil.validateExecutionContext(context);
        ValidationUtil.validateMediaType(SUPPORTED_SOURCE_MEDIA_TYPES, this.sourceFileRef.getMediaType());
    }

    public static enum SupportedSourceFormat implements MediaType
    {
        PDF;


        @Override
        public String getMediaType() {
            return ExtensionMediaTypeMapping.valueOf(this.name()).getMediaType().toLowerCase();
        }
    }
}

