/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.service;

import com.adobe.pdfservices.operation.internal.FileRefImpl;
import com.adobe.pdfservices.operation.internal.InternalExecutionContext;
import com.adobe.pdfservices.operation.internal.api.CPFApi;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.CPFContentAnalyzerRequests;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.Inputs;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.Outputs;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.SplitPDFParams;
import com.adobe.pdfservices.operation.internal.http.HttpResponse;
import com.adobe.pdfservices.operation.pdfops.options.PageRanges;
import java.io.FileNotFoundException;
import java.util.ArrayList;

public class SplitPDFService {
    private static final String INPUT_FORMAT_SPECIFIER = "application/pdf";
    private static final String OUTPUT_FORMAT_SPECIFIER = "text/directory";

    public static String splitPDF(InternalExecutionContext context, FileRefImpl sourceFileRef, PageRanges pageRanges, Integer pageCount, Integer fileCount, String operation) throws FileNotFoundException {
        SplitPDFParams splitPDFParams = new SplitPDFParams(pageRanges, pageCount, fileCount);
        Inputs inputs = Inputs.builder(INPUT_FORMAT_SPECIFIER).setParams(splitPDFParams).build();
        Outputs outputs = new Outputs(OUTPUT_FORMAT_SPECIFIER, true);
        CPFContentAnalyzerRequests cpfContentAnalyzerRequests = new CPFContentAnalyzerRequests("urn:aaid:cpf:Service-d99c7660cba14e5c98f9023221dab40f", inputs, outputs);
        ArrayList<FileRefImpl> sourceFileRefList = new ArrayList<FileRefImpl>();
        sourceFileRefList.add(sourceFileRef);
        HttpResponse<String> response = CPFApi.cpfCreateOpsApi(context, cpfContentAnalyzerRequests, sourceFileRefList, String.class, operation);
        return response.getHeaders().get("location");
    }
}

