/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.http;

import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.MultiPartFormField;
import com.adobe.pdfservices.operation.internal.cpf.dto.response.platform.CPFContentAnalyzerResponse;
import com.adobe.pdfservices.operation.internal.http.HttpResponse;
import com.adobe.pdfservices.operation.internal.util.JsonUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiPartHttpResponse<T>
implements HttpResponse<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiPartHttpResponse.class);
    private static final String CONTENT_TYPE_MULTIPART_MIXED_STRING = "multipart/mixed";
    private static final String MIME_TYPE_APPLICATION_JSON_STRING = "application/json";
    private static final String MIME_TYPE_APPLICATION_OCTET_STREAM_STRING = "application/octet-stream";
    private static final String CONTENT_DISPOSITION_STRING = "Content-Disposition";
    private static final String NAME_CONTENT_DISPOSITION_PARAM_STRING = "name";
    private static final String FILE_OUTPUT_LABEL_STRING = "file";
    private int statusCode;
    private Map<String, String> headers;
    private T inlineJsonResponseDto;
    private Class<T> inlineJsonResponseType;
    private List<InputStream> inlineContentResponses;
    private List<MimeBodyPart> responseBodyParts;

    public MultiPartHttpResponse(int statusCode, Map<String, String> headers, InputStream inputStream, Class<T> inlineJsonResponseType) throws IOException, MessagingException {
        this.statusCode = statusCode;
        this.headers = headers;
        this.inlineJsonResponseType = inlineJsonResponseType;
        this.inlineContentResponses = new ArrayList<InputStream>();
        this.parseInlineResponseData(inputStream);
    }

    private void parseInlineResponseData(InputStream inputStream) throws IOException, MessagingException {
        ByteArrayDataSource datasource = new ByteArrayDataSource(IOUtils.toByteArray((InputStream)inputStream), CONTENT_TYPE_MULTIPART_MIXED_STRING);
        MimeMultipart multipart = new MimeMultipart((DataSource)datasource);
        this.responseBodyParts = new ArrayList<MimeBodyPart>();
        HashMap<String, InputStream> fileNameToStreamMap = new HashMap<String, InputStream>();
        int count = multipart.getCount();
        for (int i = 0; i < count; ++i) {
            MimeBodyPart bodyPart = (MimeBodyPart)multipart.getBodyPart(i);
            this.responseBodyParts.add(bodyPart);
            if (bodyPart.isMimeType(MIME_TYPE_APPLICATION_JSON_STRING)) {
                this.processJsonData(bodyPart.getInputStream());
                continue;
            }
            if (!bodyPart.isMimeType(MIME_TYPE_APPLICATION_OCTET_STREAM_STRING)) continue;
            this.processBinaryData(fileNameToStreamMap, bodyPart);
        }
        if (this.inlineJsonResponseDto instanceof CPFContentAnalyzerResponse) {
            List<MultiPartFormField> documentOutList;
            CPFContentAnalyzerResponse cpfContentAnalyzerResponse = (CPFContentAnalyzerResponse)this.inlineJsonResponseDto;
            List<MultiPartFormField> list = documentOutList = cpfContentAnalyzerResponse.getCpfOutputs() != null ? cpfContentAnalyzerResponse.getCpfOutputs().getDocumentOutList() : null;
            if (documentOutList != null && documentOutList.size() > 0) {
                for (MultiPartFormField multiPartFormField : documentOutList) {
                    this.inlineContentResponses.add((InputStream)fileNameToStreamMap.get(multiPartFormField.getLocation()));
                }
            } else {
                this.inlineContentResponses.add((InputStream)fileNameToStreamMap.get(FILE_OUTPUT_LABEL_STRING));
            }
        } else {
            this.inlineContentResponses.add((InputStream)fileNameToStreamMap.get(FILE_OUTPUT_LABEL_STRING));
        }
        inputStream.close();
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getRequestId() {
        if (this.headers != null) {
            return this.headers.get("x-request-id");
        }
        return null;
    }

    @Override
    public T getBody() {
        return this.inlineJsonResponseDto;
    }

    @Override
    public List<InputStream> getResponseAsStreamList() {
        return this.inlineContentResponses;
    }

    @Override
    public void consume() throws IOException {
        for (InputStream inlineContentResponse : this.inlineContentResponses) {
            if (inlineContentResponse == null) continue;
            inlineContentResponse.close();
        }
        if (CollectionUtils.isNotEmpty(this.responseBodyParts)) {
            for (MimeBodyPart responseBodyPart : this.responseBodyParts) {
                try {
                    responseBodyPart.getInputStream().close();
                }
                catch (Exception ex) {}
            }
        }
    }

    private void processJsonData(InputStream inputStream) {
        this.inlineJsonResponseDto = JsonUtil.deserializeJsonStream(inputStream, this.inlineJsonResponseType);
    }

    private void processBinaryData(Map<String, InputStream> fileNameToStreamMap, MimeBodyPart bodyPart) throws IOException, MessagingException {
        ContentDisposition contentDisposition = new ContentDisposition(bodyPart.getHeader(CONTENT_DISPOSITION_STRING, ":"));
        String name = contentDisposition.getParameter(NAME_CONTENT_DISPOSITION_PARAM_STRING);
        fileNameToStreamMap.put(name, bodyPart.getInputStream());
    }

    public List<MimeBodyPart> getResponseBodyParts() {
        return this.responseBodyParts;
    }
}

