/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.auth;

import com.adobe.pdfservices.operation.auth.ServiceAccountCredentials;
import com.adobe.pdfservices.operation.internal.GlobalConfig;
import com.adobe.pdfservices.operation.internal.util.StringUtil;
import javax.validation.constraints.NotBlank;

public class ServiceAccountCredentialsWithUri
extends ServiceAccountCredentials {
    private String cpfOpsCreateUri;
    private String imsBaseUri;
    @NotBlank(message="claim must not be blank")
    private @NotBlank(message="claim must not be blank") String claim;

    public ServiceAccountCredentialsWithUri(String imsBaseUri, String clientId, String clientSecret, String privateKey, String claim, String organizationId, String accountId, String cpfOpsCreateUri) {
        super(clientId, clientSecret, privateKey, organizationId, accountId);
        String string = this.imsBaseUri = StringUtil.isBlank(imsBaseUri) ? GlobalConfig.getImsBaseUri() : imsBaseUri;
        if (StringUtil.isBlank(claim)) {
            String format = this.imsBaseUri.endsWith("/") ? "%s%s" : "%s/%s";
            this.claim = String.format(format, this.imsBaseUri, GlobalConfig.getClaim());
        } else {
            this.claim = claim;
        }
        this.cpfOpsCreateUri = cpfOpsCreateUri;
        this.validate();
    }

    public String getCpfOpsCreateUri() {
        return this.cpfOpsCreateUri;
    }

    public String getClaim() {
        return this.claim;
    }

    public String getImsBaseUri() {
        return this.imsBaseUri;
    }
}

