/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.pdfops.options.protectpdf;

import com.adobe.pdfservices.operation.pdfops.ProtectPDFOperation;

/**
 * Marker base class for {@link ProtectPDFOperation} options.
 * The factory methods within this class can be used to create instances of options classes
 */
public abstract class ProtectPDFOptions {

    protected ProtectPDFOptions() {

    }

    /**
     * Creates a new {@code PasswordProtectOptions} builder.
     *
     * @return a {@code PasswordProtectOptions.Builder} instance
     */
    public static PasswordProtectOptions.Builder passwordProtectOptionsBuilder() {
        return new PasswordProtectOptions.Builder();
    }
}
