/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.pdfops.options.createpdf.ppt;

import com.adobe.pdfservices.operation.pdfops.options.createpdf.CreatePDFOptions;

import java.util.Objects;

public class CreatePDFFromPPTOptions extends CreatePDFOptions {

  private SupportedDocumentLanguage documentLanguage;
  private Boolean createTaggedPDF;

  private CreatePDFFromPPTOptions(SupportedDocumentLanguage documentLanguage, boolean createTaggedPDF) {
    this.documentLanguage = documentLanguage;
    this.createTaggedPDF = createTaggedPDF;
  }

  public SupportedDocumentLanguage getDocumentLanguage() {
    return documentLanguage;
  }

  public Boolean getCreateTaggedPDF() {
    return createTaggedPDF;
  }

  public static class Builder {
    private SupportedDocumentLanguage documentLanguage;
    private Boolean createTaggedPDF;

    /**
     * Constructs a {@code CreatePDFFromPPTOptions.Builder} instance.
     */
    public Builder() {
    }

    /**
     * Sets office preferred editing language to be used for conversion, specified by {@link SupportedDocumentLanguage}.
     *
     * @param supportedDocumentLanguage see {@link SupportedDocumentLanguage}. Default value is {@link SupportedDocumentLanguage#EN_US}
     * @return this Builder instance to add any additional parameters
     */
    public CreatePDFFromPPTOptions.Builder withDocumentLanguage(SupportedDocumentLanguage supportedDocumentLanguage) {
      Objects.requireNonNull(supportedDocumentLanguage, "documentLanguage must not be null");
      this.documentLanguage = supportedDocumentLanguage;
      return this;
    }

    public CreatePDFFromPPTOptions.Builder withCreateTaggedPdf(Boolean createTaggedPDF) {
      Objects.requireNonNull(createTaggedPDF, "createTaggedPDF must not be null");
      this.createTaggedPDF = createTaggedPDF;
      return this;
    }

    /**
     * Returns a new {@link CreatePDFFromPPTOptions} instance built from the current state of this builder.
     *
     * @return a new {@code CreatePDFFromPPTOptions} instance
     */
    public CreatePDFFromPPTOptions build() {
      return new CreatePDFFromPPTOptions(documentLanguage, createTaggedPDF);
    }
  }

}
