/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.service;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;

import com.adobe.pdfservices.operation.internal.cpf.constants.CPFConstants;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.CPFContentAnalyzerRequests;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.Inputs;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.Outputs;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.SplitPDFParams;
import com.adobe.pdfservices.operation.internal.FileRefImpl;
import com.adobe.pdfservices.operation.internal.InternalExecutionContext;
import com.adobe.pdfservices.operation.internal.api.CPFApi;
import com.adobe.pdfservices.operation.internal.http.DefaultRequestHeaders;
import com.adobe.pdfservices.operation.internal.http.HttpResponse;
import com.adobe.pdfservices.operation.pdfops.options.PageRanges;

public class SplitPDFService {
    private static final String INPUT_FORMAT_SPECIFIER = "application/pdf";
    private static final String OUTPUT_FORMAT_SPECIFIER = "text/directory";

    public static String splitPDF(InternalExecutionContext context,
                                  FileRefImpl sourceFileRef,
                                  PageRanges pageRanges,
                                  Integer pageCount,
                                  Integer fileCount,
                                  String operation) throws FileNotFoundException {
        try {
            // Create SplitPDFParams
            SplitPDFParams splitPDFParams = new SplitPDFParams(pageRanges, pageCount, fileCount);

            // Create cpf inputs from SplitPDFParams
            Inputs inputs = Inputs.builder(INPUT_FORMAT_SPECIFIER)
                    .setParams(splitPDFParams)
                    .build();

            // Create cpf outputs
            Outputs outputs = new Outputs(OUTPUT_FORMAT_SPECIFIER, true);

            // Create CPFContentAnalyzerRequests from cpf inputs and cpf outputs
            CPFContentAnalyzerRequests cpfContentAnalyzerRequests
                    = new CPFContentAnalyzerRequests(CPFConstants.SplitPDF.PAPI_ENGINE_REPO_ASSET_ID,
                    inputs, outputs);

            // Prepare the sourceFileRefList
            List<FileRefImpl> sourceFileRefList = new ArrayList<>();
            sourceFileRefList.add(sourceFileRef);

            HttpResponse<String> response = CPFApi.cpfCreateOpsApi(context, cpfContentAnalyzerRequests,
                    sourceFileRefList, String.class, operation);

            return response.getHeaders().get(DefaultRequestHeaders.LOCATION_HEADER_NAME);
        } catch (FileNotFoundException fe) {
            throw fe;
        }
    }
}
