/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.cpf.dto.response.platform;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import com.adobe.pdfservices.operation.internal.dto.response.Report;
import com.adobe.pdfservices.operation.internal.util.JsonUtil;

@JsonIgnoreProperties(ignoreUnknown = true)
public class CPFStatus {

    private boolean completed;

    private String type;

    private int status;

    private Report report;

    private String title;

    @JsonCreator
    public CPFStatus(@JsonProperty("completed") boolean completed,
                     @JsonProperty("type") String type,
                     @JsonProperty("status") int status,
                     @JsonProperty("report") String report,
                     @JsonProperty("title") String title) {
        this.completed = completed;
        this.type = type;
        this.status = status;
        if (Objects.nonNull(report))
            this.report = JsonUtil.deserializeJsonString(report, Report.class);;
        this.title = title;
    }

    public int getStatus() {
        return status;
    }

    public String getTitle() {
        return title;
    }

    public Report getReport() { return report; }

    public String getType() {
        return type;
    }
}
