/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.protect;

import java.util.ArrayList;
import java.util.List;

import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.PlatformParams;
import com.adobe.pdfservices.operation.pdfops.options.protectpdf.PasswordProtectOptions;
import com.adobe.pdfservices.operation.pdfops.options.protectpdf.Permission;
import com.adobe.pdfservices.operation.pdfops.options.protectpdf.ProtectPDFOptions;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class PasswordProtectParams implements PlatformParams {
    @JsonProperty("passwordProtection")
    private PasswordProtection passwordProtection;

    @JsonProperty("encryptionAlgorithm")
    private String encryptionAlgorithm;

    @JsonProperty("contentToEncrypt")
    private String contentToEncrypt;

    @JsonProperty("permissions")
    private List<String> permissions;

    private PasswordProtectParams(PasswordProtectOptions passwordProtectOptions) {
        this.passwordProtection = new PasswordProtection(passwordProtectOptions.getUserPassword(), passwordProtectOptions.getOwnerPassword());
        this.encryptionAlgorithm = passwordProtectOptions.getEncryptionAlgorithm().getValue();

        if (passwordProtectOptions.getContentEncryption() != null)
            this.contentToEncrypt = passwordProtectOptions.getContentEncryption().getValue();

        // if permissions are not null && permissions set is not empty
        if (passwordProtectOptions.getPermissions() != null &&
            !passwordProtectOptions.getPermissions().getValues().isEmpty()) {
            this.permissions = new ArrayList<>();
            for (Permission permission : passwordProtectOptions.getPermissions().getValues()) {
                this.permissions.add(permission.getValue());
            }
        }
    }

    public static PasswordProtectParams createFrom(ProtectPDFOptions protectPDFOptions) {
        PasswordProtectParams protectPDFParams = null;

        if(protectPDFOptions != null) {
            protectPDFParams = new PasswordProtectParams((PasswordProtectOptions) protectPDFOptions);
        }

        return protectPDFParams;
    }
}
