/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.htmltopdf;

import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.PlatformParams;
import com.adobe.pdfservices.operation.pdfops.options.createpdf.CreatePDFFromHTMLOptions;
import com.adobe.pdfservices.operation.pdfops.options.createpdf.CreatePDFOptions;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class HTMLToPDFParams implements PlatformParams {

    @JsonProperty("print")
    private Print print;

    @JsonProperty("pageLayout")
    private PageLayout pageLayout;

    @JsonProperty("json")
    private String dataToMerge;

    private HTMLToPDFParams(CreatePDFFromHTMLOptions createPDFFromHTMLOptions) {
        this.print = new Print(createPDFFromHTMLOptions.includesHeaderFooter());
        this.pageLayout = new PageLayout(createPDFFromHTMLOptions.getPageLayout().getPageHeight(), createPDFFromHTMLOptions.getPageLayout().getPageWidth());
        this.dataToMerge = createPDFFromHTMLOptions.getDataToMerge() != null ? createPDFFromHTMLOptions.getDataToMerge().toString() : null;
    }

    public static HTMLToPDFParams createFrom(CreatePDFOptions createPDFOptions) {
        HTMLToPDFParams htmlToPDFParams = null;

        if(createPDFOptions != null) {
            htmlToPDFParams = new HTMLToPDFParams((CreatePDFFromHTMLOptions) createPDFOptions);
        }

        return htmlToPDFParams;
    }
}
