/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.documentmerge;


import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.PlatformParams;
import com.adobe.pdfservices.operation.pdfops.options.documentmerge.Fragments;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.json.JSONArray;
import org.json.JSONObject;

import com.adobe.pdfservices.operation.internal.serializer.JSONObjectSerializer;

import java.util.List;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class DocumentMergeParams implements PlatformParams {

    @JsonProperty("outputFormat")
    private String outputFormat;

    @JsonProperty("jsonDataForMerge")
    @JsonSerialize(using = JSONObjectSerializer.class)
    private JSONObject jsonDataForMerge;

    @JsonProperty("fragments")
    private List<?> fragments;

    public DocumentMergeParams(String outputFormat, JSONObject jsonDataForMerge) {
        this.outputFormat = outputFormat;
        this.jsonDataForMerge = jsonDataForMerge;
    }

    public DocumentMergeParams(String outputFormat, JSONObject jsonDataForMerge, Fragments fragments) throws JsonProcessingException {
        this.outputFormat = outputFormat;
        this.jsonDataForMerge = jsonDataForMerge;
        if(fragments != null) {
            JSONArray fragmentArray = new JSONArray(fragments.getFragmentsList());
            if(fragmentArray != null){
                final ObjectMapper objectMapper = new ObjectMapper();
                this.fragments = objectMapper.readValue(fragmentArray.toString(), new TypeReference<List<?>>(){});
            }

        }
    }
}
