/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.cpf.dto.request.platform;

import com.adobe.pdfservices.operation.pdfops.options.ocr.OCROptions;
import com.adobe.pdfservices.operation.pdfops.options.ocr.OCRSupportedLocale;
import com.adobe.pdfservices.operation.pdfops.options.ocr.OCRSupportedType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class OCRParams implements PlatformParams {

    @JsonProperty("ocrLang")
    private String ocrLang;

    @JsonProperty("ocrType")
    private String ocrType;

    private OCRParams(OCRSupportedLocale ocrLang, OCRSupportedType ocrType) {
        this.ocrLang = ocrLang != null ? ocrLang.getLocale() : null;
        this.ocrType = ocrType != null ? ocrType.getType() : null;
    }

    public static OCRParams createFrom(OCROptions ocrOptions) {
        OCRParams ocrParams = null;

        if(ocrOptions != null) {
            if (ocrOptions.getOCRLocale() != null || ocrOptions.getOCRType() != null) {
                ocrParams = new OCRParams(ocrOptions.getOCRLocale(), ocrOptions.getOCRType());
            }
        }

        return ocrParams;
    }
}
