/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.auth;

import com.adobe.pdfservices.operation.internal.util.StringUtil;
import com.adobe.pdfservices.operation.auth.ServiceAccountCredentials;
import com.adobe.pdfservices.operation.internal.GlobalConfig;

import javax.validation.constraints.NotBlank;

public class ServiceAccountCredentialsWithUri extends ServiceAccountCredentials {

    private String cpfOpsCreateUri;

    private String imsBaseUri;

    @NotBlank(message = "claim must not be blank")
    private String claim;

    public ServiceAccountCredentialsWithUri(String imsBaseUri, String clientId, String clientSecret, String privateKey, String claim, String organizationId, String accountId, String cpfOpsCreateUri)
    {
        super(clientId,clientSecret,privateKey,organizationId,accountId);
        this.imsBaseUri = StringUtil.isBlank(imsBaseUri) ? GlobalConfig.getImsBaseUri() : imsBaseUri;
        if (StringUtil.isBlank(claim)) {
            String format = this.imsBaseUri.endsWith("/") ? ("%s%s") : ("%s/%s");
            this.claim = String.format(format, this.imsBaseUri, GlobalConfig.getClaim());
        } else {
            this.claim = claim;
        }
        this.cpfOpsCreateUri=cpfOpsCreateUri;
        validate();
    }

    public String getCpfOpsCreateUri(){
        return this.cpfOpsCreateUri;
    }

    public String getClaim() { return claim; }

    public String getImsBaseUri() { return imsBaseUri; }
}
