/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.cq.tabs;

import com.adobe.cq.testing.selenium.pagewidgets.DesignPicker;
import com.adobe.cq.testing.selenium.pagewidgets.common.AEMBaseComponent;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralCheckbox;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralMultiField;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralSelect;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralSelectList;
import com.adobe.cq.testing.selenium.pagewidgets.cq.FormField;
import com.adobe.cq.testing.selenium.utils.ElementUtils;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebDriverRunner;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public final class AdvancedTab
extends AEMBaseComponent {
    private SelenideElement designFieldButton = Selenide.$((String)(FormField.DESIGN_PATH + " button"));
    private String languageSelect = "./jcr:language";
    public static final FormField authenticationRequired = new FormField("./cq:authenticationRequired");
    private String advanceConfigInheritance = ".cq-cloudconfig-configpathbrowser coral-checkbox.inheritance";

    public AdvancedTab(String panelId) {
        super("#" + panelId);
    }

    public DesignPicker openDesignPicker() {
        ElementUtils.clickableClick(this.designFieldButton);
        DesignPicker designPicker = new DesignPicker();
        designPicker.getDesignPickerMainElement().shouldBe(new Condition[]{Condition.exist, Condition.visible});
        return designPicker;
    }

    public void selectLanguage(String language) {
        Selenide.$((String)("[name='" + this.languageSelect + "'] > button")).click();
        CoralSelectList coralSelectList = new CoralSelectList(Selenide.$((String)("[name='" + this.languageSelect + "']")));
        if (!coralSelectList.isVisible()) {
            CoralSelect selectList = new CoralSelect("name='" + this.languageSelect + "'");
            coralSelectList = selectList.openSelectList();
        }
        WebDriver webDriver = WebDriverRunner.getWebDriver();
        WebElement element = webDriver.findElement(By.cssSelector((String)("coral-selectlist-item[value='" + language + "']")));
        ((JavascriptExecutor)webDriver).executeScript("arguments[0].scrollIntoView(true);", new Object[]{element});
        coralSelectList.selectByValue(language);
    }

    public SelenideElement slingAlias() {
        return FormField.SLING_ALIAS.getFullyDecoratedElement("input", new String[0]);
    }

    public String getLanguageSelected() {
        return Selenide.$((String)("[name='" + this.languageSelect + "']")).$("[handle='label']").getText();
    }

    public CoralMultiField allowedTemplates() {
        return new CoralMultiField("./cq:allowedTemplates");
    }

    public CoralCheckbox authenticationRequired() {
        return new CoralCheckbox("coral-checkbox" + authenticationRequired);
    }

    public CoralCheckbox advanceConfigInheritance() {
        return new CoralCheckbox(this.advanceConfigInheritance);
    }
}

