/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.junit.extensions;

import com.adobe.cq.testing.client.CQClient;
import com.adobe.cq.testing.selenium.Constants;
import com.adobe.cq.testing.selenium.junit.annotations.SlingClientConfig;
import com.adobe.cq.testing.selenium.junit.annotations.SlingClientContext;
import com.adobe.cq.testing.selenium.junit.annotations.WithClient;
import com.adobe.cq.testing.selenium.junit.extensions.DefaultWithClient;
import com.adobe.cq.testing.selenium.utils.AnnotationHelper;
import com.adobe.cq.testing.util.GraniteBackwardsCompatibility;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ClassUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.instance.InstanceConfiguration;
import org.apache.sling.testing.clients.instance.InstanceSetup;
import org.apache.sling.testing.clients.interceptors.FormBasedAuthInterceptor;
import org.apache.sling.testing.clients.interceptors.HttpRequestResponseInterceptor;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SlingClientExtension
implements BeforeAllCallback,
AfterAllCallback,
ParameterResolver {
    private Store clientStore = Store.getInstance();

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        this.after(extensionContext);
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        GraniteBackwardsCompatibility.translateGranitePropertiesToSling();
        this.setupWithSlingClientConfig(extensionContext);
    }

    private void setupWithSlingClientConfig(ExtensionContext extensionContext) throws URISyntaxException {
        SlingClientConfig[] annotationsByType;
        Class requiredTestClass = extensionContext.getRequiredTestClass();
        for (SlingClientConfig config : annotationsByType = (SlingClientConfig[])requiredTestClass.getAnnotationsByType(SlingClientConfig.class)) {
            URI uri = new URIBuilder().setPath(config.contextPath()).setHost(config.host()).setPort(config.port()).setScheme(config.scheme()).build();
            InstanceConfiguration instanceConfiguration = new InstanceConfiguration(uri, config.runMode(), config.username(), config.password());
            InstanceSetup.get().getConfigurations().add(instanceConfiguration);
        }
    }

    private void after(ExtensionContext extensionContext) {
        this.clientStore.clear(extensionContext);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return this.isOfType(parameterContext, SlingClient.class, CQClient.class);
    }

    private boolean isOfType(ParameterContext context, Class ... clazz) {
        return Arrays.stream(clazz).anyMatch(p -> p.isAssignableFrom(context.getParameter().getType()));
    }

    private String getDefaultRunMode(ExtensionContext extensionContext) {
        return AnnotationHelper.findOptionalAnnotation(extensionContext, SlingClientContext.class).map(SlingClientContext::defaultRunMode).orElseThrow(() -> new ExtensionConfigurationException("@CQClientContext not found"));
    }

    private boolean getDefaultForceAnonymous(ExtensionContext extensionContext) {
        return AnnotationHelper.findOptionalAnnotation(extensionContext, SlingClientContext.class).map(SlingClientContext::defaultAnonymous).orElseThrow(() -> new ExtensionConfigurationException("@CQClientContext not found"));
    }

    private String getRunMode(ParameterContext parameterContext) {
        Optional annotation = parameterContext.findAnnotation(WithClient.class);
        return ((WithClient)annotation.orElse(new DefaultWithClient())).runMode();
    }

    private boolean getForceAnonymous(ParameterContext parameterContext) {
        return ((WithClient)parameterContext.findAnnotation(WithClient.class).orElse(new DefaultWithClient())).forceAnonymous();
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        String runMode = this.getDefaultRunMode(extensionContext);
        boolean forceAnonymous = this.getDefaultForceAnonymous(extensionContext);
        if (parameterContext.isAnnotated(WithClient.class)) {
            runMode = this.getRunMode(parameterContext);
            forceAnonymous = this.getForceAnonymous(parameterContext);
        }
        SlingClient client = this.clientStore.getOrCompute(extensionContext, runMode, forceAnonymous);
        Store.getInstance().saveLatest(extensionContext, client);
        assert (client != null);
        SlingClient returnedObject = client;
        if (this.isOfType(parameterContext, CQClient.class)) {
            try {
                returnedObject = client.adaptTo(CQClient.class);
            }
            catch (ClientException e) {
                throw new ParameterResolutionException(e.getMessage());
            }
        }
        return returnedObject;
    }

    public static final class Store {
        private static final Logger LOGGER = LoggerFactory.getLogger(Store.class);
        private static final String LOGIN_TOKEN_AUTH = "it.logintokenauth";
        private static final String AGENT = "Sling Testing Client %s";
        private static Store instance = new Store();
        private static final Map<String, InstanceConfiguration> DEFAULT_CONFIGURATION_MAP = Stream.of(new AbstractMap.SimpleImmutableEntry<String, InstanceConfiguration>("author", new InstanceConfiguration(URI.create("http://localhost:4502/"), "author", "admin", "admin")), new AbstractMap.SimpleImmutableEntry<String, InstanceConfiguration>("publish", new InstanceConfiguration(URI.create("http://localhost:4503/"), "publish", "admin", "admin"))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        private final boolean useLoginToken = Store.loginTokenAuth();

        private Store() {
        }

        private HashMap<String, SlingClient> getClientMapFromStore(ExtensionContext extensionContext) {
            HashMap stringSlingClientHashMap = (HashMap)extensionContext.getStore(Constants.NAMESPACE).get((Object)"slingClients");
            if (stringSlingClientHashMap == null) {
                stringSlingClientHashMap = new HashMap();
                extensionContext.getStore(Constants.NAMESPACE).put((Object)"slingClients", stringSlingClientHashMap);
            }
            return stringSlingClientHashMap;
        }

        private SlingClient buildClient(URI url, String key, String username, String password, boolean forceAnonymous) throws ClientException {
            LOGGER.info("Building client for url={} user={}", (Object)url, (Object)username);
            SlingClient.Builder builder = SlingClient.Builder.create((URI)url, (String)(forceAnonymous ? null : username), (String)password);
            if (this.useLoginToken) {
                Registry authSchemeRegistry = RegistryBuilder.create().build();
                builder.httpClientBuilder().setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry);
                builder.setPreemptiveAuth(false).addInterceptorFirst((HttpRequestResponseInterceptor)new FormBasedAuthInterceptor("login-token"));
            }
            builder.httpClientBuilder().setUserAgent(String.format(AGENT, key));
            return builder.build();
        }

        private InstanceConfiguration getInstanceConfiguration(String runMode) {
            InstanceSetup instanceSetup = InstanceSetup.get();
            List confList = instanceSetup.getConfigurations(runMode);
            InstanceConfiguration conf = DEFAULT_CONFIGURATION_MAP.get(runMode);
            if (!confList.isEmpty()) {
                conf = (InstanceConfiguration)confList.get(0);
            }
            return conf;
        }

        private String getKeyPrefix() {
            return "_" + Thread.currentThread().getId() + "_";
        }

        private String getTestInfo(ExtensionContext extensionContext) {
            StringBuilder testInfo = new StringBuilder();
            Optional testClass = extensionContext.getTestClass();
            testClass.ifPresent(aClass -> testInfo.append(ClassUtils.getAbbreviatedName((Class)aClass, (int)1)));
            Optional testMethod = extensionContext.getTestMethod();
            testMethod.ifPresent(method -> testInfo.append(".").append(method.getName()));
            return testInfo.toString();
        }

        public static Store getInstance() {
            return instance;
        }

        public SlingClient getOrCompute(ExtensionContext extensionContext, String runMode, boolean forceAnonymous) {
            return this.getOrCompute(extensionContext, runMode, null, null, forceAnonymous);
        }

        public SlingClient getOrCompute(ExtensionContext extensionContext, String runMode, String username, String password, boolean forceAnonymous) {
            InstanceConfiguration conf = this.getInstanceConfiguration(runMode);
            HashMap<String, SlingClient> clientMapFromStore = this.getClientMapFromStore(extensionContext);
            String user = username == null ? conf.getAdminUser() : username;
            String pass = password == null ? conf.getAdminPassword() : password;
            String testInfo = this.getTestInfo(extensionContext);
            String key = String.format("%stestInfo:%s_runMode:%s_user:%s_forceAnon:%s", this.getKeyPrefix(), testInfo, runMode, user, forceAnonymous);
            return clientMapFromStore.computeIfAbsent(key, k -> {
                try {
                    return this.buildClient(conf.getUrl(), key, user, pass, forceAnonymous);
                }
                catch (ClientException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            });
        }

        protected void saveLatest(ExtensionContext extensionContext, SlingClient latestClient) {
            String key = this.getKeyPrefix() + "latest";
            this.getClientMapFromStore(extensionContext).put(key, latestClient);
        }

        public SlingClient recallLatest(ExtensionContext extensionContext) {
            String key = this.getKeyPrefix() + "latest";
            return this.getClientMapFromStore(extensionContext).get(key);
        }

        protected void clear(ExtensionContext extensionContext) {
            String keyPrefix = this.getKeyPrefix();
            this.getClientMapFromStore(extensionContext).forEach((s, slingClient) -> {
                try {
                    if (s.startsWith(keyPrefix)) {
                        slingClient.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.warn(e.getMessage());
                }
            });
            this.getClientMapFromStore(extensionContext).clear();
        }

        private static boolean loginTokenAuth() {
            if (System.getProperties().contains(LOGIN_TOKEN_AUTH)) {
                return Boolean.getBoolean(LOGIN_TOKEN_AUTH);
            }
            return true;
        }
    }
}

