/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client.workflow;

import com.adobe.cq.testing.client.WorkflowClient;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WorkflowInstance {
    private JsonNode rootNode = null;

    public WorkflowInstance(JsonNode rootNode) {
        this.rootNode = rootNode;
    }

    public String getId() {
        if (this.rootNode.get("id") == null) {
            return null;
        }
        return this.rootNode.get("id").asText();
    }

    public WorkflowClient.Status getStatus() {
        if (this.rootNode.get("state") == null) {
            return null;
        }
        return WorkflowClient.Status.valueOf(this.rootNode.get("state").asText());
    }

    public String getModelId() {
        if (this.rootNode.get("model") == null) {
            return null;
        }
        return this.rootNode.get("model").asText();
    }

    public String getPayloadType() {
        if (this.rootNode.get("payloadType") == null) {
            return null;
        }
        return this.rootNode.get("payloadType").asText();
    }

    public String getPayload() {
        if (this.rootNode.get("payload") == null) {
            return null;
        }
        return this.rootNode.get("payload").asText();
    }

    public String getInitiator() {
        if (this.rootNode.get("initiator") == null) {
            return null;
        }
        return this.rootNode.get("initiator").asText();
    }

    public Date getStartTime() {
        if (this.rootNode.get("startTime") == null) {
            return null;
        }
        return WorkflowClient.parseJSONDate(this.rootNode.get("startTime").asText());
    }

    public Date getEndTime() {
        if (this.rootNode.get("endTime") == null) {
            return null;
        }
        return WorkflowClient.parseJSONDate(this.rootNode.get("endTime").asText());
    }

    public List<String> getWorkItemIds() {
        if (this.rootNode.get("workItems") == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        JsonNode itemsNode = this.rootNode.get("workItems");
        for (int i = 0; i < itemsNode.size(); ++i) {
            list.add(itemsNode.get(i).get("id").asText());
        }
        return list;
    }

    public Map<String, String> getWorkItems() {
        if (this.rootNode.get("workItems") == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        JsonNode itemsNode = this.rootNode.get("workItems");
        for (int i = 0; i < itemsNode.size(); ++i) {
            JsonNode workItem = itemsNode.get(i);
            map.put(workItem.get("id").asText(), workItem.get("node").asText());
        }
        return map;
    }
}

