/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client.security;

import java.io.Serializable;

public class PermissionConfig {
    private String authorizableId;
    private String path;
    private boolean read = false;
    private boolean modify = false;
    private boolean create = false;
    private boolean delete = false;
    private boolean aclRead = false;
    private boolean aclEdit = false;
    private boolean replicate = false;

    public static Builder builder() {
        return new Builder();
    }

    public String getAuthorizableId() {
        return this.authorizableId;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isRead() {
        return this.read;
    }

    public boolean isModify() {
        return this.modify;
    }

    public boolean isCreate() {
        return this.create;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public boolean isAclRead() {
        return this.aclRead;
    }

    public boolean isAclEdit() {
        return this.aclEdit;
    }

    public boolean isReplicate() {
        return this.replicate;
    }

    public static class Builder
    implements Serializable {
        PermissionConfig config = new PermissionConfig();

        Builder() {
        }

        public Builder withAuthorizableId(String authorizableId) {
            this.config.authorizableId = authorizableId;
            return this;
        }

        public Builder withPath(String path) {
            this.config.path = path;
            return this;
        }

        public Builder withRead() {
            this.config.read = true;
            return this;
        }

        public Builder withModify() {
            this.config.modify = true;
            return this;
        }

        public Builder withCreate() {
            this.config.create = true;
            return this;
        }

        public Builder withDelete() {
            this.config.delete = true;
            return this;
        }

        public Builder withAclRead() {
            this.config.aclRead = true;
            return this;
        }

        public Builder withAclEdit() {
            this.config.aclEdit = true;
            return this;
        }

        public Builder withReplicate() {
            this.config.replicate = true;
            return this;
        }

        public Builder withoutRead() {
            this.config.read = false;
            return this;
        }

        public Builder withoutModify() {
            this.config.modify = false;
            return this;
        }

        public Builder withoutCreate() {
            this.config.create = false;
            return this;
        }

        public Builder withoutDelete() {
            this.config.delete = false;
            return this;
        }

        public Builder withoutAclRead() {
            this.config.aclRead = false;
            return this;
        }

        public Builder withoutAclEdit() {
            this.config.aclEdit = false;
            return this;
        }

        public Builder withoutReplicate() {
            this.config.replicate = false;
            return this;
        }

        public PermissionConfig build() {
            return this.config;
        }
    }
}

