/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client;

import com.adobe.cq.testing.util.WCMCommands;
import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.apache.sling.testing.clients.util.HttpUtils;
import org.apache.sling.testing.clients.util.JsonUtils;
import org.apache.sling.testing.clients.util.ResourceUtil;
import org.apache.sling.testing.clients.util.poller.Polling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class CQClient
extends SlingClient {
    public static Logger LOG = LoggerFactory.getLogger(CQClient.class);
    protected static final String STATISTICS_ROOT = "/var/statistics/pages";
    protected final WCMCommands wcmCommands = new WCMCommands(this);

    public CQClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    public CQClient(URI url, String user, String password) throws ClientException {
        super(url, user, password);
    }

    public SlingHttpResponse createPage(String pageName, String pageTitle, String parentPath, String templatePath, int ... expectedStatus) throws ClientException {
        return this.wcmCommands.createPage(pageName, pageTitle, parentPath, templatePath, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse createPageWithRetry(final String pageName, final String pageTitle, final String parentPath, final String templatePath, long timeout, long delay, final int ... expectedStatus) throws ClientException, InterruptedException {
        class CreatePagePolling
        extends Polling {
            SlingHttpResponse response;
            final /* synthetic */ CQClient this$0;

            CreatePagePolling() {
                this.this$0 = this$0;
            }

            public Boolean call() throws Exception {
                this.response = this.this$0.wcmCommands.createPage(pageName, pageTitle, parentPath, templatePath, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
                return true;
            }
        }
        CreatePagePolling createPolling = new CreatePagePolling();
        try {
            createPolling.poll(timeout, delay);
        }
        catch (TimeoutException e) {
            if (createPolling.getLastException() != null) {
                LOG.error("Page creation timed out. Last Exception: ", (Throwable)createPolling.getLastException());
            }
            throw new ClientException("Failed to create page " + pageName + " in " + createPolling.getWaited(), (Throwable)e);
        }
        return createPolling.response;
    }

    public SlingHttpResponse deletePage(String[] pagePaths, boolean force, boolean shallow, int ... expectedStatus) throws ClientException {
        return this.wcmCommands.deletePage(pagePaths, force, shallow, expectedStatus);
    }

    public SlingHttpResponse deletePageWithRetry(final String pagePath, final boolean force, final boolean shallow, long timeout, long delay, final int ... expectedStatus) throws ClientException, InterruptedException {
        class DeletePagePolling
        extends Polling {
            SlingHttpResponse response;
            final /* synthetic */ CQClient this$0;

            DeletePagePolling() {
                this.this$0 = this$0;
            }

            public Boolean call() throws ClientException {
                this.response = this.this$0.deletePage(new String[]{pagePath}, force, shallow, expectedStatus);
                return !this.this$0.pageExists(pagePath);
            }
        }
        DeletePagePolling deletePagePolling = new DeletePagePolling();
        try {
            deletePagePolling.poll(timeout, delay);
        }
        catch (TimeoutException e) {
            if (deletePagePolling.getLastException() != null) {
                LOG.error("Page deletion timed out. Last Exception: ", (Throwable)deletePagePolling.getLastException());
            }
            throw new ClientException("Could not delete page " + pagePath + " as user " + this.getUser(), (Throwable)e);
        }
        return deletePagePolling.response;
    }

    public boolean pageExists(String pagePath) throws ClientException {
        SlingHttpResponse response = this.getAuthorSitesPage(pagePath, new int[0]);
        int status = response.getStatusLine().getStatusCode();
        return status == 200;
    }

    public boolean pageExistsWithRetry(String pagePath, int timeout) throws InterruptedException {
        try {
            new Polling(() -> this.pageExists(pagePath)).poll((long)timeout, 500L);
        }
        catch (TimeoutException e) {
            return false;
        }
        return true;
    }

    public boolean pageExistsWithRetry(String pagePath) throws InterruptedException {
        return this.pageExistsWithRetry(pagePath, 1000);
    }

    public SlingHttpResponse getAuthorSitesPage(String pagePath, int ... expectedStatus) throws ClientException {
        String uriPath = this.getPageAbsoluteUri(pagePath).toString();
        return this.doGet(uriPath, expectedStatus);
    }

    private URI getPageAbsoluteUri(String pagePath) {
        String path = pagePath.endsWith(".html") ? pagePath : pagePath.replaceFirst("/*$", "").concat(".html");
        return this.getUrl(path);
    }

    public SlingHttpResponse copyPage(String[] srcPaths, String destName, String destPath, String destParentPath, String before, boolean shallow, int ... expectedStatus) throws ClientException {
        return this.wcmCommands.copyPage(srcPaths, destName, destParentPath, before, shallow, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse movePage(String[] srcPaths, String destName, String destPath, String destParentPath, String before, boolean shallow, boolean integrity, String[] adjusts, int ... expectedStatus) throws ClientException {
        return this.wcmCommands.movePage(srcPaths, destName, destParentPath, before, shallow, integrity, adjusts, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse movePage(String[] srcPaths, String destName, String destPath, String destParentPath, String before, boolean shallow, boolean integrity, String[] adjusts, String[] publishes, int ... expectedStatus) throws ClientException {
        return this.wcmCommands.movePage(srcPaths, destName, destParentPath, before, shallow, integrity, adjusts, publishes, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse lockPage(String path, int ... expectedStatus) throws ClientException {
        return this.wcmCommands.lockPage(path, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse unlockPage(String path, int ... expectedStatus) throws ClientException {
        return this.wcmCommands.unlockPage(path, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse setPageProperty(String pagePath, String propName, String propValue, int ... expectedStatus) throws ClientException {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        list.add((NameValuePair)new BasicNameValuePair(propName, propValue));
        return this.setPageProperties(pagePath, list, expectedStatus);
    }

    public SlingHttpResponse setPageProperties(String pagePath, List<NameValuePair> props, int ... expectedStatus) throws ClientException {
        UrlEncodedFormEntity formEntry = FormEntityBuilder.create().addParameter("_charset_", "utf-8").addAllParameters(props).build();
        return this.doPost(pagePath + "/jcr:content", (HttpEntity)formEntry, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse setPagePropertyImage(String pagePath, String mimeType, String fileName, String resourcePath, int ... expectedStatus) throws ClientException {
        HttpEntity entity = MultipartEntityBuilder.create().addBinaryBody("./image/file", ResourceUtil.getResourceAsStream((String)resourcePath), ContentType.create((String)mimeType), fileName).setCharset(StandardCharsets.UTF_8).build();
        return this.doPost(pagePath + "/jcr:content", entity, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse uploadFileCQStyle(String fileName, String resourcePath, String mimeType, String parentPath, int ... expectedStatus) throws ClientException {
        String filePath = parentPath + "/" + fileName;
        HttpEntity entity = MultipartEntityBuilder.create().addBinaryBody("file", ResourceUtil.getResourceAsStream((String)resourcePath), ContentType.create((String)mimeType), fileName).addTextBody("fileName", fileName).setCharset(StandardCharsets.UTF_8).build();
        return this.doPost(filePath, entity, HttpUtils.getExpectedStatus((int)201, (int[])expectedStatus));
    }

    public SlingHttpResponse createVersion(String pagePath, String comment, String label, int ... expectedStatus) throws ClientException {
        return this.wcmCommands.createVersion(pagePath, comment, label, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse restoreVersion(String[] versionIds, String pagePath, int ... expectedStatus) throws ClientException {
        return this.wcmCommands.restoreVersion(versionIds, pagePath, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse restoreTree(String path, Date date, boolean preserveNVP, int ... expectedStatus) throws ClientException {
        return this.wcmCommands.restoreTree(path, date, preserveNVP, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse copyLanguages(String sitePath, List<BasicNameValuePair> relPaths, int ... expectedStatus) throws ClientException {
        return this.wcmCommands.copyLanguages(sitePath, relPaths, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse rolloutPage(String srcPath, String[] targetPaths, boolean deep, boolean reset, boolean useBackgroundJob, int ... expectedStatus) throws ClientException {
        return this.wcmCommands.rollout(new String[]{srcPath}, targetPaths, null, deep ? "deep" : "page", reset, useBackgroundJob, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public JsonNode searchInPages(String startPath, String searchQuery, boolean caseSensitive, boolean wholeWordOnly) throws Exception {
        String searchPath = startPath + ".find.json";
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("f", searchQuery));
        params.add(new BasicNameValuePair("_charset_", "utf-8"));
        params.add(new BasicNameValuePair("cs", Boolean.toString(caseSensitive)));
        params.add(new BasicNameValuePair("wwo", Boolean.toString(wholeWordOnly)));
        SlingHttpResponse exec = this.doGet(searchPath, params, new int[]{200});
        return JsonUtils.getJsonNodeFromString((String)exec.getContent());
    }

    public void searchAndReplaceInPages(String startPath, String searchQuery, String replace, boolean caseSensitive, boolean wholeWordOnly) throws Exception {
        JsonNode pages = this.searchInPages(startPath, searchQuery, caseSensitive, wholeWordOnly).get("matches");
        if (pages.isArray() && pages.size() > 0) {
            String replacePath = startPath + ".replace.json";
            FormEntityBuilder entityBuilder = FormEntityBuilder.create();
            entityBuilder.addParameter("_charset_", "utf-8");
            entityBuilder.addParameter("f", searchQuery);
            entityBuilder.addParameter("r", replace);
            if (caseSensitive) {
                entityBuilder.addParameter("cs", "on");
            }
            if (wholeWordOnly) {
                entityBuilder.addParameter("wwo", "on");
            }
            Iterator it = pages.elements();
            while (it.hasNext()) {
                JsonNode page = (JsonNode)it.next();
                entityBuilder.addParameter("p", page.get("path").textValue());
            }
            this.doPost(replacePath, (HttpEntity)entityBuilder.build(), new int[]{200});
        }
    }

    public void resetPageStatistics(String pagePath) throws ClientException {
        this.deletePath(STATISTICS_ROOT + pagePath, new int[0]);
    }

    public static final class Builder
    extends InternalBuilder<CQClient> {
        private Builder(URI url, String user, String password) {
            super(url, user, password);
        }

        public CQClient build() throws ClientException {
            return new CQClient(this.buildHttpClient(), this.buildSlingClientConfig());
        }

        public static Builder create(URI url, String user, String password) {
            return new Builder(url, user, password);
        }
    }

    public static abstract class InternalBuilder<T extends CQClient>
    extends SlingClient.InternalBuilder<T> {
        protected InternalBuilder(URI url, String user, String password) {
            super(url, user, password);
        }
    }
}

