/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import com.adjust.sdk.AdjustAdRevenue;
import com.adjust.sdk.AdjustConfig;
import com.adjust.sdk.AdjustDeeplink;
import com.adjust.sdk.AdjustEvent;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.AdjustInstance;
import com.adjust.sdk.AdjustPlayStorePurchase;
import com.adjust.sdk.AdjustPlayStoreSubscription;
import com.adjust.sdk.AdjustTestOptions;
import com.adjust.sdk.AdjustThirdPartySharing;
import com.adjust.sdk.OnAdidReadListener;
import com.adjust.sdk.OnAmazonAdIdReadListener;
import com.adjust.sdk.OnAttributionReadListener;
import com.adjust.sdk.OnDeeplinkResolvedListener;
import com.adjust.sdk.OnGoogleAdIdReadListener;
import com.adjust.sdk.OnGooglePlayInstallReferrerReadListener;
import com.adjust.sdk.OnIsEnabledListener;
import com.adjust.sdk.OnLastDeeplinkReadListener;
import com.adjust.sdk.OnPurchaseVerificationFinishedListener;
import com.adjust.sdk.OnSdkVersionReadListener;
import com.adjust.sdk.Util;
import java.util.Map;

public class Adjust {
    private static AdjustInstance defaultInstance;

    private Adjust() {
    }

    public static synchronized AdjustInstance getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new AdjustInstance();
        }
        return defaultInstance;
    }

    public static void initSdk(AdjustConfig adjustConfig) {
        Adjust.getDefaultInstance().initSdk(adjustConfig);
    }

    public static void trackEvent(AdjustEvent adjustEvent) {
        Adjust.getDefaultInstance().trackEvent(adjustEvent);
    }

    public static void onResume() {
        Adjust.getDefaultInstance().onResume();
    }

    public static void onPause() {
        Adjust.getDefaultInstance().onPause();
    }

    public static void enable() {
        Adjust.getDefaultInstance().enable();
    }

    public static void disable() {
        Adjust.getDefaultInstance().disable();
    }

    public static void isEnabled(Context context, OnIsEnabledListener onIsEnabledListener) {
        if (context == null) {
            AdjustFactory.getLogger().error("null context", new Object[0]);
            return;
        }
        if (onIsEnabledListener == null) {
            AdjustFactory.getLogger().error("Callback for getting isEnabled can't be null", new Object[0]);
            return;
        }
        Adjust.getDefaultInstance().isEnabled(Adjust.extractApplicationContext(context), onIsEnabledListener);
    }

    public static boolean isAdjustUninstallDetectionPayload(Map<String, String> map) {
        return Util.isAdjustUninstallDetectionPayload(map);
    }

    public static void processDeeplink(AdjustDeeplink adjustDeeplink, Context context) {
        Adjust.getDefaultInstance().processDeeplink(adjustDeeplink, Adjust.extractApplicationContext(context));
    }

    public static void processAndResolveDeeplink(AdjustDeeplink adjustDeeplink, Context context, OnDeeplinkResolvedListener onDeeplinkResolvedListener) {
        Adjust.getDefaultInstance().processAndResolveDeeplink(adjustDeeplink, Adjust.extractApplicationContext(context), onDeeplinkResolvedListener);
    }

    public static void setReferrer(String string, Context context) {
        Adjust.getDefaultInstance().sendReferrer(string, Adjust.extractApplicationContext(context));
    }

    public static void switchToOfflineMode() {
        Adjust.getDefaultInstance().switchToOfflineMode();
    }

    public static void switchBackToOnlineMode() {
        Adjust.getDefaultInstance().switchBackToOnlineMode();
    }

    public static void addGlobalCallbackParameter(String string, String string2) {
        Adjust.getDefaultInstance().addGlobalCallbackParameter(string, string2);
    }

    public static void addGlobalPartnerParameter(String string, String string2) {
        Adjust.getDefaultInstance().addGlobalPartnerParameter(string, string2);
    }

    public static void removeGlobalCallbackParameter(String string) {
        Adjust.getDefaultInstance().removeGlobalCallbackParameter(string);
    }

    public static void removeGlobalPartnerParameter(String string) {
        Adjust.getDefaultInstance().removeGlobalPartnerParameter(string);
    }

    public static void removeGlobalCallbackParameters() {
        Adjust.getDefaultInstance().removeGlobalCallbackParameters();
    }

    public static void removeGlobalPartnerParameters() {
        Adjust.getDefaultInstance().removeGlobalPartnerParameters();
    }

    public static void setPushToken(String string, Context context) {
        Adjust.getDefaultInstance().setPushToken(string, Adjust.extractApplicationContext(context));
    }

    public static void gdprForgetMe(Context context) {
        Adjust.getDefaultInstance().gdprForgetMe(Adjust.extractApplicationContext(context));
    }

    public static void trackThirdPartySharing(AdjustThirdPartySharing adjustThirdPartySharing) {
        Adjust.getDefaultInstance().trackThirdPartySharing(adjustThirdPartySharing);
    }

    public static void trackMeasurementConsent(boolean bl) {
        Adjust.getDefaultInstance().trackMeasurementConsent(bl);
    }

    public static void trackAdRevenue(AdjustAdRevenue adjustAdRevenue) {
        Adjust.getDefaultInstance().trackAdRevenue(adjustAdRevenue);
    }

    public static void trackPlayStoreSubscription(AdjustPlayStoreSubscription adjustPlayStoreSubscription) {
        Adjust.getDefaultInstance().trackPlayStoreSubscription(adjustPlayStoreSubscription);
    }

    public static void getGoogleAdId(Context context, OnGoogleAdIdReadListener onGoogleAdIdReadListener) {
        if (onGoogleAdIdReadListener == null) {
            AdjustFactory.getLogger().error("onGoogleAdIdReadListener cannot be null", new Object[0]);
            return;
        }
        if (context == null) {
            AdjustFactory.getLogger().error("getGoogleAdId: null context", new Object[0]);
            return;
        }
        Util.getGoogleAdId(context.getApplicationContext(), onGoogleAdIdReadListener);
    }

    public static void getAmazonAdId(Context context, OnAmazonAdIdReadListener onAmazonAdIdReadListener) {
        if (onAmazonAdIdReadListener == null) {
            AdjustFactory.getLogger().error("onAmazonAdIdReadListener cannot be null", new Object[0]);
            return;
        }
        if ((context = Adjust.extractApplicationContext(context)) == null) {
            AdjustFactory.getLogger().error("getAmazonAdId: null context", new Object[0]);
            return;
        }
        Adjust.getDefaultInstance().getAmazonAdId(context, onAmazonAdIdReadListener);
    }

    public static void getAdid(OnAdidReadListener onAdidReadListener) {
        if (onAdidReadListener == null) {
            AdjustFactory.getLogger().error("Callback for getting adid can't be null", new Object[0]);
            return;
        }
        Adjust.getDefaultInstance().getAdid(onAdidReadListener);
    }

    public static void getAttribution(OnAttributionReadListener onAttributionReadListener) {
        if (onAttributionReadListener == null) {
            AdjustFactory.getLogger().error("Callback for getting attribution can't be null", new Object[0]);
            return;
        }
        Adjust.getDefaultInstance().getAttribution(onAttributionReadListener);
    }

    public static void getGooglePlayInstallReferrer(Context context, OnGooglePlayInstallReferrerReadListener onGooglePlayInstallReferrerReadListener) {
        if (onGooglePlayInstallReferrerReadListener == null) {
            AdjustFactory.getLogger().error("onGooglePlayInstallReferrerReadListener cannot be null", new Object[0]);
            return;
        }
        if (context == null) {
            AdjustFactory.getLogger().error("null context", new Object[0]);
            return;
        }
        Adjust.getDefaultInstance().getGooglePlayInstallReferrer(context, onGooglePlayInstallReferrerReadListener);
    }

    public static void getLastDeeplink(Context context, OnLastDeeplinkReadListener onLastDeeplinkReadListener) {
        if (onLastDeeplinkReadListener == null) {
            AdjustFactory.getLogger().error("onLastDeeplinkReadListener cannot be null", new Object[0]);
            return;
        }
        if (context == null) {
            AdjustFactory.getLogger().error("null context", new Object[0]);
            return;
        }
        Adjust.getDefaultInstance().getLastDeeplink(context, onLastDeeplinkReadListener);
    }

    public static void getSdkVersion(OnSdkVersionReadListener onSdkVersionReadListener) {
        if (onSdkVersionReadListener == null) {
            AdjustFactory.getLogger().error("onSdkVersionReadListener cannot be null", new Object[0]);
            return;
        }
        Adjust.getDefaultInstance().getSdkVersion(onSdkVersionReadListener);
    }

    public static void verifyPlayStorePurchase(AdjustPlayStorePurchase adjustPlayStorePurchase, OnPurchaseVerificationFinishedListener onPurchaseVerificationFinishedListener) {
        if (onPurchaseVerificationFinishedListener == null) {
            AdjustFactory.getLogger().error("Purchase verification aborted because verification callback is null", new Object[0]);
            return;
        }
        Adjust.getDefaultInstance().verifyPlayStorePurchase(adjustPlayStorePurchase, onPurchaseVerificationFinishedListener);
    }

    public static void verifyAndTrackPlayStorePurchase(AdjustEvent adjustEvent, OnPurchaseVerificationFinishedListener onPurchaseVerificationFinishedListener) {
        Adjust.getDefaultInstance().verifyAndTrackPlayStorePurchase(adjustEvent, onPurchaseVerificationFinishedListener);
    }

    public static void endFirstSessionDelay() {
        Adjust.getDefaultInstance().endFirstSessionDelay();
    }

    public static void enableCoppaComplianceInDelay() {
        Adjust.getDefaultInstance().enableCoppaComplianceInDelay();
    }

    public static void disableCoppaComplianceInDelay() {
        Adjust.getDefaultInstance().disableCoppaComplianceInDelay();
    }

    public static void enablePlayStoreKidsComplianceInDelay() {
        Adjust.getDefaultInstance().enablePlayStoreKidsComplianceInDelay();
    }

    public static void disablePlayStoreKidsComplianceInDelay() {
        Adjust.getDefaultInstance().disablePlayStoreKidsComplianceInDelay();
    }

    public static void setExternalDeviceIdInDelay(String string) {
        Adjust.getDefaultInstance().setExternalDeviceIdInDelay(string);
    }

    public static void setTestOptions(AdjustTestOptions adjustTestOptions) {
        Object object = adjustTestOptions.teardown;
        if (object != null && ((Boolean)object).booleanValue()) {
            object = defaultInstance;
            if (object != null) {
                ((AdjustInstance)object).teardown();
            }
            defaultInstance = null;
            AdjustFactory.teardown(adjustTestOptions.context);
        }
        Adjust.getDefaultInstance().setTestOptions(adjustTestOptions);
    }

    private static Context extractApplicationContext(Context context) {
        if (context == null) {
            return null;
        }
        return context.getApplicationContext();
    }
}

