/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import android.os.Process;
import android.text.TextUtils;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.ActivityState;
import com.adjust.sdk.AdjustAdRevenue;
import com.adjust.sdk.AdjustAttribution;
import com.adjust.sdk.AdjustConfig;
import com.adjust.sdk.AdjustDeeplink;
import com.adjust.sdk.AdjustEvent;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.AdjustPlayStorePurchase;
import com.adjust.sdk.AdjustPlayStoreSubscription;
import com.adjust.sdk.AdjustPurchaseVerificationResult;
import com.adjust.sdk.AdjustSigner;
import com.adjust.sdk.AdjustThirdPartySharing;
import com.adjust.sdk.AttributionResponseData;
import com.adjust.sdk.DeviceInfo;
import com.adjust.sdk.EventResponseData;
import com.adjust.sdk.FirstSessionDelayManager;
import com.adjust.sdk.GlobalParameters;
import com.adjust.sdk.IActivityHandler;
import com.adjust.sdk.IAttributionHandler;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.IPackageHandler;
import com.adjust.sdk.IPurchaseVerificationHandler;
import com.adjust.sdk.IRunActivityHandler;
import com.adjust.sdk.ISdkClickHandler;
import com.adjust.sdk.InstallReferrer;
import com.adjust.sdk.InstallReferrerReadListener;
import com.adjust.sdk.LicenseData;
import com.adjust.sdk.OnAdidReadListener;
import com.adjust.sdk.OnAttributionReadListener;
import com.adjust.sdk.OnDeeplinkResolvedListener;
import com.adjust.sdk.OnIsEnabledListener;
import com.adjust.sdk.OnPurchaseVerificationFinishedListener;
import com.adjust.sdk.PackageBuilder;
import com.adjust.sdk.PackageFactory;
import com.adjust.sdk.PreinstallUtil;
import com.adjust.sdk.PurchaseVerificationResponseData;
import com.adjust.sdk.ReferrerDetails;
import com.adjust.sdk.Reflection;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.SdkClickResponseData;
import com.adjust.sdk.SessionResponseData;
import com.adjust.sdk.SharedPreferencesManager;
import com.adjust.sdk.SystemLifecycle;
import com.adjust.sdk.Util;
import com.adjust.sdk.network.ActivityPackageSender;
import com.adjust.sdk.network.IActivityPackageSender;
import com.adjust.sdk.network.UtilNetworking;
import com.adjust.sdk.scheduler.SingleThreadCachedScheduler;
import com.adjust.sdk.scheduler.ThreadExecutor;
import com.adjust.sdk.scheduler.TimerCycle;
import com.adjust.sdk.scheduler.TimerOnce;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ActivityHandler
implements IActivityHandler,
SystemLifecycle.SystemLifecycleCallback {
    private static long FOREGROUND_TIMER_INTERVAL;
    private static long FOREGROUND_TIMER_START;
    private static long BACKGROUND_TIMER_INTERVAL;
    private static long SESSION_INTERVAL;
    private static long SUBSESSION_INTERVAL;
    private static final String TIME_TRAVEL = "Time travel!";
    private static final String ACTIVITY_STATE_NAME = "Activity state";
    private static final String ATTRIBUTION_NAME = "Attribution";
    private static final String FOREGROUND_TIMER_NAME = "Foreground timer";
    private static final String BACKGROUND_TIMER_NAME = "Background timer";
    private static final String DELAY_START_TIMER_NAME = "Delay Start timer";
    private static final String GLOBAL_CALLBACK_PARAMETERS_NAME = "Global Callback parameters";
    private static final String GLOBAL_PARTNER_PARAMETERS_NAME = "Global Partner parameters";
    private static final String GLOBAL_PARAMETERS_NAME = "Global parameters";
    ThreadExecutor executor;
    private IPackageHandler packageHandler;
    private ActivityState activityState;
    private ILogger logger;
    private TimerCycle foregroundTimer;
    private TimerOnce backgroundTimer;
    private InternalState internalState;
    private String basePath;
    private String gdprPath;
    private String subscriptionPath;
    private DeviceInfo deviceInfo;
    private AdjustConfig adjustConfig;
    private AdjustAttribution attribution;
    private IAttributionHandler attributionHandler;
    private ISdkClickHandler sdkClickHandler;
    private IPurchaseVerificationHandler purchaseVerificationHandler;
    private GlobalParameters globalParameters;
    private InstallReferrer installReferrer;
    private OnDeeplinkResolvedListener cachedDeeplinkResolutionCallback;
    private ArrayList<OnAdidReadListener> cachedAdidReadCallbacks;
    private SystemLifecycle systemLifecycle;
    private ArrayList<OnAttributionReadListener> cachedAttributionReadCallbacks;
    private List<AdjustThirdPartySharing> cachedAdjustThirdPartySharingArray;
    private Boolean cachedLastMeasurementConsentTrack;
    private FirstSessionDelayManager firstSessionDelayManager;

    public static void deleteState(Context context) {
        Context context2 = context;
        ActivityHandler.deleteActivityState(context2);
        ActivityHandler.deleteAttribution(context2);
        ActivityHandler.deleteGlobalCallbackParameters(context2);
        ActivityHandler.deleteGlobalPartnerParameters(context2);
        SharedPreferencesManager.getDefaultInstance(context2).clear();
    }

    private ActivityHandler(AdjustConfig adjustConfig) {
        InternalState internalState;
        SingleThreadCachedScheduler singleThreadCachedScheduler;
        ArrayList arrayList;
        ArrayList arrayList2;
        ActivityHandler activityHandler = this;
        Object object = arrayList2;
        arrayList2 = new ArrayList();
        activityHandler.cachedAdidReadCallbacks = object;
        object = arrayList;
        arrayList = new ArrayList();
        activityHandler.cachedAttributionReadCallbacks = object;
        activityHandler.init(adjustConfig);
        this.logger = AdjustFactory.getLogger();
        this.logger.lockLogLevel();
        object = singleThreadCachedScheduler;
        singleThreadCachedScheduler = new SingleThreadCachedScheduler("ActivityHandler");
        activityHandler.executor = object;
        object = internalState;
        internalState = new InternalState();
        activityHandler.internalState = object;
        Boolean bl = adjustConfig.startEnabled;
        boolean bl2 = bl != null ? bl : true;
        ActivityHandler activityHandler2 = this;
        ((InternalState)object).enabled = bl2;
        InternalState internalState2 = activityHandler2.internalState;
        internalState2.offline = adjustConfig.startOffline;
        internalState2.sessionResponseProcessed = false;
        internalState2.preinstallHasBeenRead = false;
        activityHandler2.cachedAdjustThirdPartySharingArray = null;
        activityHandler2.cachedLastMeasurementConsentTrack = null;
        activityHandler2.firstSessionDelayManager = new FirstSessionDelayManager(this);
        activityHandler2.executor.submit(() -> this.lambda$new$2(adjustConfig));
    }

    public static ActivityHandler getInstance(AdjustConfig object) {
        if (object == null) {
            AdjustFactory.getLogger().error("AdjustConfig missing", new Object[0]);
            return null;
        }
        if (!((AdjustConfig)object).isValid()) {
            AdjustFactory.getLogger().error("AdjustConfig not initialized correctly", new Object[0]);
            return null;
        }
        if (((AdjustConfig)object).processName != null) {
            int n = Process.myPid();
            Object object2 = (ActivityManager)((AdjustConfig)object).context.getSystemService("activity");
            if (object2 == null) {
                return null;
            }
            if ((object2 = object2.getRunningAppProcesses()) == null) {
                return null;
            }
            object2 = object2.iterator();
            while (object2.hasNext()) {
                ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)object2.next();
                if (runningAppProcessInfo.pid != n) continue;
                if (runningAppProcessInfo.processName.equalsIgnoreCase(((AdjustConfig)object).processName)) break;
                object = runningAppProcessInfo.processName;
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = object;
                AdjustFactory.getLogger().info("Skipping initialization in background process (%s)", objectArray2);
                return null;
            }
        }
        return new ActivityHandler((AdjustConfig)object);
    }

    private boolean isEnabledI() {
        ActivityState activityState = this.activityState;
        if (activityState != null) {
            return activityState.enabled;
        }
        return this.internalState.isEnabled();
    }

    private void updateAdidI(final String string) {
        if (string != null) {
            if (!string.equals(this.activityState.adid)) {
                this.activityState.adid = string;
                this.writeActivityStateI();
            }
            if (!this.cachedAdidReadCallbacks.isEmpty()) {
                ArrayList<OnAdidReadListener> arrayList;
                final ArrayList<OnAdidReadListener> arrayList2 = arrayList;
                arrayList = new ArrayList<OnAdidReadListener>(this.cachedAdidReadCallbacks);
                this.cachedAdidReadCallbacks.clear();
                new Handler(this.adjustConfig.context.getMainLooper()).post(new Runnable(){

                    @Override
                    public final void run() {
                        ArrayList arrayList = arrayList2;
                        int n = arrayList.size();
                        for (int i = 0; i < n; ++i) {
                            Object e = arrayList.get(i);
                            OnAdidReadListener onAdidReadListener = (OnAdidReadListener)e;
                            if (onAdidReadListener == null) continue;
                            onAdidReadListener.onAdidRead(string);
                        }
                    }
                });
                return;
            }
        }
    }

    private void handleAttributionCallbackI() {
        ActivityHandler activityHandler = this;
        activityHandler.cachedAttributionReadCallbacks.addAll(this.adjustConfig.cachedAttributionReadCallbacks);
        activityHandler.adjustConfig.cachedAttributionReadCallbacks.clear();
        if (!activityHandler.cachedAttributionReadCallbacks.isEmpty() && this.attribution != null) {
            ArrayList<OnAttributionReadListener> arrayList;
            ActivityHandler activityHandler2 = this;
            final ArrayList<OnAttributionReadListener> arrayList2 = arrayList;
            arrayList = new ArrayList<OnAttributionReadListener>(this.cachedAttributionReadCallbacks);
            final AdjustAttribution adjustAttribution = activityHandler2.attribution;
            activityHandler2.cachedAttributionReadCallbacks.clear();
            new Handler(this.adjustConfig.context.getMainLooper()).post(new Runnable(){

                @Override
                public final void run() {
                    ArrayList arrayList = arrayList2;
                    int n = arrayList.size();
                    for (int i = 0; i < n; ++i) {
                        Object e = arrayList.get(i);
                        OnAttributionReadListener onAttributionReadListener = (OnAttributionReadListener)e;
                        if (onAttributionReadListener == null) continue;
                        onAttributionReadListener.onAttributionRead(adjustAttribution);
                    }
                }
            });
            return;
        }
    }

    private void handleAdidCallbackI() {
        Cloneable cloneable;
        ActivityHandler activityHandler = this;
        activityHandler.cachedAdidReadCallbacks.addAll(this.adjustConfig.cachedAdidReadCallbacks);
        activityHandler.adjustConfig.cachedAdidReadCallbacks.clear();
        if (!activityHandler.cachedAdidReadCallbacks.isEmpty() && (cloneable = this.activityState) != null && cloneable.adid != null) {
            ArrayList<OnAdidReadListener> arrayList;
            ActivityHandler activityHandler2 = this;
            cloneable = arrayList;
            arrayList = new ArrayList<OnAdidReadListener>(this.cachedAdidReadCallbacks);
            String string = activityHandler2.activityState.adid;
            activityHandler2.cachedAdidReadCallbacks.clear();
            new Handler(this.adjustConfig.context.getMainLooper()).post(new Runnable((ArrayList)cloneable, string){
                public final /* synthetic */ ArrayList a;
                public final /* synthetic */ String b;
                {
                    this.a = arrayList;
                    this.b = string;
                }

                @Override
                public final void run() {
                    ArrayList arrayList = this.a;
                    int n = arrayList.size();
                    for (int i = 0; i < n; ++i) {
                        Object e = arrayList.get(i);
                        OnAdidReadListener onAdidReadListener = (OnAdidReadListener)e;
                        if (onAdidReadListener == null) continue;
                        onAdidReadListener.onAdidRead(this.b);
                    }
                }
            });
            return;
        }
    }

    private void bootstrapLifecycleI() {
        SystemLifecycle systemLifecycle = SystemLifecycle.getSingletonInstance();
        this.systemLifecycle = systemLifecycle;
        for (String string : systemLifecycle.logMessageList) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string;
            this.logger.debug("Lifecycle: %s", objectArray2);
        }
        this.systemLifecycle.overwriteCallback(this);
        if (!AdjustFactory.isSystemLifecycleBootstrapIgnored()) {
            this.internalState.foregroundOrElseBackground = this.systemLifecycle.foregroundOrElseBackgroundCached();
            if (this.internalState.isInForeground()) {
                this.onResumeI();
                return;
            }
        }
    }

    private void checkForPreinstallI() {
        Object object;
        block32: {
            block31: {
                object = this.activityState;
                if (object == null || !((ActivityState)object).enabled || ((ActivityState)object).isGdprForgotten) break block31;
                this.sendPreinstallReferrerI();
                if (this.adjustConfig.isPreinstallTrackingEnabled && !this.internalState.hasPreinstallBeenRead()) break block32;
            }
            return;
        }
        object = this.deviceInfo.packageName;
        if (object != null && !((String)object).isEmpty()) {
            Object object2;
            object = SharedPreferencesManager.getDefaultInstance(this.getContext());
            long l = ((SharedPreferencesManager)object).getPreinstallPayloadReadStatus();
            if (PreinstallUtil.hasAllLocationsBeenRead(l)) {
                this.internalState.preinstallHasBeenRead = true;
                return;
            }
            if (PreinstallUtil.hasNotBeenRead("system_properties", l)) {
                object2 = PreinstallUtil.getPayloadFromSystemProperty(this.deviceInfo.packageName, this.logger);
                if (object2 != null && !((String)object2).isEmpty()) {
                    this.sdkClickHandler.sendPreinstallPayload((String)object2, "system_properties");
                } else {
                    l = PreinstallUtil.markAsRead("system_properties", l);
                }
            }
            if (PreinstallUtil.hasNotBeenRead("system_properties_reflection", l)) {
                object2 = PreinstallUtil.getPayloadFromSystemPropertyReflection(this.deviceInfo.packageName, this.logger);
                if (object2 != null && !((String)object2).isEmpty()) {
                    this.sdkClickHandler.sendPreinstallPayload((String)object2, "system_properties_reflection");
                } else {
                    l = PreinstallUtil.markAsRead("system_properties_reflection", l);
                }
            }
            if (PreinstallUtil.hasNotBeenRead("system_properties_path", l)) {
                object2 = PreinstallUtil.getPayloadFromSystemPropertyFilePath(this.deviceInfo.packageName, this.logger);
                if (object2 != null && !((String)object2).isEmpty()) {
                    this.sdkClickHandler.sendPreinstallPayload((String)object2, "system_properties_path");
                } else {
                    l = PreinstallUtil.markAsRead("system_properties_path", l);
                }
            }
            if (PreinstallUtil.hasNotBeenRead("system_properties_path_reflection", l)) {
                object2 = PreinstallUtil.getPayloadFromSystemPropertyFilePathReflection(this.deviceInfo.packageName, this.logger);
                if (object2 != null && !((String)object2).isEmpty()) {
                    this.sdkClickHandler.sendPreinstallPayload((String)object2, "system_properties_path_reflection");
                } else {
                    l = PreinstallUtil.markAsRead("system_properties_path_reflection", l);
                }
            }
            if (PreinstallUtil.hasNotBeenRead("content_provider", l)) {
                object2 = PreinstallUtil.getPayloadFromContentProviderDefault(this.adjustConfig.context, this.deviceInfo.packageName, this.logger);
                if (object2 != null && !((String)object2).isEmpty()) {
                    this.sdkClickHandler.sendPreinstallPayload((String)object2, "content_provider");
                } else {
                    l = PreinstallUtil.markAsRead("content_provider", l);
                }
            }
            if (PreinstallUtil.hasNotBeenRead("content_provider_intent_action", l)) {
                object2 = PreinstallUtil.getPayloadsFromContentProviderIntentAction(this.adjustConfig.context, this.deviceInfo.packageName, this.logger);
                if (object2 != null && !object2.isEmpty()) {
                    object2 = object2.iterator();
                    while (object2.hasNext()) {
                        this.sdkClickHandler.sendPreinstallPayload((String)object2.next(), "content_provider_intent_action");
                    }
                } else {
                    l = PreinstallUtil.markAsRead("content_provider_intent_action", l);
                }
            }
            if (PreinstallUtil.hasNotBeenRead("content_provider_no_permission", l)) {
                object2 = PreinstallUtil.getPayloadsFromContentProviderNoPermission(this.adjustConfig.context, this.deviceInfo.packageName, this.logger);
                if (object2 != null && !object2.isEmpty()) {
                    object2 = object2.iterator();
                    while (object2.hasNext()) {
                        this.sdkClickHandler.sendPreinstallPayload((String)object2.next(), "content_provider_no_permission");
                    }
                } else {
                    l = PreinstallUtil.markAsRead("content_provider_no_permission", l);
                }
            }
            if (PreinstallUtil.hasNotBeenRead("file_system", l)) {
                object2 = PreinstallUtil.getPayloadFromFileSystem(this.deviceInfo.packageName, this.adjustConfig.preinstallFilePath, this.logger);
                if (object2 != null && !((String)object2).isEmpty()) {
                    this.sdkClickHandler.sendPreinstallPayload((String)object2, "file_system");
                } else {
                    l = PreinstallUtil.markAsRead("file_system", l);
                }
            }
            ((SharedPreferencesManager)object).setPreinstallPayloadReadStatus(l);
            this.internalState.preinstallHasBeenRead = true;
            return;
        }
        this.logger.debug("Can't read preinstall payload, invalid package name", new Object[0]);
    }

    private void readConfigFile(Context object) {
        Properties properties;
        try {
            object = object.getAssets().open("adjust_config.properties");
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string;
            ((ActivityHandler)((Object)string)).logger.debug("%s file not found in this app", objectArray2);
            return;
        }
        Properties properties2 = properties;
        properties2();
        properties2.load((InputStream)object);
        ((ActivityHandler)((Object)string)).logger.verbose("adjust_config.properties file read and loaded", new Object[0]);
        object = properties.getProperty("defaultTracker");
        if (object != null) {
            ((ActivityHandler)((Object)string)).adjustConfig.defaultTracker = object;
            return;
        }
    }

    private void preLaunchActionsI(List<IRunActivityHandler> object) {
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                ((IRunActivityHandler)object.next()).run(this);
            }
        }
    }

    private void startI() {
        if (this.activityState == null) {
            ActivityHandler activityHandler = this;
            AdjustSigner.onResume(activityHandler.adjustConfig.logger);
            activityHandler.startFirstSessionI();
            return;
        }
        ActivityHandler activityHandler = this;
        activityHandler.processPreLaunchArraysI();
        if (!activityHandler.activityState.enabled) {
            return;
        }
        ActivityHandler activityHandler2 = this;
        AdjustSigner.onResume(activityHandler2.adjustConfig.logger);
        activityHandler2.updateHandlersStatusAndSendI();
        activityHandler2.processCoppaComplianceI();
        activityHandler2.processSessionI();
        activityHandler2.checkAttributionStateI();
        activityHandler2.processCachedDeeplinkI();
    }

    private void startFirstSessionI() {
        ActivityState activityState;
        ActivityState activityState2;
        ActivityHandler activityHandler = this;
        ActivityState activityState3 = activityState2 = activityState;
        activityState3();
        this.activityState = activityState3;
        activityState.setEventDeduplicationIdsMaxSize(this.adjustConfig.getEventDeduplicationIdsMaxSize());
        activityHandler.updateHandlersStatusAndSendI();
        long l = System.currentTimeMillis();
        SharedPreferencesManager sharedPreferencesManager = SharedPreferencesManager.getDefaultInstance(activityHandler.getContext());
        activityHandler.activityState.pushToken = sharedPreferencesManager.getPushToken();
        if (activityHandler.internalState.isEnabled()) {
            if (sharedPreferencesManager.getGdprForgetMe()) {
                this.gdprForgetMeI();
            } else {
                ActivityHandler activityHandler2 = this;
                activityHandler2.processCoppaComplianceI();
                activityHandler2.processPreLaunchArraysI();
                activityHandler2.activityState.sessionCount = 1;
                this.transferSessionPackageI(l);
                this.checkAfterNewStartI(sharedPreferencesManager);
            }
        }
        SharedPreferencesManager sharedPreferencesManager2 = sharedPreferencesManager;
        ActivityHandler activityHandler3 = this;
        activityHandler3.activityState.resetSessionAttributes(l);
        activityHandler3.activityState.enabled = this.internalState.isEnabled();
        activityHandler3.writeActivityStateI();
        sharedPreferencesManager2.removePushToken();
        sharedPreferencesManager2.removeGdprForgetMe();
        this.processCachedDeeplinkI();
    }

    private void processSessionI() {
        if (((ActivityHandler)((Object)n2)).activityState.isGdprForgotten) {
            return;
        }
        long l = System.currentTimeMillis();
        ActivityState activityState = ((ActivityHandler)((Object)n2)).activityState;
        long l2 = l - activityState.lastActivity;
        if (l2 < 0L) {
            ActivityHandler activityHandler = n2;
            activityHandler.logger.error(TIME_TRAVEL, new Object[0]);
            activityHandler.activityState.lastActivity = l;
            activityHandler.writeActivityStateI();
            return;
        }
        if (l2 > SESSION_INTERVAL) {
            ActivityHandler activityHandler = n2;
            activityHandler.trackNewSessionI(l);
            activityHandler.checkAfterNewStartI();
            return;
        }
        if (l2 > SUBSESSION_INTERVAL) {
            int n;
            ActivityHandler activityHandler = n2;
            ActivityState activityState2 = activityState;
            activityState2.subsessionCount = n = activityState2.subsessionCount + 1;
            activityState2.sessionLength += l2;
            activityState.lastActivity = l;
            ActivityHandler activityHandler2 = n2;
            Integer n2 = n;
            Integer n3 = activityHandler2.activityState.sessionCount;
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = n2;
            objectArray[1] = n3;
            activityHandler.logger.verbose("Started subsession %d of session %d", objectArray2);
            activityHandler.writeActivityStateI();
            activityHandler.checkForPreinstallI();
            activityHandler.installReferrer.startConnection();
            activityHandler.readInstallReferrerMeta();
            activityHandler.readInstallReferrerHuaweiAds();
            activityHandler.readInstallReferrerHuaweiAppGallery();
            activityHandler.readInstallReferrerSamsung();
            activityHandler.readInstallReferrerXiaomi();
            activityHandler.readInstallReferrerVivo();
            activityHandler.readLicenseVerificationData();
            return;
        }
        ((ActivityHandler)((Object)n2)).logger.verbose("Time span since last activity too short for a new subsession", new Object[0]);
    }

    private void readInstallReferrerMeta() {
        this.executor.submit(new Runnable(){

            @Override
            public final void run() {
                ReferrerDetails referrerDetails = Reflection.getMetaReferrer(ActivityHandler.this.getContext(), ((ActivityHandler)ActivityHandler.this).adjustConfig.fbAppId, ActivityHandler.this.logger);
                if (referrerDetails != null) {
                    ActivityHandler.this.sendInstallReferrer(referrerDetails, "meta");
                    return;
                }
            }
        });
    }

    private void readLicenseVerificationData() {
        this.executor.submit(new Runnable(){

            @Override
            public final void run() {
                LicenseData licenseData;
                if (!SharedPreferencesManager.getDefaultInstance(ActivityHandler.this.getContext()).getLicenseVerificationTracked() && (licenseData = Reflection.getLicenseRequiredData(ActivityHandler.this.getContext(), ActivityHandler.this.logger, ((ActivityHandler)ActivityHandler.this).deviceInfo.appInstallTime)) != null) {
                    ActivityHandler.this.sendLicenseVerificationData(licenseData);
                    return;
                }
            }
        });
    }

    private void readInstallReferrerHuaweiAds() {
        this.executor.submit(new Runnable(){

            @Override
            public final void run() {
                ReferrerDetails referrerDetails = Reflection.getHuaweiAdsReferrer(ActivityHandler.this.getContext(), ActivityHandler.this.logger);
                if (referrerDetails != null) {
                    ActivityHandler.this.sendInstallReferrer(referrerDetails, "huawei_ads");
                    return;
                }
            }
        });
    }

    private void readInstallReferrerHuaweiAppGallery() {
        this.executor.submit(new Runnable(){

            @Override
            public final void run() {
                ReferrerDetails referrerDetails = Reflection.getHuaweiAppGalleryReferrer(ActivityHandler.this.getContext(), ActivityHandler.this.logger);
                if (referrerDetails != null) {
                    ActivityHandler.this.sendInstallReferrer(referrerDetails, "huawei_app_gallery");
                    return;
                }
            }
        });
    }

    private void readInstallReferrerSamsung() {
        this.executor.submit(new Runnable(){

            @Override
            public final void run() {
                ReferrerDetails referrerDetails = Reflection.getSamsungReferrer(ActivityHandler.this.getContext(), ActivityHandler.this.logger);
                if (referrerDetails != null) {
                    ActivityHandler.this.sendInstallReferrer(referrerDetails, "samsung");
                    return;
                }
            }
        });
    }

    private void readInstallReferrerXiaomi() {
        this.executor.submit(new Runnable(){

            @Override
            public final void run() {
                ReferrerDetails referrerDetails = Reflection.getXiaomiReferrer(ActivityHandler.this.getContext(), ActivityHandler.this.logger);
                if (referrerDetails != null) {
                    ActivityHandler.this.sendInstallReferrer(referrerDetails, "xiaomi");
                    return;
                }
            }
        });
    }

    private void readInstallReferrerVivo() {
        this.executor.submit(new Runnable(){

            @Override
            public final void run() {
                ReferrerDetails referrerDetails = Reflection.getVivoReferrer(ActivityHandler.this.getContext(), ActivityHandler.this.logger);
                if (referrerDetails != null) {
                    ActivityHandler.this.sendInstallReferrer(referrerDetails, "vivo");
                    return;
                }
            }
        });
    }

    private void trackNewSessionI(long l) {
        ActivityHandler activityHandler = activityState;
        ActivityState activityState = ((ActivityHandler)((Object)activityState)).activityState;
        long l2 = l - activityState.lastActivity;
        ++activityState.sessionCount;
        activityState.lastInterval = l2;
        activityHandler.transferSessionPackageI(l);
        activityHandler.activityState.resetSessionAttributes(l);
        activityHandler.writeActivityStateI();
    }

    private void checkAttributionStateI() {
        ActivityHandler activityHandler = this;
        if (!activityHandler.checkActivityStateI(activityHandler.activityState) || this.internalState.isFirstLaunch() && this.internalState.hasSessionResponseNotBeenProcessed() || this.attribution != null && !this.activityState.askingAttribution) {
            return;
        }
        this.attributionHandler.getAttribution();
    }

    private void processCachedDeeplinkI() {
        AdjustDeeplink adjustDeeplink;
        long l;
        String string;
        String string2;
        SharedPreferencesManager sharedPreferencesManager;
        block5: {
            block4: {
                ActivityHandler activityHandler = this;
                if (!activityHandler.checkActivityStateI(activityHandler.activityState)) break block4;
                sharedPreferencesManager = SharedPreferencesManager.getDefaultInstance(this.getContext());
                string2 = sharedPreferencesManager.getDeeplinkUrl();
                SharedPreferencesManager sharedPreferencesManager2 = sharedPreferencesManager;
                string = sharedPreferencesManager2.getDeeplinkReferrer();
                l = sharedPreferencesManager2.getDeeplinkClickTime();
                if (string2 != null && l != -1L) break block5;
            }
            return;
        }
        AdjustDeeplink adjustDeeplink2 = adjustDeeplink;
        adjustDeeplink = new AdjustDeeplink(Uri.parse((String)string2));
        if (string != null) {
            adjustDeeplink2.setReferrer(Uri.parse((String)string));
        }
        this.processDeeplink(adjustDeeplink2, l);
        sharedPreferencesManager.removeDeeplink();
    }

    private void endI() {
        if (!this.toSendI()) {
            this.pauseSendingI();
        }
        if (this.updateActivityStateI(System.currentTimeMillis())) {
            this.writeActivityStateI();
            return;
        }
    }

    private void trackEventI(AdjustEvent object) {
        PackageBuilder packageBuilder;
        ActivityHandler activityHandler = this;
        if (!(activityHandler.checkActivityStateI(activityHandler.activityState) && this.isEnabledI() && this.checkEventI((AdjustEvent)object) && !this.activityState.isGdprForgotten && this.shouldProcessEventI(((AdjustEvent)object).deduplicationId))) {
            return;
        }
        ActivityHandler activityHandler2 = this;
        long l = System.currentTimeMillis();
        Object object2 = activityHandler2.activityState;
        ++((ActivityState)object2).eventCount;
        activityHandler2.updateActivityStateI(l);
        object2 = packageBuilder;
        AdjustEvent adjustEvent = object;
        Object object3 = object2;
        Object object4 = object2;
        ActivityHandler activityHandler3 = this;
        object = activityHandler3.adjustConfig;
        object2 = activityHandler3.deviceInfo;
        ActivityState activityState = activityHandler3.activityState;
        GlobalParameters globalParameters = activityHandler3.globalParameters;
        FirstSessionDelayManager firstSessionDelayManager = activityHandler3.firstSessionDelayManager;
        ((PackageBuilder)object4)((AdjustConfig)object, (DeviceInfo)object2, activityState, globalParameters, firstSessionDelayManager, l);
        ((PackageBuilder)object3).internalState = this.internalState;
        object = packageBuilder.buildEventPackage(adjustEvent);
        activityHandler2.packageHandler.addPackage((ActivityPackage)object);
        activityHandler2.packageHandler.sendFirstPackage();
        if (activityHandler2.adjustConfig.isSendingInBackgroundEnabled && this.internalState.isInBackground()) {
            this.startBackgroundTimerI();
        }
        this.writeActivityStateI();
    }

    private void launchEventResponseTasksI(final EventResponseData eventResponseData) {
        Handler handler;
        this.updateAdidI(eventResponseData.adid);
        Handler handler2 = handler;
        handler = new Handler(this.adjustConfig.context.getMainLooper());
        boolean bl = eventResponseData.success;
        if (bl && this.adjustConfig.onEventTrackingSucceededListener != null) {
            this.logger.debug("Launching success event tracking listener", new Object[0]);
            handler2.post(new Runnable(){

                @Override
                public final void run() {
                    if (ActivityHandler.this.adjustConfig == null || ((ActivityHandler)ActivityHandler.this).adjustConfig.onEventTrackingSucceededListener == null) {
                        return;
                    }
                    ((ActivityHandler)ActivityHandler.this).adjustConfig.onEventTrackingSucceededListener.onEventTrackingSucceeded(eventResponseData.getSuccessResponseData());
                }
            });
            return;
        }
        if (!bl && this.adjustConfig.onEventTrackingFailedListener != null) {
            this.logger.debug("Launching failed event tracking listener", new Object[0]);
            handler2.post(new Runnable(){

                @Override
                public final void run() {
                    if (ActivityHandler.this.adjustConfig == null || ((ActivityHandler)ActivityHandler.this).adjustConfig.onEventTrackingFailedListener == null) {
                        return;
                    }
                    ((ActivityHandler)ActivityHandler.this).adjustConfig.onEventTrackingFailedListener.onEventTrackingFailed(eventResponseData.getFailureResponseData());
                }
            });
            return;
        }
    }

    private void launchSdkClickResponseTasksI(final SdkClickResponseData sdkClickResponseData) {
        Handler handler;
        ((ActivityHandler)((Object)runnable2)).updateAdidI(sdkClickResponseData.adid);
        Handler handler2 = handler;
        handler = new Handler(((ActivityHandler)((Object)runnable2)).adjustConfig.context.getMainLooper());
        if (((ActivityHandler)((Object)runnable2)).updateAttributionI(sdkClickResponseData.attribution)) {
            ((ActivityHandler)((Object)runnable2)).launchAttributionListenerI(handler2);
        }
        if (!TextUtils.isEmpty((CharSequence)sdkClickResponseData.resolvedDeeplink)) {
            final OnDeeplinkResolvedListener onDeeplinkResolvedListener = ((ActivityHandler)((Object)runnable2)).cachedDeeplinkResolutionCallback;
            ((ActivityHandler)((Object)runnable2)).cachedDeeplinkResolutionCallback = null;
            if (onDeeplinkResolvedListener != null) {
                Runnable runnable;
                Runnable runnable2 = runnable;
                runnable = new Runnable(){

                    @Override
                    public final void run() {
                        onDeeplinkResolvedListener.onDeeplinkResolved(sdkClickResponseData.resolvedDeeplink);
                    }
                };
                handler2.post(runnable2);
                return;
            }
        }
    }

    private void launchSessionResponseTasksI(SessionResponseData sessionResponseData) {
        Handler handler;
        this.logger.debug("Launching SessionResponse tasks", new Object[0]);
        this.updateAdidI(sessionResponseData.adid);
        Handler handler2 = handler;
        handler = new Handler(this.adjustConfig.context.getMainLooper());
        if (this.updateAttributionI(sessionResponseData.attribution)) {
            this.launchAttributionListenerI(handler2);
        }
        if (this.attribution == null && !this.activityState.askingAttribution) {
            this.attributionHandler.getAttribution();
        }
        if (sessionResponseData.success) {
            SharedPreferencesManager.getDefaultInstance(this.getContext()).setInstallTracked();
        }
        this.launchSessionResponseListenerI(sessionResponseData, handler2);
        this.prepareDeeplinkI(sessionResponseData.deeplink, handler2);
        this.internalState.sessionResponseProcessed = true;
    }

    private void launchSessionResponseListenerI(final SessionResponseData sessionResponseData, Handler handler) {
        boolean bl = sessionResponseData.success;
        if (bl && this.adjustConfig.onSessionTrackingSucceededListener != null) {
            this.logger.debug("Launching success session tracking listener", new Object[0]);
            handler.post(new Runnable(){

                @Override
                public final void run() {
                    if (ActivityHandler.this.adjustConfig == null || ((ActivityHandler)ActivityHandler.this).adjustConfig.onSessionTrackingSucceededListener == null) {
                        return;
                    }
                    ((ActivityHandler)ActivityHandler.this).adjustConfig.onSessionTrackingSucceededListener.onSessionTrackingSucceeded(sessionResponseData.getSuccessResponseData());
                }
            });
            return;
        }
        if (!bl && this.adjustConfig.onSessionTrackingFailedListener != null) {
            this.logger.debug("Launching failed session tracking listener", new Object[0]);
            handler.post(new Runnable(){

                @Override
                public final void run() {
                    if (ActivityHandler.this.adjustConfig == null || ((ActivityHandler)ActivityHandler.this).adjustConfig.onSessionTrackingFailedListener == null) {
                        return;
                    }
                    ((ActivityHandler)ActivityHandler.this).adjustConfig.onSessionTrackingFailedListener.onSessionTrackingFailed(sessionResponseData.getFailureResponseData());
                }
            });
            return;
        }
    }

    private void launchAttributionResponseTasksI(AttributionResponseData attributionResponseData) {
        Handler handler;
        this.updateAdidI(attributionResponseData.adid);
        Handler handler2 = handler;
        handler = new Handler(this.adjustConfig.context.getMainLooper());
        if (this.updateAttributionI(attributionResponseData.attribution)) {
            this.launchAttributionListenerI(handler2);
        }
        this.prepareDeeplinkI(attributionResponseData.deeplink, handler2);
    }

    private void launchAttributionListenerI(Handler object) {
        Runnable runnable;
        if (this.adjustConfig.onAttributionChangedListener == null) {
            return;
        }
        Handler handler = object;
        object = runnable;
        runnable = new Runnable(){

            @Override
            public final void run() {
                if (ActivityHandler.this.adjustConfig == null || ((ActivityHandler)ActivityHandler.this).adjustConfig.onAttributionChangedListener == null) {
                    return;
                }
                ((ActivityHandler)ActivityHandler.this).adjustConfig.onAttributionChangedListener.onAttributionChanged(ActivityHandler.this.attribution);
            }
        };
        handler.post((Runnable)object);
    }

    private void launchPurchaseVerificationResponseTasksI(PurchaseVerificationResponseData object) {
        Runnable runnable;
        Handler handler;
        Object object2 = handler;
        handler = new Handler(this.adjustConfig.context.getMainLooper());
        Object object3 = ((ResponseData)object).jsonResponse;
        if (object3 == null) {
            AdjustPurchaseVerificationResult adjustPurchaseVerificationResult;
            object3 = adjustPurchaseVerificationResult;
            String string = ((ResponseData)object).message;
            adjustPurchaseVerificationResult = new AdjustPurchaseVerificationResult("not_verified", 101, string);
        } else {
            AdjustPurchaseVerificationResult adjustPurchaseVerificationResult;
            AdjustPurchaseVerificationResult adjustPurchaseVerificationResult2 = adjustPurchaseVerificationResult;
            Object object4 = object3;
            object3 = UtilNetworking.extractJsonString(object4, "verification_status");
            int n = UtilNetworking.extractJsonInt(object4, "code");
            String string = UtilNetworking.extractJsonString(object4, "message");
            adjustPurchaseVerificationResult = new AdjustPurchaseVerificationResult((String)object3, n, string);
            object3 = adjustPurchaseVerificationResult2;
        }
        Handler handler2 = object2;
        object2 = runnable;
        runnable = new Runnable((PurchaseVerificationResponseData)object, (AdjustPurchaseVerificationResult)object3){
            public final /* synthetic */ PurchaseVerificationResponseData a;
            public final /* synthetic */ AdjustPurchaseVerificationResult b;
            {
                this.a = purchaseVerificationResponseData;
                this.b = adjustPurchaseVerificationResult;
            }

            @Override
            public final void run() {
                this.a.activityPackage.getPurchaseVerificationCallback().onVerificationFinished(this.b);
            }
        };
        handler2.post((Runnable)object2);
        object = ((ResponseData)object).activityPackage;
        if (object != null && (object = ((ActivityPackage)object).event) != null) {
            this.trackEventI((AdjustEvent)object);
            return;
        }
    }

    private void prepareDeeplinkI(final Uri uri, Handler intent) {
        if (uri == null) {
            return;
        }
        Intent intent2 = intent;
        Intent intent3 = new Object[1];
        intent = intent3;
        intent3[0] = uri;
        this.logger.info("Deferred deeplink received (%s)", (Object[])intent);
        intent = this.createDeeplinkIntentI(uri);
        intent2.post(new Runnable(intent){
            public final /* synthetic */ Intent b;
            {
                this.b = intent;
            }

            @Override
            public final void run() {
                if (this_.ActivityHandler.this.adjustConfig != null) {
                    boolean bl = true;
                    if (((ActivityHandler)this_.ActivityHandler.this).adjustConfig.onDeferredDeeplinkResponseListener != null) {
                        bl = ((ActivityHandler)this_.ActivityHandler.this).adjustConfig.onDeferredDeeplinkResponseListener.launchReceivedDeeplink(this_.uri);
                    }
                    if (bl) {
                        36 v0 = this_;
                        36 this_ = v0.b;
                        this_.ActivityHandler.this.launchDeeplinkMain((Intent)this_, v0.uri);
                        return;
                    }
                }
            }
        });
    }

    private Intent createDeeplinkIntentI(Uri uri) {
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        intent.setFlags(0x10000000);
        intent.setPackage(this.adjustConfig.context.getPackageName());
        return intent;
    }

    private void launchDeeplinkMain(Intent intent, Uri uri) {
        Object[] objectArray;
        if (objectArray.adjustConfig.context.getPackageManager().queryIntentActivities(intent, 0).size() > 0) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = uri;
            objectArray.logger.info("Open deferred deeplink (%s)", objectArray);
            objectArray.adjustConfig.context.startActivity(intent);
            return;
        }
        Object[] objectArray3 = new Object[1];
        objectArray = objectArray3;
        objectArray3[0] = uri;
        objectArray.logger.error("Unable to open deferred deeplink (%s)", objectArray);
    }

    private void setEnabledI(boolean bl) {
        Object object;
        ActivityHandler activityHandler = this;
        if (!activityHandler.hasChangedStateI(activityHandler.isEnabledI(), bl, "Adjust already enabled", "Adjust already disabled")) {
            return;
        }
        if (bl && (object = this.activityState) != null && ((ActivityState)object).isGdprForgotten) {
            this.logger.error("Re-enabling SDK not possible for forgotten user", new Object[0]);
            return;
        }
        this.internalState.enabled = bl;
        object = this.activityState;
        if (object == null) {
            this.updateStatusI(bl ^ true, "Handlers will start as paused due to the SDK being disabled", "Handlers will still start as paused", "Handlers will start as active due to the SDK being enabled");
            return;
        }
        ((ActivityState)object).enabled = bl;
        this.writeActivityStateI();
        if (bl) {
            object = SharedPreferencesManager.getDefaultInstance(this.getContext());
            if (((SharedPreferencesManager)object).getGdprForgetMe()) {
                this.gdprForgetMeI();
            } else {
                ActivityHandler activityHandler2 = this;
                activityHandler2.processCoppaComplianceI();
                activityHandler2.processPreLaunchArraysI();
            }
            if (!((SharedPreferencesManager)object).getInstallTracked()) {
                ActivityHandler activityHandler3 = this;
                activityHandler3.logger.debug("Detected that install was not tracked at enable time", new Object[0]);
                activityHandler3.trackNewSessionI(System.currentTimeMillis());
            }
            this.checkAfterNewStartI((SharedPreferencesManager)object);
        }
        this.updateStatusI(bl ^ true, "Pausing handlers due to SDK being disabled", "Handlers remain paused", "Resuming handlers due to SDK being enabled");
    }

    private void processPreLaunchArraysI() {
        if (this.cachedAdjustThirdPartySharingArray != null && this.canTrackThirdPartySharingI()) {
            Iterator<AdjustThirdPartySharing> iterator = this.cachedAdjustThirdPartySharingArray.iterator();
            while (iterator.hasNext()) {
                this.trackThirdPartySharingI(iterator.next());
            }
        }
        this.cachedAdjustThirdPartySharingArray = null;
        if (this.cachedLastMeasurementConsentTrack != null && this.canTrackMeasurementConsentI()) {
            ActivityHandler activityHandler = this;
            activityHandler.trackMeasurementConsentI(activityHandler.cachedLastMeasurementConsentTrack);
        }
        this.cachedLastMeasurementConsentTrack = null;
    }

    private void checkAfterNewStartI() {
        ActivityHandler activityHandler = this;
        activityHandler.checkAfterNewStartI(SharedPreferencesManager.getDefaultInstance(activityHandler.getContext()));
    }

    private void checkAfterNewStartI(SharedPreferencesManager sharedPreferencesManager) {
        String string = sharedPreferencesManager.getPushToken();
        if (string != null && !string.equals(this.activityState.pushToken)) {
            this.setPushToken(string, true);
        }
        if (sharedPreferencesManager.getRawReferrerArray() != null) {
            this.sendReftagReferrer();
        }
        ActivityHandler activityHandler = this;
        activityHandler.checkForPreinstallI();
        activityHandler.installReferrer.startConnection();
        activityHandler.readInstallReferrerMeta();
        activityHandler.readInstallReferrerHuaweiAds();
        activityHandler.readInstallReferrerHuaweiAppGallery();
        activityHandler.readInstallReferrerSamsung();
        activityHandler.readInstallReferrerXiaomi();
        activityHandler.readInstallReferrerVivo();
        activityHandler.readLicenseVerificationData();
    }

    private void setOfflineModeI(boolean bl) {
        ActivityHandler activityHandler = this;
        if (!activityHandler.hasChangedStateI(activityHandler.internalState.isOffline(), bl, "Adjust already in offline mode", "Adjust already in online mode")) {
            return;
        }
        this.internalState.offline = bl;
        if (this.activityState == null) {
            this.updateStatusI(bl, "Handlers will start paused due to SDK being offline", "Handlers will still start as paused", "Handlers will start as active due to SDK being online");
            return;
        }
        this.updateStatusI(bl, "Pausing handlers to put SDK offline mode", "Handlers remain paused", "Resuming handlers to put SDK in online mode");
    }

    private boolean hasChangedStateI(boolean bl, boolean bl2, String string, String string2) {
        if (bl != bl2) {
            return true;
        }
        if (bl) {
            this.logger.debug(string, new Object[0]);
        } else {
            this.logger.debug(string2, new Object[0]);
        }
        return false;
    }

    private void updateStatusI(boolean bl, String string, String string2, String string3) {
        if (bl) {
            this.logger.info(string, new Object[0]);
        } else if (this.pausedI(false)) {
            if (this.pausedI(true)) {
                this.logger.info(string2, new Object[0]);
            } else {
                this.logger.info(string2 + ", except the Sdk Click Handler", new Object[0]);
            }
        } else {
            this.logger.info(string3, new Object[0]);
        }
        this.updateHandlersStatusAndSendI();
    }

    private void setAskingAttributionI(boolean bl) {
        this.activityState.askingAttribution = bl;
        this.writeActivityStateI();
    }

    private void sendReftagReferrerI() {
        if (!this.isEnabledI() || this.activityState == null) {
            return;
        }
        this.sdkClickHandler.sendReftagReferrers();
    }

    private void sendPreinstallReferrerI() {
        String string;
        if (this.isEnabledI() && this.activityState != null && (string = SharedPreferencesManager.getDefaultInstance(this.getContext()).getPreinstallReferrer()) != null && !string.isEmpty()) {
            this.sdkClickHandler.sendPreinstallPayload(string, "system_installer_referrer");
            return;
        }
    }

    private void sendInstallReferrerI(ReferrerDetails object, String object2) {
        if (!((ActivityHandler)object3).isEnabledI() || !((ActivityHandler)object3).isValidReferrerDetails((ReferrerDetails)object) || Util.isEqualReferrerDetails((ReferrerDetails)object, (String)object2, ((ActivityHandler)object3).activityState)) {
            return;
        }
        ActivityHandler activityHandler = object3;
        ReferrerDetails referrerDetails = object;
        String string = object2;
        ActivityHandler activityHandler2 = object3;
        Object object3 = activityHandler2.activityState;
        object = activityHandler2.adjustConfig;
        object2 = activityHandler2.deviceInfo;
        GlobalParameters globalParameters = activityHandler2.globalParameters;
        FirstSessionDelayManager firstSessionDelayManager = activityHandler2.firstSessionDelayManager;
        InternalState internalState = activityHandler2.internalState;
        object3 = PackageFactory.buildInstallReferrerSdkClickPackage(referrerDetails, string, (ActivityState)object3, (AdjustConfig)object, (DeviceInfo)object2, globalParameters, firstSessionDelayManager, internalState);
        activityHandler.sdkClickHandler.sendSdkClick((ActivityPackage)object3);
    }

    private void sendLicenseVerificationDataI(LicenseData object) {
        if (((ActivityHandler)object2).isEnabledI() && object != null && ((LicenseData)object).isValid()) {
            ActivityHandler activityHandler = object2;
            LicenseData licenseData = object;
            ActivityHandler activityHandler2 = object2;
            Object object2 = activityHandler2.activityState;
            object = activityHandler2.adjustConfig;
            DeviceInfo deviceInfo = activityHandler2.deviceInfo;
            GlobalParameters globalParameters = activityHandler2.globalParameters;
            FirstSessionDelayManager firstSessionDelayManager = activityHandler2.firstSessionDelayManager;
            InternalState internalState = activityHandler2.internalState;
            object2 = PackageFactory.buildLicenseVerificationSdkClickPackage(licenseData, (ActivityState)object2, (AdjustConfig)object, deviceInfo, globalParameters, firstSessionDelayManager, internalState);
            activityHandler.sdkClickHandler.sendSdkClick((ActivityPackage)object2);
            return;
        }
    }

    private boolean isValidReferrerDetails(ReferrerDetails referrerDetails) {
        if (referrerDetails == null) {
            return false;
        }
        String string = referrerDetails.installReferrer;
        if (string == null) {
            return false;
        }
        return string.length() != 0;
    }

    private void processDeeplinkI(AdjustDeeplink object, long l) {
        block9: {
            block7: {
                Object object2;
                Object object3;
                Object object4;
                block8: {
                    if (!this.isEnabledI() || object == null) break block7;
                    if (!Util.isUrlFilteredOut(((AdjustDeeplink)object).getUrl())) break block8;
                    if (((AdjustDeeplink)object).getUrl() != null) {
                        this.logger.debug("Deeplink (" + ((AdjustDeeplink)object).getUrl().toString() + ") processing skipped", new Object[0]);
                        return;
                    }
                    break block7;
                }
                if (Util.isUrlWithTrackerQueryParam(((AdjustDeeplink)object).getUrl())) {
                    Handler handler;
                    object4 = ((AdjustDeeplink)object).getUrl().toString();
                    object3 = handler;
                    handler = new Handler(this.adjustConfig.context.getMainLooper());
                    object2 = this.cachedDeeplinkResolutionCallback;
                    this.cachedDeeplinkResolutionCallback = null;
                    if (object2 != null) {
                        Runnable runnable;
                        Object object5 = object3;
                        object3 = runnable;
                        runnable = new Runnable((OnDeeplinkResolvedListener)object2, (String)object4){
                            public final /* synthetic */ OnDeeplinkResolvedListener a;
                            public final /* synthetic */ String b;
                            {
                                this.a = onDeeplinkResolvedListener;
                                this.b = string;
                            }

                            @Override
                            public final void run() {
                                this.a.onDeeplinkResolved(this.b);
                            }
                        };
                        object5.post((Runnable)object3);
                    }
                }
                Uri uri = ((AdjustDeeplink)object).getUrl();
                ActivityHandler activityHandler = this;
                object = ((AdjustDeeplink)object).getReferrer();
                object4 = activityHandler.activityState;
                object3 = activityHandler.adjustConfig;
                object2 = activityHandler.deviceInfo;
                GlobalParameters globalParameters = activityHandler.globalParameters;
                FirstSessionDelayManager firstSessionDelayManager = activityHandler.firstSessionDelayManager;
                InternalState internalState = activityHandler.internalState;
                if ((object = PackageFactory.buildDeeplinkSdkClickPackage(uri, (Uri)object, l, (ActivityState)object4, (AdjustConfig)object3, (DeviceInfo)object2, globalParameters, firstSessionDelayManager, internalState)) != null) break block9;
            }
            return;
        }
        this.sdkClickHandler.sendSdkClick((ActivityPackage)object);
    }

    private void updateHandlersStatusAndSendI() {
        if (!this.toSendI()) {
            this.pauseSendingI();
            return;
        }
        ActivityHandler activityHandler = this;
        activityHandler.resumeSendingI();
        activityHandler.packageHandler.sendFirstPackage();
    }

    private void pauseSendingI() {
        ActivityHandler activityHandler = this;
        activityHandler.attributionHandler.pauseSending();
        activityHandler.packageHandler.pauseSending();
        if (!activityHandler.toSendI(true)) {
            ActivityHandler activityHandler2 = this;
            activityHandler2.sdkClickHandler.pauseSending();
            activityHandler2.purchaseVerificationHandler.pauseSending();
            return;
        }
        ActivityHandler activityHandler3 = this;
        activityHandler3.sdkClickHandler.resumeSending();
        activityHandler3.purchaseVerificationHandler.resumeSending();
    }

    private void resumeSendingI() {
        ActivityHandler activityHandler = this;
        activityHandler.attributionHandler.resumeSending();
        activityHandler.packageHandler.resumeSending();
        activityHandler.sdkClickHandler.resumeSending();
        activityHandler.purchaseVerificationHandler.resumeSending();
    }

    private boolean updateActivityStateI(long l) {
        ActivityHandler activityHandler = this;
        if (!activityHandler.checkActivityStateI(activityHandler.activityState)) {
            return false;
        }
        ActivityState activityState = this.activityState;
        long l2 = l - activityState.lastActivity;
        if (l2 > SESSION_INTERVAL) {
            return false;
        }
        activityState.lastActivity = l;
        if (l2 < 0L) {
            this.logger.error(TIME_TRAVEL, new Object[0]);
        } else {
            ActivityState activityState2 = activityState;
            activityState2.sessionLength += l2;
            activityState2.timeSpent += l2;
        }
        return true;
    }

    public static boolean deleteActivityState(Context context) {
        return context.deleteFile("AdjustIoActivityState");
    }

    public static boolean deleteAttribution(Context context) {
        return context.deleteFile("AdjustAttribution");
    }

    public static boolean deleteGlobalCallbackParameters(Context context) {
        return context.deleteFile("AdjustGlobalCallbackParameters");
    }

    public static boolean deleteGlobalPartnerParameters(Context context) {
        return context.deleteFile("AdjustGlobalPartnerParameters");
    }

    private void transferSessionPackageI(long l) {
        ActivityHandler activityHandler = object;
        ActivityHandler activityHandler2 = object;
        Object object = activityHandler2.adjustConfig;
        DeviceInfo deviceInfo = activityHandler2.deviceInfo;
        ActivityState activityState = activityHandler2.activityState;
        GlobalParameters globalParameters = activityHandler2.globalParameters;
        FirstSessionDelayManager firstSessionDelayManager = activityHandler2.firstSessionDelayManager;
        new PackageBuilder((AdjustConfig)object, deviceInfo, activityState, globalParameters, firstSessionDelayManager, l).internalState = ((ActivityHandler)object).internalState;
        object = new PackageBuilder((AdjustConfig)object, deviceInfo, activityState, globalParameters, firstSessionDelayManager, l).buildSessionPackage();
        activityHandler.packageHandler.addPackage((ActivityPackage)object);
        activityHandler.packageHandler.sendFirstPackage();
    }

    private void startForegroundTimerI() {
        if (!this.isEnabledI()) {
            return;
        }
        this.foregroundTimer.start();
    }

    private void stopForegroundTimerI() {
        this.foregroundTimer.suspend();
    }

    private void foregroundTimerFiredI() {
        if (!this.isEnabledI()) {
            this.stopForegroundTimerI();
            return;
        }
        if (this.toSendI()) {
            this.packageHandler.sendFirstPackage();
        }
        if (this.updateActivityStateI(System.currentTimeMillis())) {
            this.writeActivityStateI();
            return;
        }
    }

    private void startBackgroundTimerI() {
        if (this.backgroundTimer == null || !this.toSendI() || this.backgroundTimer.getFireIn() > 0L) {
            return;
        }
        this.backgroundTimer.startIn(BACKGROUND_TIMER_INTERVAL);
    }

    private void stopBackgroundTimerI() {
        TimerOnce timerOnce = ((ActivityHandler)((Object)timerOnce)).backgroundTimer;
        if (timerOnce == null) {
            return;
        }
        timerOnce.cancel();
    }

    private void backgroundTimerFiredI() {
        if (this.toSendI()) {
            this.packageHandler.sendFirstPackage();
            return;
        }
    }

    private void setPushTokenI(String object) {
        block3: {
            block2: {
                ActivityHandler activityHandler = object2;
                if (!activityHandler.checkActivityStateI(activityHandler.activityState) || !((ActivityHandler)object2).isEnabledI()) break block2;
                ActivityState activityState = ((ActivityHandler)object2).activityState;
                if (!activityState.isGdprForgotten && object != null && !((String)object).equals(activityState.pushToken)) break block3;
            }
            return;
        }
        ActivityHandler activityHandler = object2;
        activityHandler.activityState.pushToken = object;
        activityHandler.writeActivityStateI();
        long l = System.currentTimeMillis();
        ActivityHandler activityHandler2 = object2;
        Object object2 = activityHandler2.adjustConfig;
        object = activityHandler2.deviceInfo;
        ActivityState activityState = activityHandler2.activityState;
        GlobalParameters globalParameters = activityHandler2.globalParameters;
        FirstSessionDelayManager firstSessionDelayManager = activityHandler2.firstSessionDelayManager;
        new PackageBuilder((AdjustConfig)object2, (DeviceInfo)object, activityState, globalParameters, firstSessionDelayManager, l).internalState = ((ActivityHandler)object2).internalState;
        object2 = new PackageBuilder((AdjustConfig)object2, (DeviceInfo)object, activityState, globalParameters, firstSessionDelayManager, l).buildInfoPackage("push");
        activityHandler.packageHandler.addPackage((ActivityPackage)object2);
        SharedPreferencesManager.getDefaultInstance(activityHandler.getContext()).removePushToken();
        activityHandler.packageHandler.sendFirstPackage();
    }

    private void gdprForgetMeI() {
        block3: {
            block2: {
                ActivityHandler activityHandler = object;
                if (!activityHandler.checkActivityStateI(activityHandler.activityState) || !((ActivityHandler)object).isEnabledI()) break block2;
                ActivityState activityState = ((ActivityHandler)object).activityState;
                if (!activityState.isGdprForgotten) break block3;
            }
            return;
        }
        ActivityHandler activityHandler = object;
        activityState.isGdprForgotten = true;
        activityHandler.writeActivityStateI();
        long l = System.currentTimeMillis();
        ActivityHandler activityHandler2 = object;
        Object object = activityHandler2.adjustConfig;
        DeviceInfo deviceInfo = activityHandler2.deviceInfo;
        ActivityState activityState = activityHandler2.activityState;
        GlobalParameters globalParameters = activityHandler2.globalParameters;
        FirstSessionDelayManager firstSessionDelayManager = activityHandler2.firstSessionDelayManager;
        new PackageBuilder((AdjustConfig)object, deviceInfo, activityState, globalParameters, firstSessionDelayManager, l).internalState = ((ActivityHandler)object).internalState;
        object = new PackageBuilder((AdjustConfig)object, deviceInfo, activityState, globalParameters, firstSessionDelayManager, l).buildGdprPackage();
        activityHandler.packageHandler.addPackage((ActivityPackage)object);
        SharedPreferencesManager.getDefaultInstance(activityHandler.getContext()).removeGdprForgetMe();
        activityHandler.packageHandler.sendFirstPackage();
    }

    private boolean canTrackThirdPartySharingI() {
        ActivityHandler activityHandler = this;
        if (!activityHandler.checkActivityStateI(activityHandler.activityState)) {
            return false;
        }
        if (!this.isEnabledI()) {
            return false;
        }
        if (this.activityState.isGdprForgotten) {
            return false;
        }
        if (this.adjustConfig.coppaComplianceEnabled) {
            this.logger.warn("Calling third party sharing API not allowed when COPPA enabled", new Object[0]);
            return false;
        }
        return true;
    }

    private void trackThirdPartySharingI(AdjustThirdPartySharing object) {
        PackageBuilder packageBuilder;
        ActivityHandler activityHandler = object3;
        long l = System.currentTimeMillis();
        Object object2 = packageBuilder;
        AdjustThirdPartySharing adjustThirdPartySharing = object;
        PackageBuilder packageBuilder2 = object2;
        ActivityHandler activityHandler2 = object3;
        PackageBuilder packageBuilder3 = object2;
        ActivityHandler activityHandler3 = object3;
        Object object3 = activityHandler3.adjustConfig;
        object = activityHandler3.deviceInfo;
        object2 = activityHandler3.activityState;
        GlobalParameters globalParameters = activityHandler3.globalParameters;
        FirstSessionDelayManager firstSessionDelayManager = activityHandler3.firstSessionDelayManager;
        packageBuilder3((AdjustConfig)object3, (DeviceInfo)object, (ActivityState)object2, globalParameters, firstSessionDelayManager, l);
        packageBuilder2.internalState = activityHandler2.internalState;
        object3 = packageBuilder.buildThirdPartySharingPackage(adjustThirdPartySharing);
        activityHandler.packageHandler.addPackage((ActivityPackage)object3);
        activityHandler.packageHandler.sendFirstPackage();
    }

    private boolean canTrackMeasurementConsentI() {
        ActivityHandler activityHandler = this;
        if (!activityHandler.checkActivityStateI(activityHandler.activityState)) {
            return false;
        }
        if (!this.isEnabledI()) {
            return false;
        }
        return !this.activityState.isGdprForgotten;
    }

    private void trackMeasurementConsentI(boolean bl) {
        PackageBuilder packageBuilder;
        ActivityHandler activityHandler = object2;
        long l = System.currentTimeMillis();
        Object object = packageBuilder;
        PackageBuilder packageBuilder2 = object;
        ActivityHandler activityHandler2 = object2;
        PackageBuilder packageBuilder3 = object;
        ActivityHandler activityHandler3 = object2;
        Object object2 = activityHandler3.adjustConfig;
        DeviceInfo deviceInfo = activityHandler3.deviceInfo;
        object = activityHandler3.activityState;
        GlobalParameters globalParameters = activityHandler3.globalParameters;
        FirstSessionDelayManager firstSessionDelayManager = activityHandler3.firstSessionDelayManager;
        packageBuilder3((AdjustConfig)object2, deviceInfo, (ActivityState)object, globalParameters, firstSessionDelayManager, l);
        packageBuilder2.internalState = activityHandler2.internalState;
        object2 = packageBuilder.buildMeasurementConsentPackage(bl);
        activityHandler.packageHandler.addPackage((ActivityPackage)object2);
        activityHandler.packageHandler.sendFirstPackage();
    }

    private void trackAdRevenueI(AdjustAdRevenue object) {
        PackageBuilder packageBuilder;
        ActivityHandler activityHandler = object3;
        if (!activityHandler.checkActivityStateI(activityHandler.activityState) || !((ActivityHandler)object3).isEnabledI() || !((ActivityHandler)object3).checkAdjustAdRevenue((AdjustAdRevenue)object) || ((ActivityHandler)object3).activityState.isGdprForgotten) {
            return;
        }
        ActivityHandler activityHandler2 = object3;
        long l = System.currentTimeMillis();
        Object object2 = packageBuilder;
        AdjustAdRevenue adjustAdRevenue = object;
        PackageBuilder packageBuilder2 = object2;
        ActivityHandler activityHandler3 = object3;
        PackageBuilder packageBuilder3 = object2;
        ActivityHandler activityHandler4 = object3;
        Object object3 = activityHandler4.adjustConfig;
        object = activityHandler4.deviceInfo;
        object2 = activityHandler4.activityState;
        GlobalParameters globalParameters = activityHandler4.globalParameters;
        FirstSessionDelayManager firstSessionDelayManager = activityHandler4.firstSessionDelayManager;
        packageBuilder3((AdjustConfig)object3, (DeviceInfo)object, (ActivityState)object2, globalParameters, firstSessionDelayManager, l);
        packageBuilder2.internalState = activityHandler3.internalState;
        object3 = packageBuilder.buildAdRevenuePackage(adjustAdRevenue);
        activityHandler2.packageHandler.addPackage((ActivityPackage)object3);
        activityHandler2.packageHandler.sendFirstPackage();
    }

    private void trackPlayStoreSubscriptionI(AdjustPlayStoreSubscription object) {
        PackageBuilder packageBuilder;
        ActivityHandler activityHandler = object3;
        if (!activityHandler.checkActivityStateI(activityHandler.activityState) || !((ActivityHandler)object3).isEnabledI() || ((ActivityHandler)object3).activityState.isGdprForgotten) {
            return;
        }
        ActivityHandler activityHandler2 = object3;
        long l = System.currentTimeMillis();
        Object object2 = packageBuilder;
        AdjustPlayStoreSubscription adjustPlayStoreSubscription = object;
        PackageBuilder packageBuilder2 = object2;
        ActivityHandler activityHandler3 = object3;
        PackageBuilder packageBuilder3 = object2;
        ActivityHandler activityHandler4 = object3;
        Object object3 = activityHandler4.adjustConfig;
        object = activityHandler4.deviceInfo;
        object2 = activityHandler4.activityState;
        GlobalParameters globalParameters = activityHandler4.globalParameters;
        FirstSessionDelayManager firstSessionDelayManager = activityHandler4.firstSessionDelayManager;
        packageBuilder3((AdjustConfig)object3, (DeviceInfo)object, (ActivityState)object2, globalParameters, firstSessionDelayManager, l);
        packageBuilder2.internalState = activityHandler3.internalState;
        object3 = packageBuilder.buildSubscriptionPackage(adjustPlayStoreSubscription);
        activityHandler2.packageHandler.addPackage((ActivityPackage)object3);
        activityHandler2.packageHandler.sendFirstPackage();
    }

    private void verifyPlayStorePurchaseI(AdjustPlayStorePurchase object, OnPurchaseVerificationFinishedListener onPurchaseVerificationFinishedListener) {
        PackageBuilder packageBuilder;
        if (onPurchaseVerificationFinishedListener == null) {
            this.logger.warn("Purchase verification aborted because verification callback is null", new Object[0]);
            return;
        }
        if (this.adjustConfig.isDataResidency) {
            this.logger.warn("Purchase verification not available for data residency users right now", new Object[0]);
            onPurchaseVerificationFinishedListener.onVerificationFinished(new AdjustPurchaseVerificationResult("not_verified", 109, "Purchase verification not available for data residency users right now"));
            return;
        }
        ActivityHandler activityHandler = this;
        if (!activityHandler.checkActivityStateI(activityHandler.activityState)) {
            onPurchaseVerificationFinishedListener.onVerificationFinished(new AdjustPurchaseVerificationResult("not_verified", 102, "Purchase verification aborted because SDK is still not initialized"));
            this.logger.warn("Purchase verification aborted because SDK is still not initialized", new Object[0]);
            return;
        }
        if (!this.isEnabledI()) {
            onPurchaseVerificationFinishedListener.onVerificationFinished(new AdjustPurchaseVerificationResult("not_verified", 103, "Purchase verification aborted because SDK is disabled"));
            this.logger.warn("Purchase verification aborted because SDK is disabled", new Object[0]);
            return;
        }
        if (this.activityState.isGdprForgotten) {
            onPurchaseVerificationFinishedListener.onVerificationFinished(new AdjustPurchaseVerificationResult("not_verified", 104, "Purchase verification aborted because user is GDPR forgotten"));
            this.logger.warn("Purchase verification aborted because user is GDPR forgotten", new Object[0]);
            return;
        }
        if (object == null) {
            this.logger.warn("Purchase verification aborted because purchase instance is null", new Object[0]);
            onPurchaseVerificationFinishedListener.onVerificationFinished(new AdjustPurchaseVerificationResult("not_verified", 105, "Purchase verification aborted because purchase instance is null"));
            return;
        }
        long l = System.currentTimeMillis();
        Object object2 = packageBuilder;
        AdjustPlayStorePurchase adjustPlayStorePurchase = object;
        PackageBuilder packageBuilder2 = object2;
        PackageBuilder packageBuilder3 = object2;
        ActivityHandler activityHandler2 = this;
        object = activityHandler2.adjustConfig;
        object2 = activityHandler2.deviceInfo;
        ActivityState activityState = activityHandler2.activityState;
        GlobalParameters globalParameters = activityHandler2.globalParameters;
        FirstSessionDelayManager firstSessionDelayManager = activityHandler2.firstSessionDelayManager;
        packageBuilder3((AdjustConfig)object, (DeviceInfo)object2, activityState, globalParameters, firstSessionDelayManager, l);
        packageBuilder2.internalState = this.internalState;
        object = packageBuilder.buildVerificationPackage(adjustPlayStorePurchase, onPurchaseVerificationFinishedListener);
        if (object == null) {
            this.logger.warn("Purchase verification aborted because verification package is null", new Object[0]);
            onPurchaseVerificationFinishedListener.onVerificationFinished(new AdjustPurchaseVerificationResult("not_verified", 106, "Purchase verification aborted because verification package is null"));
            return;
        }
        this.purchaseVerificationHandler.sendPurchaseVerificationPackage((ActivityPackage)object);
    }

    private void verifyAndTrackPlayStorePurchaseI(AdjustEvent adjustEvent, OnPurchaseVerificationFinishedListener onPurchaseVerificationFinishedListener) {
        if (onPurchaseVerificationFinishedListener == null) {
            this.logger.warn("Purchase verification aborted because verification callback is null", new Object[0]);
            return;
        }
        if (this.adjustConfig.isDataResidency) {
            this.logger.warn("Purchase verification not available for data residency users right now", new Object[0]);
            onPurchaseVerificationFinishedListener.onVerificationFinished(new AdjustPurchaseVerificationResult("not_verified", 109, "Purchase verification not available for data residency users right now"));
            return;
        }
        ActivityHandler activityHandler = this;
        if (!activityHandler.checkActivityStateI(activityHandler.activityState)) {
            onPurchaseVerificationFinishedListener.onVerificationFinished(new AdjustPurchaseVerificationResult("not_verified", 102, "Purchase verification aborted because SDK is still not initialized"));
            this.logger.warn("Purchase verification aborted because SDK is still not initialized", new Object[0]);
            return;
        }
        if (!this.isEnabledI()) {
            onPurchaseVerificationFinishedListener.onVerificationFinished(new AdjustPurchaseVerificationResult("not_verified", 103, "Purchase verification aborted because SDK is disabled"));
            this.logger.warn("Purchase verification aborted because SDK is disabled", new Object[0]);
            return;
        }
        if (this.activityState.isGdprForgotten) {
            onPurchaseVerificationFinishedListener.onVerificationFinished(new AdjustPurchaseVerificationResult("not_verified", 104, "Purchase verification aborted because user is GDPR forgotten"));
            this.logger.warn("Purchase verification aborted because user is GDPR forgotten", new Object[0]);
            return;
        }
        if (adjustEvent == null) {
            this.logger.warn("Purchase verification aborted because event instance is null", new Object[0]);
            onPurchaseVerificationFinishedListener.onVerificationFinished(new AdjustPurchaseVerificationResult("not_verified", 106, "Purchase verification aborted because event instance is null"));
            return;
        }
        long l = System.currentTimeMillis();
        ActivityHandler activityHandler2 = this;
        AdjustConfig adjustConfig = activityHandler2.adjustConfig;
        DeviceInfo deviceInfo = activityHandler2.deviceInfo;
        ActivityState activityState = activityHandler2.activityState;
        GlobalParameters globalParameters = activityHandler2.globalParameters;
        FirstSessionDelayManager firstSessionDelayManager = activityHandler2.firstSessionDelayManager;
        ActivityPackage activityPackage = new PackageBuilder(adjustConfig, deviceInfo, activityState, globalParameters, firstSessionDelayManager, l).buildVerificationPackage(adjustEvent, onPurchaseVerificationFinishedListener);
        if (activityPackage == null) {
            this.logger.warn("Purchase verification aborted because verification package is null", new Object[0]);
            onPurchaseVerificationFinishedListener.onVerificationFinished(new AdjustPurchaseVerificationResult("not_verified", 107, "Purchase verification aborted because verification package is null"));
            return;
        }
        activityPackage.event = adjustEvent;
        this.purchaseVerificationHandler.sendPurchaseVerificationPackage(activityPackage);
    }

    private void gotOptOutResponseI() {
        ActivityHandler activityHandler = this;
        activityHandler.activityState.isGdprForgotten = true;
        activityHandler.writeActivityStateI();
        activityHandler.packageHandler.flush();
        activityHandler.setEnabledI(false);
    }

    private void readActivityStateI(Context context) {
        try {
            ((ActivityHandler)((Object)string)).activityState = Util.readObject(context, "AdjustIoActivityState", ACTIVITY_STATE_NAME, ActivityState.class);
            return;
        }
        catch (Exception exception) {
            ActivityHandler activityHandler = string;
            String string = exception.getMessage();
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = ACTIVITY_STATE_NAME;
            objectArray[1] = string;
            activityHandler.logger.error("Failed to read %s file (%s)", objectArray2);
            activityHandler.activityState = null;
            return;
        }
    }

    private void readAttributionI(Context context) {
        try {
            ((ActivityHandler)((Object)string)).attribution = Util.readObject(context, "AdjustAttribution", ATTRIBUTION_NAME, AdjustAttribution.class);
            return;
        }
        catch (Exception exception) {
            ActivityHandler activityHandler = string;
            String string = exception.getMessage();
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = ATTRIBUTION_NAME;
            objectArray[1] = string;
            activityHandler.logger.error("Failed to read %s file (%s)", objectArray2);
            activityHandler.attribution = null;
            return;
        }
    }

    private void readGlobalCallbackParametersI(Context context) {
        try {
            ((ActivityHandler)((Object)string)).globalParameters.callbackParameters = Util.readObject(context, "AdjustGlobalCallbackParameters", GLOBAL_CALLBACK_PARAMETERS_NAME, Map.class);
            return;
        }
        catch (Exception exception) {
            ActivityHandler activityHandler = string;
            String string = exception.getMessage();
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = GLOBAL_CALLBACK_PARAMETERS_NAME;
            objectArray[1] = string;
            activityHandler.logger.error("Failed to read %s file (%s)", objectArray2);
            activityHandler.globalParameters.callbackParameters = null;
            return;
        }
    }

    private void readGlobalPartnerParametersI(Context context) {
        try {
            ((ActivityHandler)((Object)string)).globalParameters.partnerParameters = Util.readObject(context, "AdjustGlobalPartnerParameters", GLOBAL_PARTNER_PARAMETERS_NAME, Map.class);
            return;
        }
        catch (Exception exception) {
            ActivityHandler activityHandler = string;
            String string = exception.getMessage();
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = GLOBAL_PARTNER_PARAMETERS_NAME;
            objectArray[1] = string;
            activityHandler.logger.error("Failed to read %s file (%s)", objectArray2);
            activityHandler.globalParameters.partnerParameters = null;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeActivityStateI() {
        Class<ActivityState> clazz = ActivityState.class;
        synchronized (ActivityState.class) {
            Throwable throwable2;
            block5: {
                ActivityState activityState;
                block4: {
                    try {
                        activityState = this.activityState;
                        if (activityState != null) break block4;
                    }
                    catch (Throwable throwable2) {
                        break block5;
                    }
                    return;
                }
                Util.writeObject(activityState, this.adjustConfig.context, "AdjustIoActivityState", ACTIVITY_STATE_NAME);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            throw throwable2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void teardownActivityStateS() {
        Class<ActivityState> clazz = ActivityState.class;
        synchronized (ActivityState.class) {
            Throwable throwable2;
            block4: {
                try {
                    if (this.activityState == null) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
                catch (Throwable throwable2) {
                    break block4;
                }
                this.activityState = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            throw throwable2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeAttributionI() {
        Class<AdjustAttribution> clazz = AdjustAttribution.class;
        synchronized (AdjustAttribution.class) {
            Throwable throwable2;
            block5: {
                AdjustAttribution adjustAttribution;
                block4: {
                    try {
                        adjustAttribution = this.attribution;
                        if (adjustAttribution != null) break block4;
                    }
                    catch (Throwable throwable2) {
                        break block5;
                    }
                    return;
                }
                Util.writeObject(adjustAttribution, this.adjustConfig.context, "AdjustAttribution", ATTRIBUTION_NAME);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            throw throwable2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void teardownAttributionS() {
        Class<AdjustAttribution> clazz = AdjustAttribution.class;
        synchronized (AdjustAttribution.class) {
            Throwable throwable2;
            block4: {
                try {
                    if (this.attribution == null) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
                catch (Throwable throwable2) {
                    break block4;
                }
                this.attribution = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            throw throwable2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeGlobalCallbackParametersI() {
        Class<GlobalParameters> clazz = GlobalParameters.class;
        synchronized (GlobalParameters.class) {
            Throwable throwable2;
            block5: {
                GlobalParameters globalParameters;
                block4: {
                    try {
                        globalParameters = this.globalParameters;
                        if (globalParameters != null) break block4;
                    }
                    catch (Throwable throwable2) {
                        break block5;
                    }
                    return;
                }
                Util.writeObject(globalParameters.callbackParameters, this.adjustConfig.context, "AdjustGlobalCallbackParameters", GLOBAL_CALLBACK_PARAMETERS_NAME);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            throw throwable2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeGlobalPartnerParametersI() {
        Class<GlobalParameters> clazz = GlobalParameters.class;
        synchronized (GlobalParameters.class) {
            Throwable throwable2;
            block5: {
                GlobalParameters globalParameters;
                block4: {
                    try {
                        globalParameters = this.globalParameters;
                        if (globalParameters != null) break block4;
                    }
                    catch (Throwable throwable2) {
                        break block5;
                    }
                    return;
                }
                Util.writeObject(globalParameters.partnerParameters, this.adjustConfig.context, "AdjustGlobalPartnerParameters", GLOBAL_PARTNER_PARAMETERS_NAME);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            throw throwable2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void teardownAllGlobalParametersS() {
        Class<GlobalParameters> clazz = GlobalParameters.class;
        synchronized (GlobalParameters.class) {
            Throwable throwable2;
            block4: {
                try {
                    if (this.globalParameters == null) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
                catch (Throwable throwable2) {
                    break block4;
                }
                this.globalParameters = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            throw throwable2;
        }
    }

    private boolean checkEventI(AdjustEvent adjustEvent) {
        if (adjustEvent == null) {
            this.logger.error("Event missing", new Object[0]);
            return false;
        }
        if (!adjustEvent.isValid()) {
            this.logger.error("Event not initialized correctly", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean shouldProcessEventI(String string) {
        if (string != null && !string.isEmpty()) {
            Object[] objectArray;
            if (objectArray.activityState.eventDeduplicationIdExists(string)) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = string;
                objectArray.logger.info("Skipping duplicate event with deduplication ID '%s'", objectArray);
                return false;
            }
            objectArray.activityState.addDeduplicationId(string);
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = string;
            objectArray.logger.verbose("Added deduplication ID '%s'", objectArray);
            return true;
        }
        return true;
    }

    private boolean checkAdjustAdRevenue(AdjustAdRevenue adjustAdRevenue) {
        if (adjustAdRevenue == null) {
            this.logger.error("Ad revenue object missing", new Object[0]);
            return false;
        }
        if (!adjustAdRevenue.isValid()) {
            this.logger.error("Ad revenue object not initialized correctly", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean checkActivityStateI(ActivityState activityState) {
        if (activityState == null) {
            this.logger.error("Sdk did not yet start", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean pausedI() {
        return this.pausedI(false);
    }

    private boolean pausedI(boolean bl) {
        if (bl) {
            return this.internalState.isOffline() || !this.isEnabledI();
            {
            }
        }
        return this.internalState.isOffline() || !this.isEnabledI();
        {
        }
    }

    private boolean toSendI() {
        return this.toSendI(false);
    }

    private boolean toSendI(boolean bl) {
        if (this.pausedI(bl)) {
            return false;
        }
        if (this.adjustConfig.isSendingInBackgroundEnabled) {
            return true;
        }
        return this.internalState.isInForeground();
    }

    private void checkForInstallReferrerInfo(SdkClickResponseData sdkClickResponseData) {
        if (!sdkClickResponseData.isInstallReferrer) {
            return;
        }
        String string = sdkClickResponseData.referrerApi;
        if (string != null && string.equalsIgnoreCase("huawei_ads")) {
            ActivityHandler activityHandler = this;
            ActivityState activityState = activityHandler.activityState;
            activityState.clickTimeHuawei = sdkClickResponseData.clickTime;
            activityState.installBeginHuawei = sdkClickResponseData.installBegin;
            activityState.installReferrerHuawei = sdkClickResponseData.installReferrer;
            activityHandler.writeActivityStateI();
            return;
        }
        string = sdkClickResponseData.referrerApi;
        if (string != null && string.equalsIgnoreCase("huawei_app_gallery")) {
            ActivityHandler activityHandler = this;
            ActivityState activityState = activityHandler.activityState;
            activityState.clickTimeHuawei = sdkClickResponseData.clickTime;
            activityState.installBeginHuawei = sdkClickResponseData.installBegin;
            activityState.installReferrerHuaweiAppGallery = sdkClickResponseData.installReferrer;
            activityHandler.writeActivityStateI();
            return;
        }
        string = sdkClickResponseData.referrerApi;
        if (string != null && string.equalsIgnoreCase("meta")) {
            ActivityHandler activityHandler = this;
            ActivityState activityState = activityHandler.activityState;
            activityState.clickTimeMeta = sdkClickResponseData.clickTime;
            activityState.installReferrerMeta = sdkClickResponseData.installReferrer;
            activityState.isClickMeta = sdkClickResponseData.isClick;
            activityHandler.writeActivityStateI();
            return;
        }
        string = sdkClickResponseData.referrerApi;
        if (string != null && string.equalsIgnoreCase("samsung")) {
            ActivityHandler activityHandler = this;
            ActivityState activityState = activityHandler.activityState;
            activityState.clickTimeSamsung = sdkClickResponseData.clickTime;
            activityState.installBeginSamsung = sdkClickResponseData.installBegin;
            activityState.installReferrerSamsung = sdkClickResponseData.installReferrer;
            activityHandler.writeActivityStateI();
            return;
        }
        string = sdkClickResponseData.referrerApi;
        if (string != null && string.equalsIgnoreCase("xiaomi")) {
            ActivityHandler activityHandler = this;
            ActivityState activityState = activityHandler.activityState;
            activityState.clickTimeXiaomi = sdkClickResponseData.clickTime;
            activityState.installBeginXiaomi = sdkClickResponseData.installBegin;
            activityState.installReferrerXiaomi = sdkClickResponseData.installReferrer;
            activityState.clickTimeServerXiaomi = sdkClickResponseData.clickTimeServer;
            activityState.installBeginServerXiaomi = sdkClickResponseData.installBeginServer;
            activityState.installVersionXiaomi = sdkClickResponseData.installVersion;
            activityHandler.writeActivityStateI();
            return;
        }
        string = sdkClickResponseData.referrerApi;
        if (string != null && string.equalsIgnoreCase("vivo")) {
            ActivityHandler activityHandler = this;
            ActivityState activityState = activityHandler.activityState;
            activityState.clickTimeVivo = sdkClickResponseData.clickTime;
            activityState.installBeginVivo = sdkClickResponseData.installBegin;
            activityState.installReferrerVivo = sdkClickResponseData.installReferrer;
            activityState.installVersionVivo = sdkClickResponseData.installVersion;
            activityHandler.writeActivityStateI();
            return;
        }
        ActivityHandler activityHandler = this;
        ActivityState activityState = activityHandler.activityState;
        activityState.clickTime = sdkClickResponseData.clickTime;
        activityState.installBegin = sdkClickResponseData.installBegin;
        activityState.installReferrer = sdkClickResponseData.installReferrer;
        activityState.clickTimeServer = sdkClickResponseData.clickTimeServer;
        activityState.installBeginServer = sdkClickResponseData.installBeginServer;
        activityState.installVersion = sdkClickResponseData.installVersion;
        activityState.googlePlayInstant = sdkClickResponseData.googlePlayInstant;
        activityHandler.writeActivityStateI();
    }

    private void processCoppaComplianceI() {
        if (!this.adjustConfig.coppaComplianceEnabled) {
            this.resetThirdPartySharingCoppaActivityStateI();
            return;
        }
        this.disableThirdPartySharingForCoppaEnabledI();
    }

    private void disableThirdPartySharingForCoppaEnabledI() {
        AdjustThirdPartySharing adjustThirdPartySharing;
        if (!((ActivityHandler)object2).shouldDisableThirdPartySharingWhenCoppaEnabled()) {
            return;
        }
        ActivityHandler activityHandler = object2;
        activityHandler.activityState.isThirdPartySharingDisabledForCoppa = true;
        activityHandler.writeActivityStateI();
        Object object = adjustThirdPartySharing;
        adjustThirdPartySharing = new AdjustThirdPartySharing(Boolean.FALSE);
        long l = System.currentTimeMillis();
        ActivityHandler activityHandler2 = object2;
        Object object2 = activityHandler2.adjustConfig;
        object = activityHandler2.deviceInfo;
        ActivityState activityState = activityHandler2.activityState;
        GlobalParameters globalParameters = activityHandler2.globalParameters;
        FirstSessionDelayManager firstSessionDelayManager = activityHandler2.firstSessionDelayManager;
        object2 = new PackageBuilder((AdjustConfig)object2, (DeviceInfo)object, activityState, globalParameters, firstSessionDelayManager, l).buildThirdPartySharingPackage((AdjustThirdPartySharing)object);
        activityHandler.packageHandler.addPackage((ActivityPackage)object2);
        activityHandler.packageHandler.sendFirstPackage();
    }

    private void resetThirdPartySharingCoppaActivityStateI() {
        ActivityState activityState = this.activityState;
        if (activityState != null && activityState.isThirdPartySharingDisabledForCoppa) {
            activityState.isThirdPartySharingDisabledForCoppa = false;
            this.writeActivityStateI();
            return;
        }
    }

    private boolean shouldDisableThirdPartySharingWhenCoppaEnabled() {
        if (((ActivityHandler)((Object)activityState)).activityState == null) {
            return false;
        }
        if (!((ActivityHandler)((Object)activityState)).isEnabledI()) {
            return false;
        }
        ActivityState activityState = ((ActivityHandler)((Object)activityState)).activityState;
        if (activityState.isGdprForgotten) {
            return false;
        }
        return activityState.isThirdPartySharingDisabledForCoppa ^ true;
    }

    private void lambda$setExternalDeviceIdInDelay$51(String string) {
        FirstSessionDelayManager firstSessionDelayManager = ((ActivityHandler)((Object)firstSessionDelayManager)).firstSessionDelayManager;
        if (firstSessionDelayManager.c != 3) {
            return;
        }
        firstSessionDelayManager.a.getAdjustConfig().externalDeviceId = string;
    }

    private void lambda$setPlayStoreKidsComplianceInDelay$50(boolean bl) {
        FirstSessionDelayManager firstSessionDelayManager = ((ActivityHandler)((Object)firstSessionDelayManager)).firstSessionDelayManager;
        if (firstSessionDelayManager.c != 3) {
            return;
        }
        firstSessionDelayManager.a.getAdjustConfig().playStoreKidsComplianceEnabled = bl;
    }

    private void lambda$setCoppaComplianceInDelay$49(boolean bl) {
        FirstSessionDelayManager firstSessionDelayManager = ((ActivityHandler)((Object)firstSessionDelayManager)).firstSessionDelayManager;
        if (firstSessionDelayManager.c != 3) {
            return;
        }
        firstSessionDelayManager.a.getAdjustConfig().coppaComplianceEnabled = bl;
    }

    private void lambda$endFirstSessionDelay$48() {
        Object object = ((ActivityHandler)object).firstSessionDelayManager;
        if (((FirstSessionDelayManager)object).c == 3) {
            Object object2 = object;
            ((FirstSessionDelayManager)object2).c = 4;
            ((FirstSessionDelayManager)object2).a.initI();
            object = ((FirstSessionDelayManager)object2).b;
            int n = ((ArrayList)object).size();
            for (int i = 0; i < n; ++i) {
                Object e = ((ArrayList)object).get(i);
                ((Runnable)e).run();
            }
        }
    }

    private void lambda$new$2(AdjustConfig adjustConfig) {
        ActivityHandler activityHandler = object;
        ((ActivityHandler)object).readAttributionI(adjustConfig.context);
        activityHandler.readActivityStateI(adjustConfig.context);
        Object object = activityHandler.firstSessionDelayManager;
        if (((FirstSessionDelayManager)object).a.getActivityState() == null && ((FirstSessionDelayManager)object).a.getAdjustConfig().isFirstSessionDelayEnabled) {
            ((FirstSessionDelayManager)object).c = 3;
            return;
        }
        Object object2 = object;
        ((FirstSessionDelayManager)object2).c = 2;
        ((FirstSessionDelayManager)object2).a.initI();
        object = ((FirstSessionDelayManager)object2).b;
        int n = ((ArrayList)object).size();
        for (int i = 0; i < n; ++i) {
            Object e = ((ArrayList)object).get(i);
            ((Runnable)e).run();
        }
    }

    @Override
    public void teardown() {
        Map<String, String> map = this.backgroundTimer;
        if (map != null) {
            ((TimerOnce)((Object)map)).teardown();
        }
        if ((map = this.foregroundTimer) != null) {
            ((TimerCycle)((Object)map)).teardown();
        }
        if ((map = this.executor) != null) {
            map.teardown();
        }
        if ((map = this.packageHandler) != null) {
            map.teardown();
        }
        if ((map = this.attributionHandler) != null) {
            map.teardown();
        }
        if ((map = this.sdkClickHandler) != null) {
            map.teardown();
        }
        if ((map = this.purchaseVerificationHandler) != null) {
            map.teardown();
        }
        if ((map = this.globalParameters) != null) {
            map = ((GlobalParameters)((Object)map)).callbackParameters;
            if (map != null) {
                map.clear();
            }
            if ((map = this.globalParameters.partnerParameters) != null) {
                map.clear();
            }
        }
        this.teardownActivityStateS();
        this.teardownAttributionS();
        this.teardownAllGlobalParametersS();
        this.packageHandler = null;
        this.logger = null;
        this.foregroundTimer = null;
        this.executor = null;
        this.backgroundTimer = null;
        this.internalState = null;
        this.deviceInfo = null;
        this.adjustConfig = null;
        this.attributionHandler = null;
        this.sdkClickHandler = null;
        this.purchaseVerificationHandler = null;
        this.globalParameters = null;
    }

    @Override
    public void onActivityLifecycle(boolean bl) {
        try {
            ((ActivityHandler)((Object)iLogger)).executor.submit(() -> this.firstSessionDelayManager.a(() -> {
                Boolean bl2 = this.internalState.foregroundOrElseBackground;
                if (bl2 != null && bl2 == bl) {
                    return;
                }
                this.internalState.foregroundOrElseBackground = bl;
                if (bl) {
                    this.onResumeI();
                    return;
                }
                this.onPauseI();
            }, "activity state"));
            return;
        }
        catch (Exception exception) {
            ILogger iLogger = ((ActivityHandler)((Object)iLogger)).logger;
            if (iLogger != null) {
                iLogger.error("Exception while executing onActivityLifecycle task", new Object[0]);
            }
            return;
        }
    }

    @Override
    public AdjustConfig getAdjustConfig() {
        return this.adjustConfig;
    }

    @Override
    public DeviceInfo getDeviceInfo() {
        return this.deviceInfo;
    }

    @Override
    public ActivityState getActivityState() {
        return this.activityState;
    }

    @Override
    public GlobalParameters getGlobalParameters() {
        return this.globalParameters;
    }

    @Override
    public FirstSessionDelayManager getFirstSessionDelayManager() {
        return this.firstSessionDelayManager;
    }

    @Override
    public void init(AdjustConfig adjustConfig) {
        this.adjustConfig = adjustConfig;
    }

    @Override
    public void onResume() {
        this.onActivityLifecycle(true);
    }

    public void onResumeI() {
        ActivityHandler activityHandler = this;
        activityHandler.stopBackgroundTimerI();
        activityHandler.startForegroundTimerI();
        activityHandler.logger.verbose("Subsession start", new Object[0]);
        activityHandler.startI();
    }

    @Override
    public void onPause() {
        this.onActivityLifecycle(false);
    }

    public void onPauseI() {
        ActivityHandler activityHandler = this;
        activityHandler.stopForegroundTimerI();
        activityHandler.startBackgroundTimerI();
        activityHandler.logger.verbose("Subsession end", new Object[0]);
        activityHandler.endI();
    }

    @Override
    public void trackEvent(AdjustEvent adjustEvent) {
        this.executor.submit(() -> this.firstSessionDelayManager.a(() -> {
            if (this.activityState == null) {
                ActivityHandler activityHandler = this;
                activityHandler.logger.warn("Event tracked before first activity resumed.\nIf it was triggered in the Application class, it might timestamp or even send an install long before the user opens the app.\nPlease check https://github.com/adjust/android_sdk#can-i-trigger-an-event-at-application-launch for more information.", new Object[0]);
                activityHandler.startI();
            }
            this.trackEventI(adjustEvent);
        }, "track event"));
    }

    @Override
    public void finishedTrackingActivity(ResponseData responseData) {
        if (responseData instanceof SessionResponseData) {
            ActivityHandler activityHandler = sdkClickResponseData;
            activityHandler.logger.debug("Finished tracking session", new Object[0]);
            activityHandler.attributionHandler.checkSessionResponse((SessionResponseData)responseData);
            return;
        }
        if (responseData instanceof SdkClickResponseData) {
            ActivityHandler activityHandler = sdkClickResponseData;
            SdkClickResponseData sdkClickResponseData = (SdkClickResponseData)responseData;
            activityHandler.checkForInstallReferrerInfo(sdkClickResponseData);
            activityHandler.attributionHandler.checkSdkClickResponse(sdkClickResponseData);
            return;
        }
        if (responseData instanceof EventResponseData) {
            ((ActivityHandler)((Object)sdkClickResponseData)).launchEventResponseTasks((EventResponseData)responseData);
            return;
        }
        if (responseData instanceof PurchaseVerificationResponseData) {
            ((ActivityHandler)((Object)sdkClickResponseData)).launchPurchaseVerificationResponseTasks((PurchaseVerificationResponseData)responseData);
            return;
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        this.executor.submit(() -> {
            FirstSessionDelayManager firstSessionDelayManager = this.firstSessionDelayManager;
            String string = bl ? "enable" : "disable";
            firstSessionDelayManager.a(() -> this.setEnabledI(bl), string);
        });
    }

    @Override
    public void setOfflineMode(boolean bl) {
        this.executor.submit(() -> {
            FirstSessionDelayManager firstSessionDelayManager = this.firstSessionDelayManager;
            String string = bl ? "put SDK in offline mode" : "put SDK back to online mode";
            firstSessionDelayManager.a(() -> this.setOfflineModeI(bl), string);
        });
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabledI();
    }

    @Override
    public void isEnabled(OnIsEnabledListener onIsEnabledListener) {
        this.executor.submit(() -> this.firstSessionDelayManager.a(() -> {
            Handler handler;
            Handler handler2 = handler;
            handler2(this.adjustConfig.context.getMainLooper());
            handler.post(() -> onIsEnabledListener.onIsEnabledRead(this.isEnabledI()));
        }, "is SDK enabled"));
    }

    @Override
    public void processDeeplink(AdjustDeeplink adjustDeeplink, long l) {
        this.executor.submit(() -> this.firstSessionDelayManager.a(() -> this.processDeeplinkI(adjustDeeplink, l), "process deep link"));
    }

    @Override
    public void processAndResolveDeeplink(AdjustDeeplink adjustDeeplink, long l, OnDeeplinkResolvedListener onDeeplinkResolvedListener) {
        this.cachedDeeplinkResolutionCallback = onDeeplinkResolvedListener;
        this.executor.submit(() -> this.firstSessionDelayManager.a(() -> this.processDeeplinkI(adjustDeeplink, l), "process and resolve deep link"));
    }

    @Override
    public boolean updateAttributionI(final AdjustAttribution adjustAttribution) {
        if (adjustAttribution == null) {
            return false;
        }
        if (this.activityState.askingAttribution) {
            return false;
        }
        if (!this.cachedAttributionReadCallbacks.isEmpty()) {
            ArrayList<OnAttributionReadListener> arrayList;
            final ArrayList<OnAttributionReadListener> arrayList2 = arrayList;
            arrayList = new ArrayList<OnAttributionReadListener>(this.cachedAttributionReadCallbacks);
            this.cachedAttributionReadCallbacks.clear();
            new Handler(this.adjustConfig.context.getMainLooper()).post(new Runnable(){

                @Override
                public final void run() {
                    ArrayList arrayList = arrayList2;
                    int n = arrayList.size();
                    for (int i = 0; i < n; ++i) {
                        Object e = arrayList.get(i);
                        OnAttributionReadListener onAttributionReadListener = (OnAttributionReadListener)e;
                        if (onAttributionReadListener == null) continue;
                        onAttributionReadListener.onAttributionRead(adjustAttribution);
                    }
                }
            });
        }
        if (adjustAttribution.equals(this.attribution)) {
            return false;
        }
        this.attribution = adjustAttribution;
        this.writeAttributionI();
        return true;
    }

    @Override
    public void setAskingAttribution(final boolean bl) {
        this.executor.submit(new Runnable(){

            @Override
            public final void run() {
                ActivityHandler.this.setAskingAttributionI(bl);
            }
        });
    }

    @Override
    public void sendReftagReferrer() {
        this.executor.submit(() -> this.firstSessionDelayManager.a(() -> this.sendReftagReferrerI(), "send referrer"));
    }

    @Override
    public void sendPreinstallReferrer() {
        this.executor.submit(() -> this.firstSessionDelayManager.a(() -> this.sendPreinstallReferrerI(), "send preinstall referrer"));
    }

    @Override
    public void sendInstallReferrer(final ReferrerDetails referrerDetails, final String string) {
        this.executor.submit(new Runnable(){

            @Override
            public final void run() {
                4 v0 = referrerDetails2;
                ReferrerDetails referrerDetails2 = v0.referrerDetails;
                referrerDetails2.ActivityHandler.this.sendInstallReferrerI(referrerDetails2, v0.string);
            }
        });
    }

    @Override
    public void sendLicenseVerificationData(final LicenseData licenseData) {
        this.executor.submit(new Runnable(){

            @Override
            public final void run() {
                ActivityHandler.this.sendLicenseVerificationDataI(licenseData);
            }
        });
    }

    @Override
    public void launchEventResponseTasks(final EventResponseData eventResponseData) {
        this.executor.submit(new Runnable(){

            @Override
            public final void run() {
                ActivityHandler.this.launchEventResponseTasksI(eventResponseData);
            }
        });
    }

    @Override
    public void launchSdkClickResponseTasks(final SdkClickResponseData sdkClickResponseData) {
        this.executor.submit(new Runnable(){

            @Override
            public final void run() {
                ActivityHandler.this.launchSdkClickResponseTasksI(sdkClickResponseData);
            }
        });
    }

    @Override
    public void launchSessionResponseTasks(final SessionResponseData sessionResponseData) {
        this.executor.submit(new Runnable(){

            @Override
            public final void run() {
                ActivityHandler.this.launchSessionResponseTasksI(sessionResponseData);
            }
        });
    }

    @Override
    public void launchAttributionResponseTasks(final AttributionResponseData attributionResponseData) {
        this.executor.submit(new Runnable(){

            @Override
            public final void run() {
                ActivityHandler.this.launchAttributionResponseTasksI(attributionResponseData);
            }
        });
    }

    @Override
    public void launchPurchaseVerificationResponseTasks(final PurchaseVerificationResponseData purchaseVerificationResponseData) {
        this.executor.submit(new Runnable(){

            @Override
            public final void run() {
                ActivityHandler.this.launchPurchaseVerificationResponseTasksI(purchaseVerificationResponseData);
            }
        });
    }

    @Override
    public void addGlobalCallbackParameter(String string, String string2) {
        this.executor.submit(() -> this.firstSessionDelayManager.a("add global callback parameter", activityHandler -> activityHandler.addGlobalCallbackParameterI(string, string2)));
    }

    @Override
    public void addGlobalPartnerParameter(String string, String string2) {
        this.executor.submit(() -> this.firstSessionDelayManager.a("add global partner parameter", activityHandler -> activityHandler.addGlobalPartnerParameterI(string, string2)));
    }

    @Override
    public void removeGlobalCallbackParameter(String string) {
        this.executor.submit(() -> this.firstSessionDelayManager.a("remove global callback parameter", activityHandler -> activityHandler.removeGlobalCallbackParameterI(string)));
    }

    @Override
    public void removeGlobalPartnerParameter(String string) {
        this.executor.submit(() -> this.firstSessionDelayManager.a("remove global partner parameter", activityHandler -> activityHandler.removeGlobalPartnerParameterI(string)));
    }

    @Override
    public void removeGlobalCallbackParameters() {
        this.executor.submit(() -> this.firstSessionDelayManager.a("remove global callback parameters", activityHandler -> activityHandler.removeGlobalCallbackParametersI()));
    }

    @Override
    public void removeGlobalPartnerParameters() {
        this.executor.submit(() -> this.firstSessionDelayManager.a("remove global partner parameters", activityHandler -> activityHandler.removeGlobalPartnerParametersI()));
    }

    @Override
    public void setPushToken(String string, boolean bl) {
        this.executor.submit(() -> this.firstSessionDelayManager.a(() -> {
            if (!bl) {
                SharedPreferencesManager.getDefaultInstance(this.getContext()).savePushToken(string);
            }
            if (this.activityState == null) {
                return;
            }
            this.setPushTokenI(string);
        }, "set push token"));
    }

    @Override
    public void gdprForgetMe() {
        this.executor.submit(() -> this.firstSessionDelayManager.a(() -> this.gdprForgetMeI(), "GDPR forget device"));
    }

    @Override
    public void trackThirdPartySharing(AdjustThirdPartySharing adjustThirdPartySharing) {
        this.executor.submit(() -> this.firstSessionDelayManager.a("track third party sharing", activityHandler -> activityHandler.tryTrackThirdPartySharingI(adjustThirdPartySharing)));
    }

    @Override
    public void trackMeasurementConsent(boolean bl) {
        this.executor.submit(() -> this.firstSessionDelayManager.a("track measurement consent", activityHandler -> activityHandler.tryTrackMeasurementConsentI(bl)));
    }

    @Override
    public void trackAdRevenue(AdjustAdRevenue adjustAdRevenue) {
        this.executor.submit(() -> this.firstSessionDelayManager.a(() -> this.trackAdRevenueI(adjustAdRevenue), "track ad revenue"));
    }

    @Override
    public void trackPlayStoreSubscription(AdjustPlayStoreSubscription adjustPlayStoreSubscription) {
        this.executor.submit(() -> this.firstSessionDelayManager.a(() -> this.trackPlayStoreSubscriptionI(adjustPlayStoreSubscription), "track play store subscription"));
    }

    @Override
    public void gotOptOutResponse() {
        this.executor.submit(new Runnable(){

            @Override
            public final void run() {
                ActivityHandler.this.gotOptOutResponseI();
            }
        });
    }

    @Override
    public Context getContext() {
        return this.adjustConfig.context;
    }

    public void foregroundTimerFired() {
        this.executor.submit(new Runnable(){

            @Override
            public final void run() {
                ActivityHandler.this.foregroundTimerFiredI();
            }
        });
    }

    public void backgroundTimerFired() {
        this.executor.submit(new Runnable(){

            @Override
            public final void run() {
                ActivityHandler.this.backgroundTimerFiredI();
            }
        });
    }

    @Override
    public void getAdid(final OnAdidReadListener onAdidReadListener) {
        ActivityState activityState = this.activityState;
        if (activityState != null && activityState.adid != null) {
            new Handler(this.adjustConfig.context.getMainLooper()).post(new Runnable(){

                @Override
                public final void run() {
                    onAdidReadListener.onAdidRead(((ActivityHandler)ActivityHandler.this).activityState.adid);
                }
            });
            return;
        }
        if (activityState == null) {
            this.logger.warn("SDK needs to be initialized before getting adid", new Object[0]);
        }
        this.cachedAdidReadCallbacks.add(onAdidReadListener);
    }

    @Override
    public void getAttribution(final OnAttributionReadListener onAttributionReadListener) {
        if (this.attribution != null) {
            new Handler(this.adjustConfig.context.getMainLooper()).post(new Runnable(){

                @Override
                public final void run() {
                    onAttributionReadListener.onAttributionRead(ActivityHandler.this.attribution);
                }
            });
            return;
        }
        this.cachedAttributionReadCallbacks.add(onAttributionReadListener);
    }

    @Override
    public void verifyPlayStorePurchase(AdjustPlayStorePurchase adjustPlayStorePurchase, OnPurchaseVerificationFinishedListener onPurchaseVerificationFinishedListener) {
        this.executor.submit(() -> this.firstSessionDelayManager.a(() -> this.verifyPlayStorePurchaseI(adjustPlayStorePurchase, onPurchaseVerificationFinishedListener), "verify play store purchase"));
    }

    @Override
    public void verifyAndTrackPlayStorePurchase(AdjustEvent adjustEvent, OnPurchaseVerificationFinishedListener onPurchaseVerificationFinishedListener) {
        this.executor.submit(() -> this.firstSessionDelayManager.a(() -> this.verifyAndTrackPlayStorePurchaseI(adjustEvent, onPurchaseVerificationFinishedListener), "verify and track play store purchase"));
    }

    @Override
    public void endFirstSessionDelay() {
        this.executor.submit(this::lambda$endFirstSessionDelay$48);
    }

    @Override
    public void setCoppaComplianceInDelay(boolean bl) {
        this.executor.submit(() -> this.lambda$setCoppaComplianceInDelay$49(bl));
    }

    @Override
    public void setPlayStoreKidsComplianceInDelay(boolean bl) {
        this.executor.submit(() -> this.lambda$setPlayStoreKidsComplianceInDelay$50(bl));
    }

    @Override
    public void setExternalDeviceIdInDelay(String string) {
        this.executor.submit(() -> this.lambda$setExternalDeviceIdInDelay$51(string));
    }

    @Override
    public InternalState getInternalState() {
        return this.internalState;
    }

    public void initI() {
        InstallReferrer installReferrer;
        ActivityPackageSender activityPackageSender;
        ActivityPackageSender activityPackageSender2;
        ActivityPackageSender activityPackageSender3;
        ActivityPackageSender activityPackageSender4;
        TimerCycle timerCycle;
        Object[] objectArray;
        DeviceInfo deviceInfo;
        GlobalParameters globalParameters;
        SESSION_INTERVAL = AdjustFactory.getSessionInterval();
        SUBSESSION_INTERVAL = AdjustFactory.getSubsessionInterval();
        FOREGROUND_TIMER_INTERVAL = AdjustFactory.getTimerInterval();
        FOREGROUND_TIMER_START = AdjustFactory.getTimerStart();
        BACKGROUND_TIMER_INTERVAL = AdjustFactory.getTimerInterval();
        Object object = globalParameters;
        globalParameters = new GlobalParameters();
        this.globalParameters = object;
        this.readGlobalCallbackParametersI(this.adjustConfig.context);
        this.readGlobalPartnerParametersI(this.adjustConfig.context);
        object = this.activityState;
        if (object != null) {
            ((ActivityState)object).setEventDeduplicationIdsMaxSize(this.adjustConfig.getEventDeduplicationIdsMaxSize());
        }
        object = this.adjustConfig;
        if (((AdjustConfig)object).startEnabled != null) {
            ((AdjustConfig)object).preLaunchActions.preLaunchActionsArray.add(new IRunActivityHandler(){

                @Override
                public final void run(ActivityHandler activityHandler) {
                    activityHandler.setEnabledI(((ActivityHandler)ActivityHandler.this).adjustConfig.startEnabled);
                }
            });
        }
        if ((object = this.activityState) != null) {
            InternalState internalState = this.internalState;
            internalState.enabled = ((ActivityState)object).enabled;
            internalState.firstLaunch = false;
        } else {
            this.internalState.firstLaunch = true;
        }
        this.readConfigFile(this.adjustConfig.context);
        this.deviceInfo = object = deviceInfo;
        new DeviceInfo(this.adjustConfig).reloadPlayIds(this.adjustConfig);
        if (this.deviceInfo.playAdId == null) {
            if (!Util.canReadPlayIds(this.adjustConfig)) {
                this.logger.info("Cannot read Google Play Services Advertising ID with COPPA or play store kids app enabled", new Object[0]);
            } else {
                this.logger.warn("Unable to get Google Play Services Advertising ID at start time", new Object[0]);
            }
            if (this.deviceInfo.androidId == null) {
                if (!Util.canReadNonPlayIds(this.adjustConfig)) {
                    this.logger.info("Cannot read non Play IDs with COPPA or play store kids app enabled", new Object[0]);
                } else {
                    this.logger.error("Unable to get any Device IDs. Please check if Proguard is correctly set with Adjust SDK", new Object[0]);
                }
            }
        } else {
            this.logger.info("Google Play Services Advertising ID read correctly at start time", new Object[0]);
        }
        if ((object = this.adjustConfig.defaultTracker) != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = object;
            this.logger.info("Default tracker: '%s'", objectArray);
        }
        if ((object = this.adjustConfig.pushToken) != null) {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = object;
            this.logger.info("Push token: '%s'", objectArray);
            if (this.activityState != null) {
                this.setPushToken(this.adjustConfig.pushToken, false);
            } else {
                SharedPreferencesManager.getDefaultInstance(this.getContext()).savePushToken(this.adjustConfig.pushToken);
            }
        } else if (this.activityState != null && (object = SharedPreferencesManager.getDefaultInstance(this.getContext()).getPushToken()) != null) {
            this.setPushToken((String)object, true);
        }
        if (this.cachedDeeplinkResolutionCallback == null) {
            this.cachedDeeplinkResolutionCallback = this.adjustConfig.cachedDeeplinkResolutionCallback;
        }
        this.handleAdidCallbackI();
        this.handleAttributionCallbackI();
        if (this.activityState != null && SharedPreferencesManager.getDefaultInstance(this.getContext()).getGdprForgetMe()) {
            this.gdprForgetMe();
        }
        object = timerCycle;
        long l = FOREGROUND_TIMER_START;
        long l2 = FOREGROUND_TIMER_INTERVAL;
        timerCycle = new TimerCycle(new Runnable(){

            @Override
            public final void run() {
                ActivityHandler.this.foregroundTimerFired();
            }
        }, l, l2, FOREGROUND_TIMER_NAME);
        this.foregroundTimer = object;
        if (this.adjustConfig.isSendingInBackgroundEnabled) {
            TimerOnce timerOnce;
            this.logger.info("Send in background configured", new Object[0]);
            object = timerOnce;
            timerOnce = new TimerOnce(new Runnable(){

                @Override
                public final void run() {
                    ActivityHandler.this.backgroundTimerFired();
                }
            }, BACKGROUND_TIMER_NAME);
            this.backgroundTimer = object;
        }
        object = activityPackageSender4;
        AdjustConfig adjustConfig = this.adjustConfig;
        List<String> list = adjustConfig.urlStrategyDomains;
        boolean bl = adjustConfig.useSubdomains;
        String string = adjustConfig.basePath;
        String string2 = adjustConfig.gdprPath;
        String string3 = adjustConfig.subscriptionPath;
        String string4 = adjustConfig.purchaseVerificationPath;
        String string5 = this.deviceInfo.clientSdk;
        Context context = adjustConfig.context;
        activityPackageSender4 = new ActivityPackageSender(list, bl, string, string2, string3, string4, string5, 60000, context);
        boolean bl2 = this.toSendI(false);
        this.packageHandler = AdjustFactory.getPackageHandler(this, this.adjustConfig.context, bl2, (IActivityPackageSender)object);
        object = activityPackageSender3;
        AdjustConfig adjustConfig2 = this.adjustConfig;
        List<String> list2 = adjustConfig2.urlStrategyDomains;
        bl = adjustConfig2.useSubdomains;
        string = adjustConfig2.basePath;
        string2 = adjustConfig2.gdprPath;
        string3 = adjustConfig2.subscriptionPath;
        string4 = adjustConfig2.purchaseVerificationPath;
        string5 = this.deviceInfo.clientSdk;
        context = adjustConfig2.context;
        activityPackageSender3 = new ActivityPackageSender(list2, bl, string, string2, string3, string4, string5, 60000, context);
        this.attributionHandler = AdjustFactory.getAttributionHandler(this, this.toSendI(false), (IActivityPackageSender)object);
        object = activityPackageSender2;
        AdjustConfig adjustConfig3 = this.adjustConfig;
        list2 = adjustConfig3.urlStrategyDomains;
        bl = adjustConfig3.useSubdomains;
        string = adjustConfig3.basePath;
        string2 = adjustConfig3.gdprPath;
        string3 = adjustConfig3.subscriptionPath;
        string4 = adjustConfig3.purchaseVerificationPath;
        string5 = this.deviceInfo.clientSdk;
        context = adjustConfig3.context;
        activityPackageSender2 = new ActivityPackageSender(list2, bl, string, string2, string3, string4, string5, 60000, context);
        this.sdkClickHandler = AdjustFactory.getSdkClickHandler(this, this.toSendI(true), (IActivityPackageSender)object);
        object = activityPackageSender;
        AdjustConfig adjustConfig4 = this.adjustConfig;
        list2 = adjustConfig4.urlStrategyDomains;
        bl = adjustConfig4.useSubdomains;
        string = adjustConfig4.basePath;
        string2 = adjustConfig4.gdprPath;
        string3 = adjustConfig4.subscriptionPath;
        string4 = adjustConfig4.purchaseVerificationPath;
        string5 = this.deviceInfo.clientSdk;
        context = adjustConfig4.context;
        activityPackageSender = new ActivityPackageSender(list2, bl, string, string2, string3, string4, string5, 30000, context);
        this.purchaseVerificationHandler = AdjustFactory.getPurchaseVerificationHandler(this, this.toSendI(true), (IActivityPackageSender)object);
        object = installReferrer;
        installReferrer = new InstallReferrer(this.adjustConfig.context, new InstallReferrerReadListener(){

            @Override
            public final void onInstallReferrerRead(ReferrerDetails referrerDetails, String string) {
                ActivityHandler.this.sendInstallReferrer(referrerDetails, string);
            }

            @Override
            public final void onFail(String string) {
                ActivityHandler.this.logger.debug(string, new Object[0]);
            }
        });
        this.installReferrer = object;
        this.preLaunchActionsI(this.adjustConfig.preLaunchActions.preLaunchActionsArray);
        this.sendReftagReferrerI();
        this.bootstrapLifecycleI();
    }

    public void addGlobalCallbackParameterI(String string, String string2) {
        if (!Util.isValidParameter(string, "key", "Global Callback") || !Util.isValidParameter(string2, "value", "Global Callback")) {
            return;
        }
        Object[] objectArray = objectArray3.globalParameters;
        if (objectArray.callbackParameters == null) {
            LinkedHashMap linkedHashMap;
            GlobalParameters globalParameters = objectArray;
            objectArray = linkedHashMap;
            linkedHashMap = new LinkedHashMap();
            globalParameters.callbackParameters = objectArray;
        }
        if (string2.equals(objectArray = objectArray3.globalParameters.callbackParameters.get(string))) {
            Object[] objectArray2 = new Object[1];
            Object[] objectArray3 = objectArray2;
            objectArray2[0] = string;
            objectArray3.logger.verbose("Key %s already present with the same value", objectArray3);
            return;
        }
        if (objectArray != null) {
            Object[] objectArray4 = new Object[1];
            objectArray = objectArray4;
            objectArray4[0] = string;
            objectArray3.logger.warn("Key %s will be overwritten", objectArray);
        }
        objectArray3.globalParameters.callbackParameters.put(string, string2);
        super.writeGlobalCallbackParametersI();
    }

    public void addGlobalPartnerParameterI(String string, String string2) {
        if (!Util.isValidParameter(string, "key", "Global Partner") || !Util.isValidParameter(string2, "value", "Global Partner")) {
            return;
        }
        Object[] objectArray = objectArray3.globalParameters;
        if (objectArray.partnerParameters == null) {
            LinkedHashMap linkedHashMap;
            GlobalParameters globalParameters = objectArray;
            objectArray = linkedHashMap;
            linkedHashMap = new LinkedHashMap();
            globalParameters.partnerParameters = objectArray;
        }
        if (string2.equals(objectArray = objectArray3.globalParameters.partnerParameters.get(string))) {
            Object[] objectArray2 = new Object[1];
            Object[] objectArray3 = objectArray2;
            objectArray2[0] = string;
            objectArray3.logger.verbose("Key %s already present with the same value", objectArray3);
            return;
        }
        if (objectArray != null) {
            Object[] objectArray4 = new Object[1];
            objectArray = objectArray4;
            objectArray4[0] = string;
            objectArray3.logger.warn("Key %s will be overwritten", objectArray);
        }
        objectArray3.globalParameters.partnerParameters.put(string, string2);
        super.writeGlobalPartnerParametersI();
    }

    public void removeGlobalCallbackParameterI(String string) {
        Object[] objectArray;
        if (!Util.isValidParameter(string, "key", "Session Callback")) {
            return;
        }
        Map<String, String> map = objectArray.globalParameters.callbackParameters;
        if (map == null) {
            objectArray.logger.warn("Session Callback parameters are not set", new Object[0]);
            return;
        }
        if (map.remove(string) == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = string;
            objectArray.logger.warn("Key %s does not exist", objectArray);
            return;
        }
        Object[] objectArray3 = new Object[1];
        objectArray = objectArray3;
        objectArray3[0] = string;
        objectArray.logger.debug("Key %s will be removed", objectArray);
        super.writeGlobalCallbackParametersI();
    }

    public void removeGlobalPartnerParameterI(String string) {
        Object[] objectArray;
        if (!Util.isValidParameter(string, "key", "Session Partner")) {
            return;
        }
        Map<String, String> map = objectArray.globalParameters.partnerParameters;
        if (map == null) {
            objectArray.logger.warn("Session Partner parameters are not set", new Object[0]);
            return;
        }
        if (map.remove(string) == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = string;
            objectArray.logger.warn("Key %s does not exist", objectArray);
            return;
        }
        Object[] objectArray3 = new Object[1];
        objectArray = objectArray3;
        objectArray3[0] = string;
        objectArray.logger.debug("Key %s will be removed", objectArray);
        super.writeGlobalPartnerParametersI();
    }

    public void removeGlobalCallbackParametersI() {
        if (this.globalParameters.callbackParameters == null) {
            this.logger.warn("Session Callback parameters are not set", new Object[0]);
        }
        this.globalParameters.callbackParameters = null;
        this.writeGlobalCallbackParametersI();
    }

    public void removeGlobalPartnerParametersI() {
        if (this.globalParameters.partnerParameters == null) {
            this.logger.warn("Session Partner parameters are not set", new Object[0]);
        }
        this.globalParameters.partnerParameters = null;
        this.writeGlobalPartnerParametersI();
    }

    public void tryTrackThirdPartySharingI(AdjustThirdPartySharing adjustThirdPartySharing) {
        if (this.canTrackThirdPartySharingI()) {
            this.trackThirdPartySharingI(adjustThirdPartySharing);
            return;
        }
        if (this.cachedAdjustThirdPartySharingArray == null) {
            ArrayList<AdjustThirdPartySharing> arrayList;
            ArrayList<AdjustThirdPartySharing> arrayList2 = arrayList;
            arrayList = new ArrayList<AdjustThirdPartySharing>();
            this.cachedAdjustThirdPartySharingArray = arrayList2;
        }
        this.cachedAdjustThirdPartySharingArray.add(adjustThirdPartySharing);
    }

    public void tryTrackMeasurementConsentI(boolean bl) {
        if (this.canTrackMeasurementConsentI()) {
            this.trackMeasurementConsentI(bl);
            return;
        }
        this.cachedLastMeasurementConsentTrack = bl;
    }

    public class InternalState {
        boolean enabled;
        boolean offline;
        boolean firstLaunch;
        boolean sessionResponseProcessed;
        boolean preinstallHasBeenRead;
        Boolean foregroundOrElseBackground;

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isDisabled() {
            return this.enabled ^ true;
        }

        public boolean isOffline() {
            return this.offline;
        }

        public boolean isOnline() {
            return this.offline ^ true;
        }

        public boolean isInBackground() {
            Boolean bl = ((InternalState)((Object)bl)).foregroundOrElseBackground;
            return bl != null && bl == false;
        }

        public boolean isInForeground() {
            Boolean bl = ((InternalState)((Object)bl)).foregroundOrElseBackground;
            return bl != null && bl != false;
        }

        public boolean isFirstLaunch() {
            return this.firstLaunch;
        }

        public boolean hasSessionResponseNotBeenProcessed() {
            return this.sessionResponseProcessed ^ true;
        }

        public boolean hasPreinstallBeenRead() {
            return this.preinstallHasBeenRead;
        }
    }
}

