/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import com.adjust.sdk.AdjustDeeplink;
import com.adjust.sdk.AdjustFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SharedPreferencesManager {
    private static final String PREFS_NAME = "adjust_preferences";
    private static final String PREFS_KEY_RAW_REFERRERS = "raw_referrers";
    private static final String PREFS_KEY_PUSH_TOKEN = "push_token";
    private static final String PREFS_KEY_INSTALL_TRACKED = "install_tracked";
    private static final String PREFS_KEY_GDPR_FORGET_ME = "gdpr_forget_me";
    private static final String PREFS_KEY_DEEPLINK_URL = "deeplink_url";
    private static final String PREFS_KEY_DEEPLINK_REFERRER = "deeplink_referrer";
    private static final String PREFS_KEY_DEEPLINK_CLICK_TIME = "deeplink_click_time";
    private static final String PREFS_KEY_DEEPLINK_URL_CACHED = "deeplink_url_cached";
    private static final String PREFS_KEY_PREINSTALL_PAYLOAD_READ_STATUS = "preinstall_payload_read_status";
    private static final String PREFS_KEY_PREINSTALL_SYSTEM_INSTALLER_REFERRER = "preinstall_system_installer_referrer";
    private static final String PREFS_KEY_CONTROL_PARAMS = "control_params";
    private static final int INDEX_RAW_REFERRER = 0;
    private static final int INDEX_CLICK_TIME = 1;
    private static final int INDEX_IS_SENDING = 2;
    private static final int REFERRERS_COUNT = 10;
    private static SharedPreferences sharedPreferences;
    private static SharedPreferences.Editor sharedPreferencesEditor;
    private static SharedPreferencesManager defaultInstance;

    private SharedPreferencesManager(Context objectArray) {
        try {
            sharedPreferences = objectArray.getSharedPreferences(PREFS_NAME, 0);
            sharedPreferencesEditor = sharedPreferences.edit();
            return;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = string;
            AdjustFactory.getLogger().error("Cannot access to SharedPreferences", objectArray);
            sharedPreferences = null;
            sharedPreferencesEditor = null;
            return;
        }
    }

    public static synchronized SharedPreferencesManager getDefaultInstance(Context context) {
        if (defaultInstance == null) {
            defaultInstance = new SharedPreferencesManager(context);
        }
        return defaultInstance;
    }

    private synchronized int getRawReferrerIndex(String string, long l) {
        SharedPreferencesManager sharedPreferencesManager = sharedPreferencesManager.getRawReferrerArray();
        int n = 0;
        while (true) {
            block9: {
                try {
                    if (n >= sharedPreferencesManager.length()) break;
                }
                catch (JSONException jSONException) {}
                JSONArray jSONArray = sharedPreferencesManager.getJSONArray(n);
                String string2 = jSONArray.optString(0, null);
                if (string2 == null) break block9;
                if (!string2.equals(string)) break block9;
                if (jSONArray.optLong(1, -1L) == l) {
                    return n;
                }
                break;
            }
            ++n;
        }
        return -1;
    }

    private synchronized void saveString(String string, String string2) {
        SharedPreferencesManager sharedPreferencesManager = sharedPreferencesEditor;
        if (sharedPreferencesManager != null) {
            sharedPreferencesManager.putString(string, string2).apply();
            return;
        }
    }

    private synchronized void saveBoolean(String string, boolean bl) {
        SharedPreferencesManager sharedPreferencesManager = sharedPreferencesEditor;
        if (sharedPreferencesManager != null) {
            sharedPreferencesManager.putBoolean(string, bl).apply();
            return;
        }
    }

    private synchronized void saveLong(String string, long l) {
        SharedPreferencesManager sharedPreferencesManager = sharedPreferencesEditor;
        if (sharedPreferencesManager != null) {
            sharedPreferencesManager.putLong(string, l).apply();
            return;
        }
    }

    private synchronized void saveInteger(String string, int n) {
        SharedPreferencesManager sharedPreferencesManager = sharedPreferencesEditor;
        if (sharedPreferencesManager != null) {
            sharedPreferencesManager.putInt(string, n).apply();
            return;
        }
    }

    private synchronized String getString(String string) {
        SharedPreferences sharedPreferences = SharedPreferencesManager.sharedPreferences;
        if (sharedPreferences != null) {
            try {
                return sharedPreferences.getString(string, null);
            }
            catch (Throwable throwable) {
                if (string.equals(PREFS_KEY_RAW_REFERRERS)) {
                    this.remove(PREFS_KEY_RAW_REFERRERS);
                }
                return null;
            }
            catch (ClassCastException classCastException) {
                return null;
            }
        }
        return null;
    }

    private synchronized boolean getBoolean(String string, boolean bl) {
        SharedPreferencesManager sharedPreferencesManager = sharedPreferences;
        if (sharedPreferencesManager != null) {
            try {
                return sharedPreferencesManager.getBoolean(string, bl);
            }
            catch (ClassCastException classCastException) {}
        }
        return bl;
    }

    private synchronized long getLong(String string, long l) {
        SharedPreferencesManager sharedPreferencesManager = sharedPreferences;
        if (sharedPreferencesManager != null) {
            try {
                return sharedPreferencesManager.getLong(string, l);
            }
            catch (ClassCastException classCastException) {}
        }
        return l;
    }

    private synchronized void remove(String string) {
        SharedPreferencesManager sharedPreferencesManager = sharedPreferencesEditor;
        if (sharedPreferencesManager != null) {
            sharedPreferencesManager.remove(string).apply();
            return;
        }
    }

    public synchronized void saveRawReferrer(String string, long l) {
        block10: {
            JSONArray jSONArray;
            try {
                if (sharedPreferencesManager2.getRawReferrer(string, l) != null) break block10;
            }
            catch (JSONException jSONException) {}
            JSONArray jSONArray2 = sharedPreferencesManager2.getRawReferrerArray();
            if (jSONArray2.length() == 10) break block10;
            SharedPreferencesManager sharedPreferencesManager = sharedPreferencesManager2;
            JSONArray jSONArray3 = jSONArray2;
            SharedPreferencesManager sharedPreferencesManager2 = jSONArray;
            new JSONArray().put(0, (Object)string);
            sharedPreferencesManager2.put(1, l);
            sharedPreferencesManager2.put(2, 0);
            jSONArray3.put((Object)sharedPreferencesManager2);
            sharedPreferencesManager.saveRawReferrerArray(jSONArray2);
            return;
        }
    }

    public synchronized void saveRawReferrerArray(JSONArray object) {
        JSONArray jSONArray;
        SharedPreferencesManager sharedPreferencesManager;
        try {
            sharedPreferencesManager = this;
            jSONArray = object;
            object = PREFS_KEY_RAW_REFERRERS;
        }
        catch (Throwable throwable) {
            this.remove(PREFS_KEY_RAW_REFERRERS);
            return;
        }
        sharedPreferencesManager.saveString((String)object, jSONArray.toString());
    }

    public synchronized void removeRawReferrer(String string, long l) {
        int n;
        if (string != null && string.length() != 0 && (n = this.getRawReferrerIndex(string, l)) >= 0) {
            JSONArray jSONArray;
            JSONArray jSONArray2 = this.getRawReferrerArray();
            JSONArray jSONArray3 = jSONArray;
            jSONArray = new JSONArray();
            for (int i = 0; i < jSONArray2.length(); ++i) {
                if (i == n) continue;
                try {
                    jSONArray3.put((Object)jSONArray2.getJSONArray(i));
                }
                catch (JSONException jSONException) {}
            }
            this.saveString(PREFS_KEY_RAW_REFERRERS, jSONArray3.toString());
            return;
        }
    }

    public synchronized JSONArray getRawReferrer(String string, long l) {
        int n = this.getRawReferrerIndex(string, l);
        if (n >= 0) {
            try {
                return this.getRawReferrerArray().getJSONArray(n);
            }
            catch (JSONException jSONException) {}
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public synchronized JSONArray getRawReferrerArray() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [11, 10 : 69->85)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized void savePreinstallReferrer(String string) {
        this.saveString(PREFS_KEY_PREINSTALL_SYSTEM_INSTALLER_REFERRER, string);
    }

    public synchronized String getPreinstallReferrer() {
        return this.getString(PREFS_KEY_PREINSTALL_SYSTEM_INSTALLER_REFERRER);
    }

    public synchronized void removePreinstallReferrer() {
        this.remove(PREFS_KEY_PREINSTALL_SYSTEM_INSTALLER_REFERRER);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void setSendingReferrersAsNotSent() {
        boolean bl;
        JSONArray jSONArray;
        try {
            jSONArray = this.getRawReferrerArray();
            bl = false;
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONArray jSONArray2 = jSONArray.getJSONArray(i);
                if (jSONArray2.optInt(2, -1) != 1) continue;
                jSONArray2.put(2, 0);
            }
        }
        catch (JSONException jSONException) {
            return;
        }
        {
            bl = true;
            continue;
        }
        if (!bl) return;
        this.saveRawReferrerArray(jSONArray);
    }

    public synchronized void savePushToken(String string) {
        this.saveString(PREFS_KEY_PUSH_TOKEN, string);
    }

    public synchronized String getPushToken() {
        return this.getString(PREFS_KEY_PUSH_TOKEN);
    }

    public synchronized void removePushToken() {
        this.remove(PREFS_KEY_PUSH_TOKEN);
    }

    public synchronized void setInstallTracked() {
        this.saveBoolean(PREFS_KEY_INSTALL_TRACKED, true);
    }

    public synchronized boolean getInstallTracked() {
        return this.getBoolean(PREFS_KEY_INSTALL_TRACKED, false);
    }

    public synchronized void setGdprForgetMe() {
        this.saveBoolean(PREFS_KEY_GDPR_FORGET_ME, true);
    }

    public synchronized boolean getGdprForgetMe() {
        return this.getBoolean(PREFS_KEY_GDPR_FORGET_ME, false);
    }

    public synchronized void removeGdprForgetMe() {
        this.remove(PREFS_KEY_GDPR_FORGET_ME);
    }

    public synchronized void saveDeeplink(AdjustDeeplink adjustDeeplink, long l) {
        Uri uri;
        if (adjustDeeplink != null && (uri = adjustDeeplink.url) != null) {
            SharedPreferencesManager sharedPreferencesManager = this;
            sharedPreferencesManager.saveString(PREFS_KEY_DEEPLINK_URL, uri.toString());
            sharedPreferencesManager.saveLong(PREFS_KEY_DEEPLINK_CLICK_TIME, l);
            adjustDeeplink = adjustDeeplink.referrer;
            if (adjustDeeplink != null) {
                this.saveString(PREFS_KEY_DEEPLINK_REFERRER, adjustDeeplink.toString());
                return;
            }
        }
    }

    public synchronized String getDeeplinkUrl() {
        return this.getString(PREFS_KEY_DEEPLINK_URL);
    }

    public synchronized String getDeeplinkReferrer() {
        return this.getString(PREFS_KEY_DEEPLINK_REFERRER);
    }

    public synchronized long getDeeplinkClickTime() {
        return this.getLong(PREFS_KEY_DEEPLINK_CLICK_TIME, -1L);
    }

    public synchronized void removeDeeplink() {
        SharedPreferencesManager sharedPreferencesManager = this;
        sharedPreferencesManager.remove(PREFS_KEY_DEEPLINK_URL);
        sharedPreferencesManager.remove(PREFS_KEY_DEEPLINK_REFERRER);
        sharedPreferencesManager.remove(PREFS_KEY_DEEPLINK_CLICK_TIME);
    }

    public synchronized void cacheDeeplink(Uri uri) {
        if (uri == null) {
            return;
        }
        this.saveString(PREFS_KEY_DEEPLINK_URL_CACHED, uri.toString());
    }

    public synchronized String getCachedDeeplink() {
        return this.getString(PREFS_KEY_DEEPLINK_URL_CACHED);
    }

    public synchronized void setPreinstallPayloadReadStatus(long l) {
        this.saveLong(PREFS_KEY_PREINSTALL_PAYLOAD_READ_STATUS, l);
    }

    public synchronized long getPreinstallPayloadReadStatus() {
        return this.getLong(PREFS_KEY_PREINSTALL_PAYLOAD_READ_STATUS, 0L);
    }

    public synchronized void saveControlParams(JSONObject jSONObject) {
        JSONObject jSONObject2;
        SharedPreferencesManager sharedPreferencesManager;
        try {
            sharedPreferencesManager = string;
            jSONObject2 = jSONObject;
            String string = PREFS_KEY_CONTROL_PARAMS;
        }
        catch (Throwable throwable) {
            return;
        }
        sharedPreferencesManager.saveString(string, jSONObject2.toString());
    }

    public synchronized JSONObject getControlParamsJson() {
        if ((this = ((SharedPreferencesManager)this).getString(PREFS_KEY_CONTROL_PARAMS)) != null) {
            try {
                return new JSONObject((String)this);
            }
            catch (Throwable throwable) {
            }
            catch (JSONException jSONException) {}
        }
        return null;
    }

    public synchronized void clear() {
        SharedPreferencesManager sharedPreferencesManager = sharedPreferencesEditor;
        if (sharedPreferencesManager != null) {
            sharedPreferencesManager.clear().apply();
            return;
        }
    }
}

