/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.InstallReferrerReadListener;
import com.adjust.sdk.ReferrerDetails;
import com.adjust.sdk.Reflection;
import com.adjust.sdk.Util;
import com.adjust.sdk.scheduler.SingleThreadCachedScheduler;
import com.adjust.sdk.scheduler.ThreadExecutor;
import com.adjust.sdk.scheduler.TimerOnce;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicBoolean;

public class InstallReferrer
implements InvocationHandler {
    private static final String PACKAGE_BASE_NAME = "com.android.installreferrer.";
    private static final int STATUS_SERVICE_DISCONNECTED = -1;
    private static final int STATUS_OK = 0;
    private static final int STATUS_SERVICE_UNAVAILABLE = 1;
    private static final int STATUS_FEATURE_NOT_SUPPORTED = 2;
    private static final int STATUS_DEVELOPER_ERROR = 3;
    private int retryWaitTime;
    private int retries;
    private final AtomicBoolean shouldTryToRead;
    private ILogger logger;
    private Object referrerClient;
    private Context context;
    private TimerOnce retryTimer;
    private final InstallReferrerReadListener referrerCallback;
    private ThreadExecutor executor;

    public InstallReferrer(Context context, InstallReferrerReadListener installReferrerReadListener) {
        InstallReferrer installReferrer = this;
        InstallReferrer installReferrer2 = this;
        this.retryWaitTime = 3000;
        this.logger = AdjustFactory.getLogger();
        installReferrer2.context = context;
        installReferrer2.shouldTryToRead = new AtomicBoolean(true);
        installReferrer2.retries = 0;
        installReferrer2.retryTimer = new TimerOnce(new Runnable(){

            @Override
            public final void run() {
                InstallReferrer.this.startConnection();
            }
        }, "InstallReferrer");
        installReferrer.referrerCallback = installReferrerReadListener;
        installReferrer.executor = new SingleThreadCachedScheduler("InstallReferrer");
    }

    private Object createInstallReferrerClient(Context context) {
        block6: {
            Object object;
            ClassNotFoundException classNotFoundException2;
            block5: {
                Object object2 = Reflection.invokeStaticMethod("com.android.installreferrer.api.InstallReferrerClient", "newBuilder", new Class[]{Context.class}, context);
                String string = "build";
                try {
                    return Reflection.invokeInstanceMethod(object2, string, null, new Object[0]);
                }
                catch (Exception exception) {
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    break block5;
                }
                Exception exception = exception;
                object = exception.getMessage();
                String string2 = exception.getClass().getCanonicalName();
                Object[] objectArray = new Object[2];
                Object[] objectArray2 = objectArray;
                objectArray[0] = object;
                objectArray[1] = string2;
                ((InstallReferrer)object).referrerCallback.onFail(Util.formatString("createInstallReferrerClient error (%s) from (%s)", objectArray2));
                break block6;
            }
            ClassNotFoundException classNotFoundException3 = classNotFoundException2;
            object = classNotFoundException3.getMessage();
            String string = classNotFoundException3.getClass().getCanonicalName();
            Object[] objectArray = new Object[2];
            Object[] objectArray3 = objectArray;
            objectArray[0] = object;
            objectArray[1] = string;
            ((InstallReferrer)object).referrerCallback.onFail(Util.formatString("InstallReferrer not integrated in project (%s) thrown by (%s)", objectArray3));
        }
        return null;
    }

    private Class getInstallReferrerStateListenerClass() {
        try {
            return Class.forName("com.android.installreferrer.api.InstallReferrerStateListener");
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            String string = exception2.getMessage();
            String string2 = exception2.getClass().getCanonicalName();
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string;
            objectArray[1] = string2;
            ((InstallReferrer)((Object)string)).referrerCallback.onFail(Util.formatString("getInstallReferrerStateListenerClass error (%s) from (%s)", objectArray2));
            return null;
        }
    }

    private Object createProxyInstallReferrerStateListener(Class clazz) {
        Object object;
        block3: {
            block4: {
                object = null;
                try {
                    object = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this);
                    break block3;
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    break block4;
                }
                this.referrerCallback.onFail("Null argument passed to InstallReferrer proxy");
                break block3;
            }
            this.referrerCallback.onFail("InstallReferrer proxy violating parameter restrictions");
        }
        return object;
    }

    private void startConnection(Class objectArray, Object objectArray2) {
        block8: {
            Object object;
            InvocationTargetException invocationTargetException2;
            block7: {
                Exception exception2;
                block6: {
                    Object object2 = ((InstallReferrer)object).referrerClient;
                    String string = "startConnection";
                    Class[] classArray = new Class[1];
                    Class[] classArray2 = classArray;
                    classArray[0] = objectArray;
                    Object[] objectArray3 = new Object[1];
                    objectArray = objectArray3;
                    try {
                        objectArray3[0] = objectArray2;
                        Reflection.invokeInstanceMethod(object2, string, classArray2, objectArray);
                    }
                    catch (Exception exception2) {
                        break block6;
                    }
                    catch (InvocationTargetException invocationTargetException2) {
                        break block7;
                    }
                    break block8;
                }
                Exception exception3 = exception2;
                object = exception3.getMessage();
                String string = exception3.getClass().getCanonicalName();
                Object[] objectArray4 = new Object[2];
                objectArray2 = objectArray4;
                objectArray4[0] = object;
                objectArray4[1] = string;
                ((InstallReferrer)object).referrerCallback.onFail(Util.formatString("startConnection error (%s) thrown by (%s)", objectArray2));
                break block8;
            }
            if (Util.hasRootCause(invocationTargetException2)) {
                object = Util.getRootCause(invocationTargetException2);
                Object[] objectArray5 = new Object[1];
                Object[] objectArray6 = objectArray5;
                objectArray5[0] = object;
                ((InstallReferrer)object).referrerCallback.onFail(Util.formatString("InstallReferrer encountered an InvocationTargetException %s", objectArray6));
            } else {
                ((InstallReferrer)object).referrerCallback.onFail("InstallReferrer encountered an InvocationTargetException");
            }
        }
    }

    private Object invokeI(Object object, Method objectArray, Object[] objectArray2) {
        Object[] objectArray3;
        if (objectArray == null) {
            objectArray3.referrerCallback.onFail("InstallReferrer invoke method null");
            return null;
        }
        object = objectArray.getName();
        if (object == null) {
            objectArray3.referrerCallback.onFail("InstallReferrer invoke method name null");
            return null;
        }
        Object[] objectArray4 = new Object[1];
        objectArray = objectArray4;
        objectArray4[0] = object;
        objectArray3.logger.debug("InstallReferrer invoke method name: %s", objectArray);
        if (objectArray2 == null) {
            objectArray3.logger.warn("InstallReferrer invoke args null", new Object[0]);
            objectArray2 = new Object[]{};
        }
        int n = objectArray2.length;
        for (int i = 0; i < n; ++i) {
            Object object2 = objectArray2[i];
            Object[] objectArray5 = new Object[1];
            Object[] objectArray6 = objectArray5;
            objectArray5[0] = object2;
            objectArray3.logger.debug("InstallReferrer invoke arg: %s", objectArray6);
        }
        if (((String)object).equals("onInstallReferrerSetupFinished")) {
            if (objectArray2.length != 1) {
                objectArray3 = objectArray2.length;
                Object[] objectArray7 = new Object[1];
                object = objectArray7;
                objectArray7[0] = objectArray3;
                objectArray3.referrerCallback.onFail(Util.formatString("InstallReferrer invoke onInstallReferrerSetupFinished args lenght not 1: %d", (Object[])object));
                return null;
            }
            object = objectArray2[0];
            if (!(object instanceof Integer)) {
                objectArray3.referrerCallback.onFail("InstallReferrer invoke onInstallReferrerSetupFinished arg not int");
                return null;
            }
            if ((object = (Integer)object) == null) {
                objectArray3.referrerCallback.onFail("InstallReferrer invoke onInstallReferrerSetupFinished responseCode arg is null");
                return null;
            }
            super.onInstallReferrerSetupFinishedIntI((Integer)object);
        } else if (((String)object).equals("onInstallReferrerServiceDisconnected")) {
            InstallReferrer installReferrer = objectArray3;
            installReferrer.logger.debug("Connection to install referrer service was lost. Retrying ...", new Object[0]);
            installReferrer.retryI("onInstallReferrerServiceDisconnected");
        } else {
            Object[] objectArray8 = new Object[1];
            objectArray3 = objectArray8;
            objectArray8[0] = object;
            objectArray3.referrerCallback.onFail(Util.formatString("Reflection call method name not expected: %s", objectArray3));
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private void onInstallReferrerSetupFinishedIntI(int var1_1) {
        block25: {
            block24: {
                switch (var1_1) {
                    default: {
                        var1_2 = var1_1;
                        v0 = new Object[1];
                        var2_6 = v0;
                        v0[0] = var1_2;
                        this.referrerCallback.onFail(Util.formatString("Unexpected response code of install referrer response: %d. Closing connection", var2_6));
                        ** GOTO lbl68
                    }
                    case 3: {
                        this.logger.debug("Install Referrer API general errors caused by incorrect usage. Retrying...", new Object[0]);
                        break block24;
                    }
                    case 2: {
                        this.referrerCallback.onFail("Install Referrer API not supported by the installed Play Store app. Closing connection");
                        ** GOTO lbl68
                    }
                    case 1: {
                        this.logger.debug("Could not initiate connection to the Install Referrer service. Retrying...", new Object[0]);
                        break block24;
                    }
                    case 0: {
                        try {
                            var1_3 = this.getInstallReferrer();
                        }
                        catch (Exception var1_4) {
                            var1_5 = var1_4.getMessage();
                            v1 = new Object[1];
                            var2_7 = v1;
                            v1[0] = var1_5;
                            this.logger.warn("Couldn't get install referrer from client (%s). Retrying...", var2_7);
                            break block24;
                        }
                        var2_7 = this.getStringInstallReferrer(var1_3);
                        var3_8 = this.getReferrerClickTimestampSeconds(var1_3);
                        var5_9 = this.getInstallBeginTimestampSeconds(var1_3);
                        v2 = this.logger;
                        v3 = var5_9;
                        v4 = var3_8;
                        var7_10 = "installReferrer: %s, clickTime: %d, installBeginTime: %d";
                        var8_11 = v4;
                        var9_13 = v3;
                        v2.debug(var7_10, new Object[]{var2_7, var8_11, var9_13});
                        var7_10 = this.getStringInstallVersion(var1_3);
                        var8_12 = this.getReferrerClickTimestampServerSeconds(var1_3);
                        var10_14 = this.getInstallBeginTimestampServerSeconds(var1_3);
                        var1_3 = this.getBooleanGooglePlayInstantParam(var1_3);
                        v5 = this.logger;
                        v6 = var10_14;
                        v7 = var8_12;
                        var12_15 = "installVersion: %s, clickTimeServer: %d, installBeginServer: %d, googlePlayInstant: %b";
                        var13_16 = v7;
                        var14_17 = v6;
                        v5.debug((String)var12_15, new Object[]{var7_10, var13_16, var14_17, var1_3});
                        this.logger.debug("Install Referrer read successfully. Closing connection", new Object[0]);
                        var12_15 = v8;
                        v8 = new ReferrerDetails((String)var2_7, var3_8, var5_9, var8_12, var10_14, var7_10, (Boolean)var1_3, null);
                        this.referrerCallback.onInstallReferrerRead((ReferrerDetails)var12_15, "google");
lbl68:
                        // 3 sources

                        this.shouldTryToRead.set(false);
                        this.closeReferrerClient();
                        break block25;
                    }
                    case -1: 
                }
                this.logger.debug("Play Store service is not connected now. Retrying...", new Object[0]);
            }
            this.retryI("end of onInstallReferrerSetupFinishedIntI");
        }
    }

    private Object getInstallReferrer() {
        String string;
        Object object;
        Object object2 = ((InstallReferrer)((Object)string2)).referrerClient;
        if (object2 == null) {
            return null;
        }
        try {
            object = object2;
            string = "getInstallReferrer";
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            String string2 = exception2.getMessage();
            String string3 = exception2.getClass().getCanonicalName();
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string2;
            objectArray[1] = string3;
            ((InstallReferrer)((Object)string2)).logger.error("getInstallReferrer error (%s) thrown by (%s)", objectArray2);
            return null;
        }
        return Reflection.invokeInstanceMethod(object, string, null, new Object[0]);
    }

    private String getStringInstallReferrer(Object object) {
        String string;
        Object object2;
        if (object == null) {
            return null;
        }
        try {
            object2 = object;
            string = "getInstallReferrer";
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            String string2 = exception2.getMessage();
            String string3 = exception2.getClass().getCanonicalName();
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string2;
            objectArray[1] = string3;
            ((InstallReferrer)((Object)string2)).logger.error("getStringInstallReferrer error (%s) thrown by (%s)", objectArray2);
            return null;
        }
        return (String)Reflection.invokeInstanceMethod(object2, string, null, new Object[0]);
    }

    private long getReferrerClickTimestampSeconds(Object object) {
        String string;
        Object object2;
        if (object == null) {
            return -1L;
        }
        try {
            object2 = object;
            string = "getReferrerClickTimestampSeconds";
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            String string2 = exception2.getMessage();
            String string3 = exception2.getClass().getCanonicalName();
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string2;
            objectArray[1] = string3;
            ((InstallReferrer)((Object)string2)).logger.error("getReferrerClickTimestampSeconds error (%s) thrown by (%s)", objectArray2);
            return -1L;
        }
        return (Long)Reflection.invokeInstanceMethod(object2, string, null, new Object[0]);
    }

    private long getInstallBeginTimestampSeconds(Object object) {
        String string;
        Object object2;
        if (object == null) {
            return -1L;
        }
        try {
            object2 = object;
            string = "getInstallBeginTimestampSeconds";
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            String string2 = exception2.getMessage();
            String string3 = exception2.getClass().getCanonicalName();
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string2;
            objectArray[1] = string3;
            ((InstallReferrer)((Object)string2)).logger.error("getInstallBeginTimestampSeconds error (%s) thrown by (%s)", objectArray2);
            return -1L;
        }
        return (Long)Reflection.invokeInstanceMethod(object2, string, null, new Object[0]);
    }

    private String getStringInstallVersion(Object object) {
        String string;
        Object object2;
        if (object == null) {
            return null;
        }
        try {
            object2 = object;
            string = "getInstallVersion";
        }
        catch (Exception exception) {
            return null;
        }
        return (String)Reflection.invokeInstanceMethod(object2, string, null, new Object[0]);
    }

    private long getReferrerClickTimestampServerSeconds(Object object) {
        String string;
        Object object2;
        if (object == null) {
            return -1L;
        }
        try {
            object2 = object;
            string = "getReferrerClickTimestampServerSeconds";
        }
        catch (Exception exception) {
            return -1L;
        }
        return (Long)Reflection.invokeInstanceMethod(object2, string, null, new Object[0]);
    }

    private long getInstallBeginTimestampServerSeconds(Object object) {
        String string;
        Object object2;
        if (object == null) {
            return -1L;
        }
        try {
            object2 = object;
            string = "getInstallBeginTimestampServerSeconds";
        }
        catch (Exception exception) {
            return -1L;
        }
        return (Long)Reflection.invokeInstanceMethod(object2, string, null, new Object[0]);
    }

    private Boolean getBooleanGooglePlayInstantParam(Object object) {
        String string;
        Object object2;
        if (object == null) {
            return null;
        }
        try {
            object2 = object;
            string = "getGooglePlayInstantParam";
        }
        catch (Exception exception) {
            return null;
        }
        Boolean bl = (Boolean)Reflection.invokeInstanceMethod(object2, string, null, new Object[0]);
        Boolean bl2 = bl;
        bl.booleanValue();
        return bl2;
    }

    private void retryI(String objectArray) {
        int n;
        Object object;
        if (!object.shouldTryToRead.get()) {
            Object[] objectArray2 = new Object[1];
            object = objectArray2;
            objectArray2[0] = objectArray;
            object.referrerCallback.onFail(Util.formatString("Should not try to read Install referrer from %s", object));
            super.closeReferrerClient();
            return;
        }
        if (object.retries + 1 > 2) {
            object = 2;
            Object[] objectArray3 = new Object[2];
            Object[] objectArray4 = objectArray3;
            objectArray3[0] = object;
            objectArray3[1] = objectArray;
            object.referrerCallback.onFail(Util.formatString("Limit number of retry of %d for install referrer surpassed from %s", objectArray4));
            return;
        }
        long l = object.retryTimer.getFireIn();
        if (l > 0L) {
            object = l;
            Object[] objectArray5 = new Object[1];
            objectArray = objectArray5;
            objectArray5[0] = object;
            object.logger.debug("Already waiting to retry to read install referrer in %d milliseconds", objectArray);
            return;
        }
        object.retries = n = object.retries + 1;
        Integer n2 = n;
        Object[] objectArray6 = new Object[1];
        Object[] objectArray7 = objectArray6;
        objectArray6[0] = n2;
        object.logger.debug("Retry number %d to connect to install referrer API", objectArray7);
        object.retryTimer.startIn(object.retryWaitTime);
    }

    private void closeReferrerClient() {
        Object object = this.referrerClient;
        if (object == null) {
            return;
        }
        InstallReferrer installReferrer = this;
        Object object2 = object;
        String string = "endConnection";
        Reflection.invokeInstanceMethod(object2, string, null, new Object[0]);
        try {
            installReferrer.logger.debug("Install Referrer API connection closed", new Object[0]);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            String string2 = exception2.getMessage();
            String string3 = exception2.getClass().getCanonicalName();
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string2;
            objectArray[1] = string3;
            this.logger.error("closeReferrerClient error (%s) thrown by (%s)", objectArray2);
        }
        this.referrerClient = null;
    }

    public void startConnection() {
        if (!AdjustFactory.getTryInstallReferrer()) {
            this.referrerCallback.onFail("Sdk has been configured to not try install referrer");
            return;
        }
        InstallReferrer installReferrer = this;
        installReferrer.closeReferrerClient();
        if (!installReferrer.shouldTryToRead.get()) {
            this.referrerCallback.onFail("Should not try to read the install referrer any longer");
            return;
        }
        Object object = this.context;
        if (object == null) {
            this.referrerCallback.onFail("Requires context to read the install referrer");
            return;
        }
        this.referrerClient = this.createInstallReferrerClient((Context)object);
        if (this.referrerClient == null) {
            return;
        }
        object = this.getInstallReferrerStateListenerClass();
        if (object == null) {
            return;
        }
        Object object2 = this.createProxyInstallReferrerStateListener((Class)object);
        if (object2 == null) {
            return;
        }
        this.startConnection((Class)object, object2);
    }

    @Override
    public Object invoke(final Object object, final Method method, final Object[] objectArray) {
        this.executor.submit(new Runnable(){

            @Override
            public final void run() {
                InstallReferrer installReferrer = string.InstallReferrer.this;
                2 v1 = string;
                2 v2 = v1;
                2 v3 = v1;
                Object object2 = v1.object;
                Object[] objectArray4 = v3.method;
                Object[] objectArray2 = v2.objectArray;
                try {
                    installReferrer.invokeI(object2, (Method)objectArray4, objectArray2);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    String string = throwable2.getMessage();
                    String string2 = throwable2.getClass().getCanonicalName();
                    Object[] objectArray3 = new Object[2];
                    objectArray4 = objectArray3;
                    objectArray3[0] = string;
                    objectArray3[1] = string2;
                    string.InstallReferrer.this.referrerCallback.onFail(Util.formatString("invoke error (%s) thrown by (%s)", objectArray4));
                }
            }
        });
        return null;
    }
}

