/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import com.adjust.sdk.ActivityHandler;
import com.adjust.sdk.ActivityPackage;
import com.adjust.sdk.ActivityState;
import com.adjust.sdk.AdjustConfig;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.BackoffStrategy;
import com.adjust.sdk.DeviceInfo;
import com.adjust.sdk.GlobalParameters;
import com.adjust.sdk.IActivityHandler;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.ISdkClickHandler;
import com.adjust.sdk.PackageBuilder;
import com.adjust.sdk.PackageFactory;
import com.adjust.sdk.PreinstallUtil;
import com.adjust.sdk.ResponseData;
import com.adjust.sdk.SdkClickResponseData;
import com.adjust.sdk.SharedPreferencesManager;
import com.adjust.sdk.TrackingState;
import com.adjust.sdk.Util;
import com.adjust.sdk.network.IActivityPackageSender;
import com.adjust.sdk.scheduler.SingleThreadCachedScheduler;
import com.adjust.sdk.scheduler.ThreadScheduler;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;

public class SdkClickHandler
implements ISdkClickHandler {
    private static final double MILLISECONDS_TO_SECONDS_DIVISOR = 1000.0;
    private static final String SCHEDULED_EXECUTOR_SOURCE = "SdkClickHandler";
    private static final String SOURCE_REFTAG = "reftag";
    private static final String SOURCE_INSTALL_REFERRER = "install_referrer";
    private boolean paused;
    private ILogger logger;
    private BackoffStrategy backoffStrategy;
    private List<ActivityPackage> packageQueue;
    private ThreadScheduler scheduler;
    private WeakReference<IActivityHandler> activityHandlerWeakRef;
    private IActivityPackageSender activityPackageSender;
    private long lastPackageRetryInMilli = 0L;

    public SdkClickHandler(IActivityHandler iActivityHandler, boolean bl, IActivityPackageSender iActivityPackageSender) {
        this.init(iActivityHandler, bl, iActivityPackageSender);
        this.logger = AdjustFactory.getLogger();
        this.backoffStrategy = AdjustFactory.getSdkClickBackoffStrategy();
        this.scheduler = new SingleThreadCachedScheduler(SCHEDULED_EXECUTOR_SOURCE);
    }

    private void sendNextSdkClick() {
        this.scheduler.submit(new Runnable(){

            @Override
            public final void run() {
                SdkClickHandler.this.sendNextSdkClickI();
            }
        });
    }

    private void sendNextSdkClickI() {
        Runnable runnable;
        Object object = (IActivityHandler)this.activityHandlerWeakRef.get();
        if (object.getActivityState() == null) {
            return;
        }
        if (object.getActivityState().isGdprForgotten) {
            return;
        }
        if (this.paused) {
            return;
        }
        if (this.packageQueue.isEmpty()) {
            return;
        }
        SdkClickHandler sdkClickHandler = this;
        object = sdkClickHandler.packageQueue.remove(0);
        Runnable runnable2 = runnable;
        runnable = new Runnable((ActivityPackage)object){
            public final /* synthetic */ ActivityPackage a;
            {
                this.a = activityPackage;
            }

            @Override
            public final void run() {
                5 v0 = this;
                v0.SdkClickHandler.this.sendSdkClickI(this.a);
                v0.SdkClickHandler.this.sendNextSdkClick();
            }
        };
        long l = sdkClickHandler.waitTime(((ActivityPackage)object).getRetries());
        if (l > 0L) {
            this.scheduler.schedule(runnable2, l);
        } else {
            runnable2.run();
        }
    }

    private void sendSdkClickI(ActivityPackage object) {
        IActivityHandler iActivityHandler = (IActivityHandler)((SdkClickHandler)this).activityHandlerWeakRef.get();
        String string = ((ActivityPackage)object).getParameters().get("source");
        boolean bl = string != null && string.equals(SOURCE_REFTAG);
        String string2 = ((ActivityPackage)object).getParameters().get("raw_referrer");
        if (bl && SharedPreferencesManager.getDefaultInstance(iActivityHandler.getContext()).getRawReferrer(string2, ((ActivityPackage)object).getClickTimeInMilliseconds()) == null) {
            return;
        }
        boolean bl2 = string != null && string.equals(SOURCE_INSTALL_REFERRER);
        long l = -1L;
        long l2 = -1L;
        String string3 = null;
        long l3 = -1L;
        long l4 = -1L;
        String string4 = null;
        Boolean bl3 = null;
        Boolean bl4 = null;
        String string5 = null;
        if (bl2) {
            ActivityPackage activityPackage = object;
            l = activityPackage.getClickTimeInSeconds();
            l2 = activityPackage.getInstallBeginTimeInSeconds();
            string3 = activityPackage.getParameters().get("referrer");
            l3 = activityPackage.getClickTimeServerInSeconds();
            l4 = activityPackage.getInstallBeginTimeServerInSeconds();
            string4 = activityPackage.getInstallVersion();
            bl3 = activityPackage.getGooglePlayInstant();
            bl4 = activityPackage.getIsClick();
            string5 = activityPackage.getParameters().get("referrer_api");
        }
        boolean bl5 = string != null && string.equals("preinstall");
        SdkClickHandler sdkClickHandler = this;
        Object object2 = sdkClickHandler.generateSendingParametersI();
        if (!((object2 = sdkClickHandler.activityPackageSender.sendActivityPackageSync((ActivityPackage)object, (Map<String, String>)object2)) instanceof SdkClickResponseData)) {
            return;
        }
        object2 = (SdkClickResponseData)object2;
        if (((ResponseData)object2).willRetry) {
            ((SdkClickHandler)this).retrySendingI((ActivityPackage)object, ((ResponseData)object2).retryIn);
            return;
        }
        ((SdkClickHandler)this).lastPackageRetryInMilli = 0L;
        if (iActivityHandler == null) {
            return;
        }
        if (((ResponseData)object2).trackingState == TrackingState.OPTED_OUT) {
            iActivityHandler.gotOptOutResponse();
            return;
        }
        if (bl) {
            SharedPreferencesManager.getDefaultInstance(iActivityHandler.getContext()).removeRawReferrer(string2, ((ActivityPackage)object).getClickTimeInMilliseconds());
        }
        if (bl2) {
            Object object3 = object2;
            ((SdkClickResponseData)object3).clickTime = l;
            ((SdkClickResponseData)object3).installBegin = l2;
            ((SdkClickResponseData)object3).installReferrer = string3;
            ((SdkClickResponseData)object3).clickTimeServer = l3;
            ((SdkClickResponseData)object3).installBeginServer = l4;
            ((SdkClickResponseData)object3).installVersion = string4;
            ((SdkClickResponseData)object3).googlePlayInstant = bl3;
            ((SdkClickResponseData)object3).isClick = bl4;
            ((SdkClickResponseData)object3).referrerApi = string5;
            ((SdkClickResponseData)object3).isInstallReferrer = true;
        }
        if (bl5 && (this = ((ActivityPackage)object).getParameters().get("found_location")) != null && !((String)this).isEmpty()) {
            object = SharedPreferencesManager.getDefaultInstance(iActivityHandler.getContext());
            if ("system_installer_referrer".equalsIgnoreCase((String)this)) {
                ((SharedPreferencesManager)object).removePreinstallReferrer();
            } else {
                ((SharedPreferencesManager)object).setPreinstallPayloadReadStatus(PreinstallUtil.markAsRead((String)this, ((SharedPreferencesManager)object).getPreinstallPayloadReadStatus()));
            }
        }
        iActivityHandler.finishedTrackingActivity((ResponseData)object2);
    }

    private Map<String, String> generateSendingParametersI() {
        HashMap hashMap;
        SdkClickHandler sdkClickHandler = hashMap2;
        HashMap hashMap2 = hashMap;
        hashMap = new HashMap();
        int n = sdkClickHandler.packageQueue.size() - 1;
        if (n > 0) {
            long l = n;
            PackageBuilder.addLong(hashMap2, "queue_size", l);
        }
        return hashMap2;
    }

    private void retrySendingI(ActivityPackage activityPackage, Long l) {
        if (l != null && l > 0L) {
            this.lastPackageRetryInMilli = l;
        } else {
            int n = activityPackage.increaseRetries();
            Integer n2 = n;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = n2;
            this.logger.error("Retrying sdk_click package for the %d time", objectArray2);
        }
        this.sendSdkClick(activityPackage);
    }

    private void logErrorMessageI(ActivityPackage object, String objectArray, Throwable throwable) {
        SdkClickHandler sdkClickHandler = object2;
        Object object2 = ((ActivityPackage)object).getFailureMessage();
        object = Util.getReasonString((String)objectArray, throwable);
        Object[] objectArray2 = new Object[2];
        objectArray = objectArray2;
        objectArray2[0] = object2;
        objectArray2[1] = object;
        object2 = Util.formatString("%s. (%s)", objectArray);
        sdkClickHandler.logger.error((String)object2, new Object[0]);
    }

    private long waitTime(int n) {
        long l = ((SdkClickHandler)((Object)string)).lastPackageRetryInMilli;
        if (l > 0L) {
            return l;
        }
        if (n > 0) {
            l = Util.getWaitingTime(n, ((SdkClickHandler)((Object)string)).backoffStrategy);
            SdkClickHandler sdkClickHandler = string;
            double d = (double)l / 1000.0;
            String string = Util.SecondsDisplayFormat.format(d);
            Integer n2 = n;
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string;
            objectArray[1] = n2;
            sdkClickHandler.logger.verbose("Waiting for %s seconds before retrying sdk_click for the %d time", objectArray2);
            return l;
        }
        return 0L;
    }

    @Override
    public void init(IActivityHandler iActivityHandler, boolean bl, IActivityPackageSender iActivityPackageSender) {
        SdkClickHandler sdkClickHandler = this;
        sdkClickHandler.paused = bl ^ true;
        sdkClickHandler.packageQueue = new ArrayList<ActivityPackage>();
        sdkClickHandler.activityHandlerWeakRef = new WeakReference<IActivityHandler>(iActivityHandler);
        this.activityPackageSender = iActivityPackageSender;
    }

    @Override
    public void pauseSending() {
        this.paused = true;
    }

    @Override
    public void resumeSending() {
        this.paused = false;
        this.sendNextSdkClick();
    }

    @Override
    public void sendSdkClick(final ActivityPackage activityPackage) {
        this.scheduler.submit(new Runnable(){

            @Override
            public final void run() {
                1 v0 = string;
                v0.SdkClickHandler.this.packageQueue.add(string.activityPackage);
                Object[] objectArray = Integer.valueOf(string.SdkClickHandler.this.packageQueue.size());
                Object[] objectArray2 = new Object[1];
                Object[] objectArray3 = objectArray2;
                objectArray2[0] = objectArray;
                v0.SdkClickHandler.this.logger.debug("Added sdk_click %d", objectArray3);
                String string = string.activityPackage.getExtendedString();
                Object[] objectArray4 = new Object[1];
                objectArray = objectArray4;
                objectArray4[0] = string;
                v0.SdkClickHandler.this.logger.verbose("%s", objectArray);
                v0.SdkClickHandler.this.sendNextSdkClick();
            }
        });
    }

    @Override
    public void sendReftagReferrers() {
        this.scheduler.submit(new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public final void run() {
                long l;
                IActivityHandler iActivityHandler;
                IActivityHandler iActivityHandler2;
                IActivityHandler iActivityHandler3;
                IActivityHandler iActivityHandler4;
                IActivityHandler iActivityHandler5;
                String string;
                String string2;
                Object object;
                boolean bl;
                JSONArray jSONArray;
                IActivityHandler iActivityHandler6 = (IActivityHandler)string3.SdkClickHandler.this.activityHandlerWeakRef.get();
                SharedPreferencesManager sharedPreferencesManager = SharedPreferencesManager.getDefaultInstance(iActivityHandler6.getContext());
                try {
                    jSONArray = sharedPreferencesManager.getRawReferrerArray();
                    bl = false;
                    for (int i = 0; i < jSONArray.length(); ++i) {
                        object = jSONArray.getJSONArray(i);
                        if (object.optInt(2, -1) != 0) continue;
                        string2 = string3;
                        string = object.optString(0, null);
                        IActivityHandler iActivityHandler7 = iActivityHandler6;
                        iActivityHandler5 = iActivityHandler7;
                        iActivityHandler4 = iActivityHandler7;
                        iActivityHandler3 = iActivityHandler7;
                        iActivityHandler2 = iActivityHandler7;
                        iActivityHandler = iActivityHandler7;
                        JSONArray jSONArray2 = object;
                        l = jSONArray2.optLong(1, -1L);
                        jSONArray2.put(2, 1);
                    }
                }
                catch (JSONException jSONException) {}
                {
                    bl = true;
                    ActivityState activityState = iActivityHandler4.getActivityState();
                    AdjustConfig adjustConfig = iActivityHandler3.getAdjustConfig();
                    DeviceInfo deviceInfo = iActivityHandler2.getDeviceInfo();
                    GlobalParameters globalParameters = iActivityHandler.getGlobalParameters();
                    ActivityHandler.InternalState internalState = iActivityHandler5.getInternalState();
                    object = PackageFactory.buildReftagSdkClickPackage(string, l, activityState, adjustConfig, deviceInfo, globalParameters, internalState);
                    string2.SdkClickHandler.this.sendSdkClick((ActivityPackage)object);
                    continue;
                }
                if (!bl) return;
                sharedPreferencesManager.saveRawReferrerArray(jSONArray);
                return;
                String string3 = jSONException.getMessage();
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = string3;
                string3.SdkClickHandler.this.logger.error("Send saved raw referrers error (%s)", objectArray2);
            }
        });
    }

    @Override
    public void sendPreinstallPayload(final String string, final String string2) {
        this.scheduler.submit(new Runnable(){

            @Override
            public final void run() {
                Object object = (IActivityHandler)object2.SdkClickHandler.this.activityHandlerWeakRef.get();
                if (object == null) {
                    return;
                }
                3 v0 = object2;
                IActivityHandler iActivityHandler = object;
                Object object2 = object2.string2;
                object = iActivityHandler.getActivityState();
                AdjustConfig adjustConfig = iActivityHandler.getAdjustConfig();
                DeviceInfo deviceInfo = iActivityHandler.getDeviceInfo();
                GlobalParameters globalParameters = iActivityHandler.getGlobalParameters();
                object2 = PackageFactory.buildPreinstallSdkClickPackage(v0.string, (String)object2, (ActivityState)object, adjustConfig, deviceInfo, globalParameters);
                v0.SdkClickHandler.this.sendSdkClick((ActivityPackage)object2);
            }
        });
    }

    @Override
    public void teardown() {
        SdkClickHandler sdkClickHandler = this;
        sdkClickHandler.logger.verbose("SdkClickHandler teardown", new Object[0]);
        WeakReference<IActivityHandler> weakReference = sdkClickHandler.scheduler;
        if (weakReference != null) {
            weakReference.teardown();
        }
        if ((weakReference = this.packageQueue) != null) {
            weakReference.clear();
        }
        if ((weakReference = this.activityHandlerWeakRef) != null) {
            weakReference.clear();
        }
        SdkClickHandler sdkClickHandler2 = this;
        sdkClickHandler2.logger = null;
        sdkClickHandler2.packageQueue = null;
        sdkClickHandler2.backoffStrategy = null;
        sdkClickHandler2.scheduler = null;
    }
}

