/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.plugins.GooglePlayServices;

import android.content.Context;
import android.content.Intent;
import com.ad4screen.sdk.Log;
import com.ad4screen.sdk.plugins.GCMPlugin;
import com.ad4screen.sdk.plugins.GooglePlayServices.common.Utils;
import com.google.android.gms.iid.InstanceID;
import java.io.IOException;

public class GCM
implements GCMPlugin {
    private static final int PLUGIN_VERSION = 2;
    private static final String INSTANCE_ID_SCOPE_GCM = "GCM";
    private String mRegistrationId;

    public int getPluginVersion() {
        return 2;
    }

    public String register(Context context, String senderId) {
        try {
            if (Utils.checkPlayServices((Context)context)) {
                this.mRegistrationId = InstanceID.getInstance((Context)context).getToken(senderId, INSTANCE_ID_SCOPE_GCM);
            }
        }
        catch (Exception e) {
            Log.error((String)"Plugin|Error occured when registering to GCM", (Throwable)e);
        }
        catch (Error e) {
            Log.error((String)"Plugin|Error occured when registering to GCM", (Throwable)e);
        }
        return this.mRegistrationId;
    }

    public boolean unregister(Context context, String senderId) {
        try {
            if (Utils.checkPlayServices((Context)context)) {
                InstanceID.getInstance((Context)context).deleteToken(senderId, INSTANCE_ID_SCOPE_GCM);
                this.sendGcmUnregistrationBroadcast(context);
                return true;
            }
        }
        catch (IOException e) {
            Log.error((String)"Plugin|Exception occured when unregistering to GCM", (Throwable)e);
        }
        catch (Error e) {
            Log.error((String)"Plugin|Error occured when unregistering to GCM", (Throwable)e);
        }
        return false;
    }

    private void sendGcmUnregistrationBroadcast(Context context) {
        Intent intent = new Intent("com.google.android.c2dm.intent.REGISTRATION");
        intent.setPackage(context.getPackageName());
        intent.putExtra("unregistered", context.getPackageName());
        context.sendBroadcast(intent);
    }
}

