/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.plugins.GooglePlayServices;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import com.ad4screen.sdk.A4S;
import com.ad4screen.sdk.A4SService;
import com.ad4screen.sdk.Log;
import com.ad4screen.sdk.plugins.GooglePlayServices.common.Utils;
import com.ad4screen.sdk.plugins.LocationPlugin;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;

public class Location
implements LocationPlugin,
GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
LocationListener {
    private static final int PLUGIN_VERSION = 1;
    private static final String METADATA_LOCATION_PRIORITY = "com.ad4screen.location.priority";
    private static final int DEFAULT_BACKOFF_MS = 3000;
    private static final int MAX_BACKOFF_MS = 3600000;
    private int mCurrentBackoff = 3000;
    private GoogleApiClient mLocationClient;
    private boolean started = false;
    private android.location.Location mCurrentLocation;
    LocationRequest mLocationRequest;
    private long mUpdateInterval;
    private long mFastestInterval;
    private A4S.Callback<android.location.Location> mCallback;
    private Context mContext;

    public int getPluginVersion() {
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean connect(Context object, long l, long l2, A4S.Callback<android.location.Location> callback) {
        this.mContext = object;
        this.mUpdateInterval = l;
        this.mFastestInterval = l2;
        this.mCallback = callback;
        if (this.mLocationClient != null && this.started) {
            return true;
        }
        try {
            if (!Utils.checkPlayServices((Context)this.mContext)) return false;
            this.mLocationRequest = LocationRequest.create();
            if ((object = Utils.loadServiceMetadata((Context)object, (String)METADATA_LOCATION_PRIORITY, A4SService.class)) != null) {
                if (((String)object).equals("normal")) {
                    this.mLocationRequest.setPriority(102);
                }
                if (((String)object).equals("high")) {
                    this.mLocationRequest.setPriority(100);
                }
                if (((String)object).equals("low")) {
                    this.mLocationRequest.setPriority(104);
                }
                if (((String)object).equals("none")) {
                    this.mLocationRequest.setPriority(105);
                }
            } else {
                this.mLocationRequest.setPriority(102);
            }
            Location location = this;
            location.mLocationRequest.setInterval(this.mUpdateInterval);
            location.mLocationRequest.setFastestInterval(this.mFastestInterval);
            location.mLocationClient = new GoogleApiClient.Builder(this.mContext).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).addApi(LocationServices.API).build();
            location.mLocationClient.connect();
            location.started = true;
            return true;
        }
        catch (Error error) {
            Log.error((String)"Location Plugin|Error occured when connecting to Google Play Services Location Client", (Throwable)error);
            return false;
        }
        catch (Exception exception) {
            Log.error((String)"Location Plugin|Error occured when connecting to Google Play Services Location Client", (Throwable)exception);
        }
        return false;
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        Log.error((String)("Location Plugin|Can't connect to Google Play Services Location Service. Connection Result : " + connectionResult.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onConnected(Bundle bundle) {
        try {
            Log.debug((String)"Location Plugin|Location client connected");
            this.mCurrentBackoff = 3000;
            this.mCurrentLocation = LocationServices.FusedLocationApi.getLastLocation(this.mLocationClient);
            if (this.mCallback != null) {
                this.mCallback.onResult((Object)this.mCurrentLocation);
            }
            LocationServices.FusedLocationApi.requestLocationUpdates(this.mLocationClient, this.mLocationRequest, (LocationListener)this);
            return;
        }
        catch (SecurityException securityException) {
            Log.debug((String)"LOCATION permission denied", (Throwable)securityException);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            Log.debug((String)"Location Plugin|Location client error, reconnecting", (Throwable)illegalStateException);
            this.mLocationClient.connect();
        }
    }

    public void onConnectionSuspended(int n) {
        if (!this.started) {
            return;
        }
        Location location = this;
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (!Location.this.started) {
                    return;
                }
                Location location = Location.this;
                location.connect(location.mContext, Location.this.mUpdateInterval, Location.this.mFastestInterval, (A4S.Callback<android.location.Location>)Location.this.mCallback);
            }
        }, (long)this.mCurrentBackoff);
        location.mCurrentBackoff *= 2;
        if (location.mCurrentBackoff > 3600000) {
            this.mCurrentBackoff = 3600000;
        }
    }

    public void disconnect() {
        block5: {
            if (this.mLocationClient == null) break block5;
            if (!this.mLocationClient.isConnected()) break block5;
            this.started = false;
            LocationServices.FusedLocationApi.removeLocationUpdates(this.mLocationClient, (LocationListener)this);
            this.mLocationClient.disconnect();
            try {
                Log.debug((String)"Location Plugin|Location client disconnected");
            }
            catch (SecurityException securityException) {
                Log.debug((String)"LOCATION permission denied", (Throwable)securityException);
            }
        }
    }

    public void onLocationChanged(android.location.Location callback) {
        this.mCurrentLocation = callback;
        callback = this.mCallback;
        if (callback != null) {
            callback.onResult((Object)this.mCurrentLocation);
        }
    }
}

