/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.plugins.GooglePlayServices.common;

import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import com.ad4screen.sdk.Log;
import com.google.android.gms.common.GooglePlayServicesUtil;

public class Utils {
    public static boolean checkPlayServices(Context context) {
        try {
            return GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)context) == 0;
        }
        catch (Exception exception) {
            Log.error((String)"Plugin|Error while checking Google Play Services", (Throwable)exception);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Log.error((String)"Plugin|GooglePlayServices not found. Please add GooglePlayServices Library to your app", (Throwable)noClassDefFoundError);
        }
        return false;
    }

    public static boolean isServiceDeclared(Context context, Class<? extends Service> clazz) {
        if (context == null) {
            return false;
        }
        context = context.getApplicationContext();
        try {
            context.getPackageManager().getServiceInfo(new ComponentName(context, clazz), 128);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean isReceiverDeclared(Context object, Class<?> object2, String string, String[] stringArray, String[] stringArray2, boolean n) {
        int n2;
        Intent intent;
        PackageManager packageManager;
        block20: {
            ActivityInfo activityInfo;
            block19: {
                packageManager = object.getPackageManager();
                activityInfo = packageManager.getReceiverInfo(new ComponentName((Context)object, object2), 0);
                if (activityInfo.exported == n) break block19;
                object = new StringBuilder().append("ManifestChecker|Receiver '").append(((Class)object2).getName()).append("' must ");
                object2 = n != 0 ? "" : "not ";
                Log.error((String)((StringBuilder)object).append((String)object2).append("be exported").toString());
                return false;
            }
            if (string != null) {
                if (string.equals(activityInfo.permission)) break block20;
                Log.error((String)("ManifestChecker|Receiver '" + ((Class)object2).getName() + "' must require permission '" + string + "' for security reasons"));
                return false;
            }
        }
        String[] stringArray3 = stringArray2;
        string = intent;
        intent = new Intent();
        n = stringArray3.length;
        for (int i = 0; i < n; ++i) {
            string.addCategory(stringArray2[i]);
        }
        String[] stringArray4 = stringArray;
        string.setPackage(object.getPackageName());
        try {
            n2 = stringArray4.length;
        }
        catch (Exception exception) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            PackageManager packageManager2 = packageManager;
            String string2 = string;
            String string3 = string2;
            string2.setAction(stringArray[i]);
            if (!packageManager2.queryBroadcastReceivers((Intent)string3, 32).isEmpty()) continue;
            Log.error((String)("ManifestChecker|Receiver '" + ((Class)object2).getName() + "' must be declared with an intent filter in your AndroidManifest.xml file"));
            return false;
        }
        return true;
    }

    public static String loadServiceMetadata(Context context, String string, Class<? extends Service> clazz) {
        block7: {
            block6: {
                if (context == null) {
                    return null;
                }
                context = context.getApplicationContext();
                try {
                    context = context.getPackageManager().getServiceInfo(new ComponentName(context, clazz), 128);
                }
                catch (Exception exception) {
                    Log.internal((String)"Could not load service metadata", (Throwable)exception);
                    return null;
                }
                if (context.metaData != null) break block6;
                return null;
            }
            if (context.metaData.containsKey(string)) break block7;
            return null;
        }
        return context.metaData.get(string).toString();
    }
}

