/*
 * Decompiled with CFR 0.152.
 */
package com.ad4screen.sdk.plugins.fcm;

import android.content.Context;
import com.ad4screen.sdk.Log;
import com.ad4screen.sdk.plugins.FCMPlugin;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.iid.FirebaseInstanceId;
import java.io.IOException;

public class FCM
implements FCMPlugin {
    private static final String TAG = "FCMPlugin";
    private static final int PLUGIN_VERSION = 1;
    private static final String INSTANCE_ID_SCOPE_FCM = "FCM";
    private FirebaseApp mAccengageFirebaseApp;
    private String mSenderId;

    public void initFirebase(Context context, String appId, String senderId) {
        if (appId == null || appId.isEmpty()) {
            Log.error((String)"FCMPluginappId is not set");
            return;
        }
        if (senderId == null || senderId.isEmpty()) {
            Log.error((String)"FCMPluginsenderId is not set, default Firebase app will be used");
            return;
        }
        if (this.mAccengageFirebaseApp != null) {
            Log.error((String)"FCMPluginAccengage Firebase app is already existed");
            return;
        }
        this.mSenderId = senderId;
        FirebaseOptions.Builder builder = new FirebaseOptions.Builder().setApplicationId(appId).setGcmSenderId(senderId);
        FirebaseOptions options = builder.build();
        this.mAccengageFirebaseApp = FirebaseApp.initializeApp((Context)context, (FirebaseOptions)options, (String)"ACCENGAGE");
        Log.debug((String)("FCMPlugin|FirebaseApp instance " + this.mAccengageFirebaseApp + " for senderId=" + senderId));
    }

    public int getPluginVersion() {
        return 1;
    }

    public String register(Context context, String senderId) {
        if (this.mAccengageFirebaseApp != null && !this.mSenderId.equals(senderId)) {
            Log.error((String)("FCMPlugin|register|wrong senderId=" + senderId + "is passed, wanted " + this.mSenderId));
            return null;
        }
        String token = null;
        try {
            token = this.mAccengageFirebaseApp == null ? FirebaseInstanceId.getInstance().getToken(senderId, INSTANCE_ID_SCOPE_FCM) : FirebaseInstanceId.getInstance((FirebaseApp)this.mAccengageFirebaseApp).getToken(senderId, INSTANCE_ID_SCOPE_FCM);
            Log.debug((String)("FCMPlugin|register for senderId='" + senderId + "', token " + token));
        }
        catch (IOException e) {
            Log.error((String)("FCMPlugin|Error occurred while getting token for senderId=" + senderId + ", error: " + e));
        }
        return token;
    }

    public void unregister(String senderId) {
        if (this.mAccengageFirebaseApp != null && !this.mSenderId.equals(senderId)) {
            Log.error((String)("FCMPlugin|unregister|wrong senderId=" + senderId + "is passed, wanted " + this.mSenderId));
            return;
        }
        try {
            if (this.mAccengageFirebaseApp == null) {
                FirebaseInstanceId.getInstance().deleteToken(senderId, INSTANCE_ID_SCOPE_FCM);
            } else {
                FirebaseInstanceId.getInstance((FirebaseApp)this.mAccengageFirebaseApp).deleteToken(senderId, INSTANCE_ID_SCOPE_FCM);
            }
        }
        catch (IOException e) {
            Log.error((String)("FCMPlugin|Error occurred while deleting token for senderId='" + senderId + "', error" + e));
        }
    }
}

