/*
 * Decompiled with CFR 0.152.
 */
package com.cube.storm.ui.view.player;

import android.media.MediaCodec;
import android.os.Handler;
import android.os.Looper;
import android.view.Surface;
import com.google.android.exoplayer.DummyTrackRenderer;
import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.ExoPlayer;
import com.google.android.exoplayer.MediaCodecAudioTrackRenderer;
import com.google.android.exoplayer.MediaCodecTrackRenderer;
import com.google.android.exoplayer.MediaCodecVideoTrackRenderer;
import com.google.android.exoplayer.TrackRenderer;
import com.google.android.exoplayer.chunk.ChunkSampleSource;
import com.google.android.exoplayer.chunk.MultiTrackChunkSource;
import com.google.android.exoplayer.drm.StreamingDrmSessionManager;
import com.google.android.exoplayer.text.TextTrackRenderer;
import com.google.android.exoplayer.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer.util.PlayerControl;
import java.io.IOException;
import java.util.concurrent.CopyOnWriteArrayList;

public class ExoMediaPlayer
implements ExoPlayer.Listener,
ChunkSampleSource.EventListener,
DefaultBandwidthMeter.EventListener,
MediaCodecVideoTrackRenderer.EventListener,
MediaCodecAudioTrackRenderer.EventListener,
TextTrackRenderer.TextRenderer,
StreamingDrmSessionManager.EventListener {
    public static final int STATE_IDLE = 1;
    public static final int STATE_PREPARING = 2;
    public static final int STATE_BUFFERING = 3;
    public static final int STATE_READY = 4;
    public static final int STATE_ENDED = 5;
    public static final int DISABLED_TRACK = -1;
    public static final int PRIMARY_TRACK = 0;
    public static final int RENDERER_COUNT = 4;
    public static final int TYPE_VIDEO = 0;
    public static final int TYPE_AUDIO = 1;
    public static final int TYPE_TEXT = 2;
    public static final int TYPE_DEBUG = 3;
    private static final int RENDERER_BUILDING_STATE_IDLE = 1;
    private static final int RENDERER_BUILDING_STATE_BUILDING = 2;
    private static final int RENDERER_BUILDING_STATE_BUILT = 3;
    private final RendererBuilder rendererBuilder;
    private final ExoPlayer player;
    private final PlayerControl playerControl;
    private final Handler mainHandler;
    private final CopyOnWriteArrayList<Listener> listeners;
    private int rendererBuildingState;
    private int lastReportedPlaybackState;
    private boolean lastReportedPlayWhenReady;
    private Surface surface;
    private InternalRendererBuilderCallback builderCallback;
    private TrackRenderer videoRenderer;
    private MultiTrackChunkSource[] multiTrackSources;
    private String[][] trackNames;
    private int[] selectedTracks;
    private TextListener textListener;
    private InternalErrorListener internalErrorListener;
    private InfoListener infoListener;

    public ExoMediaPlayer(RendererBuilder rendererBuilder) {
        this.rendererBuilder = rendererBuilder;
        this.player = ExoPlayer.Factory.newInstance((int)4, (int)1000, (int)5000);
        this.player.addListener((ExoPlayer.Listener)this);
        this.playerControl = new PlayerControl(this.player);
        this.mainHandler = new Handler();
        this.listeners = new CopyOnWriteArrayList();
        this.lastReportedPlaybackState = 1;
        this.rendererBuildingState = 1;
        this.selectedTracks = new int[4];
        this.selectedTracks[2] = -1;
    }

    public PlayerControl getPlayerControl() {
        return this.playerControl;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void setInternalErrorListener(InternalErrorListener listener) {
        this.internalErrorListener = listener;
    }

    public void setInfoListener(InfoListener listener) {
        this.infoListener = listener;
    }

    public void setTextListener(TextListener listener) {
        this.textListener = listener;
    }

    public void setSurface(Surface surface) {
        this.surface = surface;
        this.pushSurfaceAndVideoTrack(false);
    }

    public Surface getSurface() {
        return this.surface;
    }

    public void blockingClearSurface() {
        this.surface = null;
        this.pushSurfaceAndVideoTrack(true);
    }

    public String[] getTracks(int type) {
        return this.trackNames == null ? null : this.trackNames[type];
    }

    public int getSelectedTrackIndex(int type) {
        return this.selectedTracks[type];
    }

    public void selectTrack(int type, int index) {
        if (this.selectedTracks[type] == index) {
            return;
        }
        this.selectedTracks[type] = index;
        if (type == 0) {
            this.pushSurfaceAndVideoTrack(false);
        } else {
            this.pushTrackSelection(type, true);
        }
    }

    public void prepare() {
        if (this.rendererBuildingState == 3) {
            this.player.stop();
        }
        if (this.builderCallback != null) {
            this.builderCallback.cancel();
        }
        this.rendererBuildingState = 2;
        this.maybeReportPlayerState();
        this.builderCallback = new InternalRendererBuilderCallback();
        this.rendererBuilder.buildRenderers(this, this.builderCallback);
    }

    private void onRenderers(String[][] trackNames, MultiTrackChunkSource[] multiTrackSources, TrackRenderer[] renderers) {
        this.builderCallback = null;
        if (trackNames == null) {
            trackNames = new String[4][];
        }
        if (multiTrackSources == null) {
            multiTrackSources = new MultiTrackChunkSource[4];
        }
        for (int i = 0; i < 4; ++i) {
            if (renderers[i] == null) {
                renderers[i] = new DummyTrackRenderer();
                continue;
            }
            if (trackNames[i] != null) continue;
            int trackCount = multiTrackSources[i] == null ? 1 : multiTrackSources[i].getTrackCount();
            trackNames[i] = new String[trackCount];
        }
        this.videoRenderer = renderers[0];
        this.trackNames = trackNames;
        this.multiTrackSources = multiTrackSources;
        this.rendererBuildingState = 3;
        this.maybeReportPlayerState();
        this.pushSurfaceAndVideoTrack(false);
        this.pushTrackSelection(1, true);
        this.pushTrackSelection(2, true);
        this.player.prepare(renderers);
    }

    private void onRenderersError(Exception e) {
        this.builderCallback = null;
        if (this.internalErrorListener != null) {
            this.internalErrorListener.onRendererInitializationError(e);
        }
        for (Listener listener : this.listeners) {
            listener.onError(e);
        }
        this.rendererBuildingState = 1;
        this.maybeReportPlayerState();
    }

    public void setPlayWhenReady(boolean playWhenReady) {
        this.player.setPlayWhenReady(playWhenReady);
    }

    public void seekTo(int positionMs) {
        this.player.seekTo(positionMs);
    }

    public void release() {
        if (this.builderCallback != null) {
            this.builderCallback.cancel();
            this.builderCallback = null;
        }
        this.rendererBuildingState = 1;
        this.surface = null;
        this.player.release();
    }

    public int getPlaybackState() {
        if (this.rendererBuildingState == 2) {
            return 2;
        }
        int playerState = this.player.getPlaybackState();
        if (this.rendererBuildingState == 3 && this.rendererBuildingState == 1) {
            return 2;
        }
        return playerState;
    }

    public int getCurrentPosition() {
        return this.player.getCurrentPosition();
    }

    public int getDuration() {
        return this.player.getDuration();
    }

    public int getBufferedPercentage() {
        return this.player.getBufferedPercentage();
    }

    public boolean getPlayWhenReady() {
        return this.player.getPlayWhenReady();
    }

    private Looper getPlaybackLooper() {
        return this.player.getPlaybackLooper();
    }

    public Handler getMainHandler() {
        return this.mainHandler;
    }

    public void onPlayerStateChanged(boolean playWhenReady, int state) {
        this.maybeReportPlayerState();
    }

    public void onPlayerError(ExoPlaybackException exception) {
        this.rendererBuildingState = 1;
        for (Listener listener : this.listeners) {
            listener.onError((Exception)exception);
        }
    }

    public void onVideoSizeChanged(int width, int height) {
        for (Listener listener : this.listeners) {
            listener.onVideoSizeChanged(width, height);
        }
    }

    public void onDroppedFrames(int count, long elapsed) {
        if (this.infoListener != null) {
            this.infoListener.onDroppedFrames(count, elapsed);
        }
    }

    public void onBandwidthSample(int elapsedMs, long bytes, long bitrateEstimate) {
        if (this.infoListener != null) {
            this.infoListener.onBandwidthSample(elapsedMs, bytes, bitrateEstimate);
        }
    }

    public void onDownstreamFormatChanged(int sourceId, String formatId, int trigger, int mediaTimeMs) {
        if (this.infoListener == null) {
            return;
        }
        if (sourceId == 0) {
            this.infoListener.onVideoFormatEnabled(formatId, trigger, mediaTimeMs);
        } else if (sourceId == 1) {
            this.infoListener.onAudioFormatEnabled(formatId, trigger, mediaTimeMs);
        }
    }

    public void onDrmSessionManagerError(Exception e) {
        if (this.internalErrorListener != null) {
            this.internalErrorListener.onDrmSessionManagerError(e);
        }
    }

    public void onDecoderInitializationError(MediaCodecTrackRenderer.DecoderInitializationException e) {
        if (this.internalErrorListener != null) {
            this.internalErrorListener.onDecoderInitializationError(e);
        }
    }

    public void onAudioTrackInitializationError(MediaCodecAudioTrackRenderer.AudioTrackInitializationException e) {
        if (this.internalErrorListener != null) {
            this.internalErrorListener.onAudioTrackInitializationError(e);
        }
    }

    public void onCryptoError(MediaCodec.CryptoException e) {
        if (this.internalErrorListener != null) {
            this.internalErrorListener.onCryptoError(e);
        }
    }

    public void onUpstreamError(int sourceId, IOException e) {
        if (this.internalErrorListener != null) {
            this.internalErrorListener.onUpstreamError(sourceId, e);
        }
    }

    public void onConsumptionError(int sourceId, IOException e) {
        if (this.internalErrorListener != null) {
            this.internalErrorListener.onConsumptionError(sourceId, e);
        }
    }

    public void onText(String text) {
        if (this.textListener != null) {
            this.textListener.onText(text);
        }
    }

    public void onPlayWhenReadyCommitted() {
    }

    public void onDrawnToSurface(Surface surface) {
    }

    public void onLoadStarted(int sourceId, String formatId, int trigger, boolean isInitialization, int mediaStartTimeMs, int mediaEndTimeMs, long length) {
        if (this.infoListener != null) {
            this.infoListener.onLoadStarted(sourceId, formatId, trigger, isInitialization, mediaStartTimeMs, mediaEndTimeMs, length);
        }
    }

    public void onLoadCompleted(int sourceId, long bytesLoaded) {
        if (this.infoListener != null) {
            this.infoListener.onLoadCompleted(sourceId, bytesLoaded);
        }
    }

    public void onLoadCanceled(int sourceId, long bytesLoaded) {
    }

    public void onUpstreamDiscarded(int sourceId, int mediaStartTimeMs, int mediaEndTimeMs, long bytesDiscarded) {
    }

    public void onDownstreamDiscarded(int sourceId, int mediaStartTimeMs, int mediaEndTimeMs, long bytesDiscarded) {
    }

    private void maybeReportPlayerState() {
        boolean playWhenReady = this.player.getPlayWhenReady();
        int playbackState = this.getPlaybackState();
        if (this.lastReportedPlayWhenReady != playWhenReady || this.lastReportedPlaybackState != playbackState) {
            for (Listener listener : this.listeners) {
                listener.onStateChanged(playWhenReady, playbackState);
            }
            this.lastReportedPlayWhenReady = playWhenReady;
            this.lastReportedPlaybackState = playbackState;
        }
    }

    private void pushSurfaceAndVideoTrack(boolean blockForSurfacePush) {
        if (this.rendererBuildingState != 3) {
            return;
        }
        if (blockForSurfacePush) {
            this.player.blockingSendMessage((ExoPlayer.ExoPlayerComponent)this.videoRenderer, 1, (Object)this.surface);
        } else {
            this.player.sendMessage((ExoPlayer.ExoPlayerComponent)this.videoRenderer, 1, (Object)this.surface);
        }
        this.pushTrackSelection(0, this.surface != null && this.surface.isValid());
    }

    private void pushTrackSelection(int type, boolean allowRendererEnable) {
        if (this.rendererBuildingState != 3) {
            return;
        }
        int trackIndex = this.selectedTracks[type];
        if (trackIndex == -1) {
            this.player.setRendererEnabled(type, false);
        } else if (this.multiTrackSources[type] == null) {
            this.player.setRendererEnabled(type, allowRendererEnable);
        } else {
            boolean playWhenReady = this.player.getPlayWhenReady();
            this.player.setPlayWhenReady(false);
            this.player.setRendererEnabled(type, false);
            this.player.sendMessage((ExoPlayer.ExoPlayerComponent)this.multiTrackSources[type], 1, (Object)trackIndex);
            this.player.setRendererEnabled(type, allowRendererEnable);
            this.player.setPlayWhenReady(playWhenReady);
        }
    }

    private class InternalRendererBuilderCallback
    implements RendererBuilderCallback {
        private boolean canceled;

        private InternalRendererBuilderCallback() {
        }

        public void cancel() {
            this.canceled = true;
        }

        @Override
        public void onRenderers(String[][] trackNames, MultiTrackChunkSource[] multiTrackSources, TrackRenderer[] renderers) {
            if (!this.canceled) {
                ExoMediaPlayer.this.onRenderers(trackNames, multiTrackSources, renderers);
            }
        }

        @Override
        public void onRenderersError(Exception e) {
            if (!this.canceled) {
                ExoMediaPlayer.this.onRenderersError(e);
            }
        }
    }

    public static interface TextListener {
        public void onText(String var1);
    }

    public static interface InfoListener {
        public void onVideoFormatEnabled(String var1, int var2, int var3);

        public void onAudioFormatEnabled(String var1, int var2, int var3);

        public void onDroppedFrames(int var1, long var2);

        public void onBandwidthSample(int var1, long var2, long var4);

        public void onLoadStarted(int var1, String var2, int var3, boolean var4, int var5, int var6, long var7);

        public void onLoadCompleted(int var1, long var2);
    }

    public static interface InternalErrorListener {
        public void onRendererInitializationError(Exception var1);

        public void onAudioTrackInitializationError(MediaCodecAudioTrackRenderer.AudioTrackInitializationException var1);

        public void onDecoderInitializationError(MediaCodecTrackRenderer.DecoderInitializationException var1);

        public void onCryptoError(MediaCodec.CryptoException var1);

        public void onUpstreamError(int var1, IOException var2);

        public void onConsumptionError(int var1, IOException var2);

        public void onDrmSessionManagerError(Exception var1);
    }

    public static interface Listener {
        public void onStateChanged(boolean var1, int var2);

        public void onError(Exception var1);

        public void onVideoSizeChanged(int var1, int var2);
    }

    public static interface RendererBuilderCallback {
        public void onRenderers(String[][] var1, MultiTrackChunkSource[] var2, TrackRenderer[] var3);

        public void onRenderersError(Exception var1);
    }

    public static interface RendererBuilder {
        public void buildRenderers(ExoMediaPlayer var1, RendererBuilderCallback var2);
    }
}

