/*
 * Decompiled with CFR 0.152.
 */
package com.cube.storm.ui.view.holder;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.cube.storm.UiSettings;
import com.cube.storm.ui.R;
import com.cube.storm.ui.model.list.SpotlightImageListItem;
import com.cube.storm.ui.view.ViewClickable;
import com.cube.storm.ui.view.holder.Holder;
import com.nostra13.universalimageloader.core.ImageLoader;
import java.util.Timer;
import java.util.TimerTask;

public class SpotlightImageListItemHolder
extends Holder<SpotlightImageListItem>
implements ViewClickable<SpotlightImageListItem> {
    private static final int MSG_UPDATE = 100;
    private ImageView image;
    private TextView text;
    private Timer timer;
    private Handler handler;
    private SpotlightImageListItem model;
    private int currentIndex = 0;

    @Override
    public View createView(ViewGroup parent) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.spotlight_image_list_item_view, parent, false);
        this.image = (ImageView)view.findViewById(R.id.image_view);
        this.image.setTag((Object)this.getTimer());
        this.text = (TextView)view.findViewById(R.id.text_ticker);
        return view;
    }

    @Override
    public void populateView(SpotlightImageListItem model) {
        if (this.model == null) {
            this.currentIndex = 0;
            this.model = model;
            this.handler = new Handler(){

                public void handleMessage(Message msg) {
                    if (msg.what == 100) {
                        SpotlightImageListItemHolder.this.updateView();
                    }
                }
            };
            this.updateView();
        }
    }

    private void updateView() {
        if (this.model.getImages() != null) {
            if (this.currentIndex >= this.model.getImages().size()) {
                this.currentIndex = 0;
            }
            ImageLoader.getInstance().displayImage(this.model.getImages().get(this.currentIndex).getSrc(), this.image);
            this.text.setText((CharSequence)this.model.getImages().get(this.currentIndex).getText().getContent());
            ++this.currentIndex;
            if (this.currentIndex >= this.model.getImages().size()) {
                this.currentIndex = 0;
            }
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    SpotlightImageListItemHolder.this.handler.sendEmptyMessage(100);
                }
            }, this.model.getImages().get(this.currentIndex).getDelay());
        }
    }

    protected Timer getTimer() {
        if (this.timer == null) {
            this.timer = this.image.getTag() != null && this.image.getTag() instanceof Timer ? (Timer)this.image.getTag() : new Timer("Spotlight timer");
        }
        return this.timer;
    }

    @Override
    public void onClick(@NonNull SpotlightImageListItem model, @NonNull View view) {
        if (model.getImages() != null && model.getImages().get(this.currentIndex).getLink() != null) {
            UiSettings.getInstance().getLinkHandler().handleLink(view.getContext(), model.getImages().get(this.currentIndex).getLink());
        }
    }
}

