/*
 * Decompiled with CFR 0.152.
 */
package com.cube.storm.ui.view.holder;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.cube.storm.UiSettings;
import com.cube.storm.ui.R;
import com.cube.storm.ui.model.list.HeaderListItem;
import com.cube.storm.ui.view.holder.Holder;
import com.nostra13.universalimageloader.core.assist.FailReason;
import com.nostra13.universalimageloader.core.listener.ImageLoadingListener;
import com.nostra13.universalimageloader.core.listener.SimpleImageLoadingListener;

public class HeaderListItemHolder
extends Holder<HeaderListItem> {
    protected ImageView image;
    protected TextView title;
    protected TextView description;

    @Override
    public View createView(ViewGroup parent) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.header_list_item_view, parent, false);
        this.image = (ImageView)view.findViewById(R.id.image_view);
        this.title = (TextView)view.findViewById(R.id.title);
        this.description = (TextView)view.findViewById(R.id.description);
        return view;
    }

    @Override
    public void populateView(final HeaderListItem model) {
        String content;
        this.image.setImageBitmap(null);
        this.title.setVisibility(8);
        this.description.setVisibility(8);
        if (model.getImage() != null) {
            UiSettings.getInstance().getImageLoader().displayImage(model.getImage().getSrc(), this.image, (ImageLoadingListener)new SimpleImageLoadingListener(){

                public void onLoadingStarted(String imageUri, View view) {
                    HeaderListItemHolder.this.image.setVisibility(4);
                }

                public void onLoadingFailed(String imageUri, View view, FailReason failReason) {
                    if (!imageUri.equalsIgnoreCase(model.getImage().getFallbackSrc())) {
                        UiSettings.getInstance().getImageLoader().displayImage(model.getImage().getFallbackSrc(), HeaderListItemHolder.this.image, (ImageLoadingListener)this);
                    }
                    HeaderListItemHolder.this.image.setVisibility(0);
                }

                public void onLoadingComplete(String imageUri, View view, Bitmap loadedImage) {
                    HeaderListItemHolder.this.image.setVisibility(0);
                }
            });
        }
        if (model.getTitle() != null && !TextUtils.isEmpty((CharSequence)(content = (String)UiSettings.getInstance().getTextProcessor().process((Object)model.getTitle().getContent())))) {
            this.title.setText((CharSequence)content);
            this.title.setVisibility(0);
        }
        if (model.getDescription() != null && !TextUtils.isEmpty((CharSequence)(content = (String)UiSettings.getInstance().getTextProcessor().process((Object)model.getDescription().getContent())))) {
            this.description.setText((CharSequence)content);
            this.description.setVisibility(0);
        }
    }
}

