/*
 * Decompiled with CFR 0.152.
 */
package com.cube.storm.ui.view.holder;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import com.cube.storm.UiSettings;
import com.cube.storm.ui.R;
import com.cube.storm.ui.model.list.collection.CollectionItem;
import com.cube.storm.ui.model.list.collection.CollectionListItem;
import com.cube.storm.ui.model.property.LinkProperty;
import com.cube.storm.ui.view.ViewClickable;
import com.cube.storm.ui.view.holder.Holder;
import java.util.ArrayList;
import java.util.Iterator;

public class CollectionListItemHolder
extends Holder<CollectionListItem> {
    private ViewHolder holder;
    private View view;
    private LinearLayout linearLayout;
    protected LinearLayout embeddedLinksContainer;

    @Override
    public View createView(ViewGroup parent) {
        this.view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.collection_list_item_view, null, false);
        this.linearLayout = (LinearLayout)this.view.findViewById(R.id.view_container);
        this.embeddedLinksContainer = (LinearLayout)this.view.findViewById(R.id.embedded_links_container);
        this.holder = new ViewHolder(this.view);
        return this.view;
    }

    @Override
    public void populateView(CollectionListItem model) {
        ArrayList<View> views = new ArrayList<View>(model.getCells().size());
        ArrayList<CollectionItem> arrayList = new ArrayList<CollectionItem>();
        arrayList.addAll(model.getCells());
        for (int index = 0; index < arrayList.size(); ++index) {
            View subView = this.getView((CollectionItem)arrayList.get(index), this.holder.viewContainer.getChildAt(index));
            if (subView == null) continue;
            views.add(subView);
        }
        this.holder.viewContainer.removeAllViews();
        for (View subView : views) {
            this.holder.viewContainer.addView(subView);
        }
        this.view.refreshDrawableState();
        if (model.getEmbeddedLinks() != null) {
            this.embeddedLinksContainer.removeAllViews();
            Iterator<Object> i$ = model.getEmbeddedLinks().iterator();
            while (i$.hasNext()) {
                LinkProperty linkProperty;
                final LinkProperty property = linkProperty = (LinkProperty)i$.next();
                View embeddedLinkView = LayoutInflater.from((Context)this.embeddedLinksContainer.getContext()).inflate(R.layout.button_embedded_link, (ViewGroup)this.embeddedLinksContainer, false);
                if (embeddedLinkView == null) continue;
                Button button = (Button)embeddedLinkView.findViewById(R.id.button);
                button.setVisibility(8);
                String content = (String)UiSettings.getInstance().getTextProcessor().process((Object)linkProperty.getTitle().getContent());
                if (!TextUtils.isEmpty((CharSequence)content)) {
                    button.setText((CharSequence)content);
                    button.setVisibility(0);
                }
                button.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        UiSettings.getInstance().getLinkHandler().handleLink(v.getContext(), property);
                    }
                });
                this.embeddedLinksContainer.setVisibility(0);
                this.embeddedLinksContainer.addView((View)button);
            }
        }
    }

    protected View getView(final CollectionItem model, View view) {
        if (model != null) {
            Holder tmp;
            Holder holder = null;
            if (view == null) {
                try {
                    Class<? extends Holder> cls = UiSettings.getInstance().getViewFactory().getHolderForView(model.getClassName());
                    holder = cls.newInstance();
                    view = holder.createView((ViewGroup)this.linearLayout.getParent());
                    holder.populateView(model);
                    view.setTag((Object)holder);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            } else if (view.getTag() != null) {
                holder = (Holder)view.getTag();
                holder.populateView(model);
            }
            if (view != null && (tmp = holder) != null && ViewClickable.class.isAssignableFrom(tmp.getClass())) {
                view.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        ((ViewClickable)((Object)tmp)).onClick(model, v);
                    }
                });
            }
            return view;
        }
        return null;
    }

    public static class ViewHolder {
        public LinearLayout viewContainer;

        public ViewHolder(View root) {
            this.viewContainer = (LinearLayout)root.findViewById(R.id.view_container);
        }
    }
}

