/*
 * Decompiled with CFR 0.152.
 */
package com.cube.storm.ui.view.holder;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.cube.storm.UiSettings;
import com.cube.storm.ui.R;
import com.cube.storm.ui.model.list.collection.AppCollectionItem;
import com.cube.storm.ui.view.ViewClickable;
import com.cube.storm.ui.view.holder.Holder;
import com.nostra13.universalimageloader.core.assist.FailReason;
import com.nostra13.universalimageloader.core.listener.ImageLoadingListener;
import com.nostra13.universalimageloader.core.listener.SimpleImageLoadingListener;

public class AppCollectionItemHolder
extends Holder<AppCollectionItem>
implements ViewClickable<AppCollectionItem> {
    protected ImageView image;
    protected TextView overlay;

    @Override
    public View createView(ViewGroup parent) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.app_collection_item, parent, false);
        this.image = (ImageView)view.findViewById(R.id.icon);
        this.overlay = (TextView)view.findViewById(R.id.overlay);
        return view;
    }

    @Override
    public void populateView(final AppCollectionItem model) {
        this.overlay.setText((CharSequence)model.getOverlay().getContent());
        UiSettings.getInstance().getImageLoader().displayImage(model.getIcon().getSrc(), this.image, (ImageLoadingListener)new SimpleImageLoadingListener(){

            public void onLoadingStarted(String imageUri, View view) {
                AppCollectionItemHolder.this.image.setVisibility(4);
            }

            public void onLoadingFailed(String imageUri, View view, FailReason failReason) {
                if (!imageUri.equalsIgnoreCase(model.getIcon().getFallbackSrc())) {
                    UiSettings.getInstance().getImageLoader().displayImage(model.getIcon().getFallbackSrc(), AppCollectionItemHolder.this.image, (ImageLoadingListener)this);
                }
                AppCollectionItemHolder.this.image.setVisibility(0);
            }

            public void onLoadingComplete(String imageUri, View view, Bitmap loadedImage) {
                AppCollectionItemHolder.this.image.setVisibility(0);
            }
        });
    }

    @Override
    public void onClick(@NonNull AppCollectionItem model, @NonNull View view) {
        if (model.getLink() != null) {
            UiSettings.getInstance().getLinkHandler().handleLink(view.getContext(), model.getLink());
        }
    }
}

