/*
 * Decompiled with CFR 0.152.
 */
package com.cube.storm.ui.view.holder;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.cube.storm.ui.R;
import com.cube.storm.ui.model.list.AnimatedImageListItem;
import com.cube.storm.ui.view.holder.Holder;
import com.nostra13.universalimageloader.core.ImageLoader;
import java.util.Timer;
import java.util.TimerTask;

public class AnimatedImageListItemHolder
extends Holder<AnimatedImageListItem> {
    private static final int MSG_UPDATE = 1;
    private ImageView image;
    private AnimatedImageListItem model;
    private int currentIndex = 0;
    private Timer timer;
    private Handler handler;

    @Override
    public View createView(ViewGroup parent) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.animated_image_list_item_view, parent, false);
        this.image = (ImageView)view.findViewById(R.id.image_view);
        return view;
    }

    @Override
    public void populateView(AnimatedImageListItem model) {
        if (this.model == null) {
            this.handler = new Handler(){

                public void handleMessage(Message msg) {
                    if (msg.what == 1) {
                        AnimatedImageListItemHolder.this.updateView();
                    }
                }
            };
            this.model = model;
            this.currentIndex = 0;
            this.updateView();
        }
    }

    private void updateView() {
        if (this.model.getImages() != null) {
            if (this.currentIndex >= this.model.getImages().size()) {
                this.currentIndex = 0;
            }
            ImageLoader.getInstance().displayImage(this.model.getImages().get(this.currentIndex).getSrc(), this.image);
            ++this.currentIndex;
            if (this.currentIndex >= this.model.getImages().size()) {
                this.currentIndex = 0;
            }
            this.getTimer().schedule(new TimerTask(){

                @Override
                public void run() {
                    AnimatedImageListItemHolder.this.handler.sendEmptyMessage(1);
                }
            }, this.model.getImages().get(this.currentIndex).getDelay());
        }
    }

    protected Timer getTimer() {
        if (this.timer == null) {
            this.timer = this.image.getTag() != null && this.image.getTag() instanceof Timer ? (Timer)this.image.getTag() : new Timer("Animated Image List Item timer");
        }
        return this.timer;
    }
}

