/*
 * Decompiled with CFR 0.152.
 */
package com.cube.storm.ui.view;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import java.lang.reflect.Field;

public class AspectRatioImageView
extends ImageView {
    public AspectRatioImageView(Context context) {
        super(context);
    }

    public AspectRatioImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AspectRatioImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.getDrawable() != null) {
            int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int height = Math.max(1, width * this.getDrawable().getIntrinsicHeight()) / Math.max(1, this.getDrawable().getIntrinsicWidth());
            if (Build.VERSION.SDK_INT >= 16) {
                int maxHeight = this.getMaxHeight();
                if (maxHeight > -1) {
                    height = Math.min(height, maxHeight);
                }
            } else {
                try {
                    Field maxHeightField = ImageView.class.getDeclaredField("mMaxHeight");
                    maxHeightField.setAccessible(true);
                    int maxHeight = (Integer)maxHeightField.get((Object)this);
                    if (maxHeight > -1) {
                        height = Math.min(height, maxHeight);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.setMeasuredDimension(width, height);
        }
    }
}

