/*
 * Decompiled with CFR 0.152.
 */
package com.cube.storm.ui.activity;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.FrameLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.Toast;
import com.cube.storm.UiSettings;
import com.cube.storm.ui.R;
import com.cube.storm.ui.lib.helper.YouTubeHelper;
import com.cube.storm.ui.lib.parser.DefaultRendererBuilder;
import com.cube.storm.ui.model.property.VideoProperty;
import com.cube.storm.ui.view.VideoControllerView;
import com.cube.storm.ui.view.player.ExoMediaPlayer;
import com.cube.storm.util.lib.resolver.Resolver;
import com.google.android.exoplayer.VideoSurfaceView;
import java.io.File;
import java.util.ArrayList;

public class VideoPlayerActivity
extends Activity
implements SurfaceHolder.Callback,
ExoMediaPlayer.Listener {
    public static final String EXTRA_VIDEOS = "extra_videos";
    public static final String EXTRA_FILE_NAME = "extra_file_name";
    public static final String SELECTED_ITEM = "selected_item";
    private ExoMediaPlayer player;
    private VideoControllerView videoControllerView;
    private View shutterView;
    private VideoSurfaceView surfaceView;
    private Spinner videoChooser;
    private Uri contentUri;
    private boolean autoPlay = true;
    private boolean playerNeedsPrepare;
    protected VideoProperty[] otherVideos;
    private int playCount = 0;
    private String fileName;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_video_player);
        this.videoChooser = (Spinner)this.findViewById(R.id.videos);
        View root = this.findViewById(R.id.root);
        this.shutterView = this.findViewById(R.id.shutter);
        this.surfaceView = (VideoSurfaceView)this.findViewById(R.id.surface_view);
        root.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent arg1) {
                if (arg1.getAction() == 0) {
                    VideoPlayerActivity.this.toggleControlsVisibility();
                }
                return true;
            }
        });
        this.videoControllerView = new VideoControllerView((Context)this);
        this.videoControllerView.setAnchorView((ViewGroup)((FrameLayout)this.findViewById(R.id.root)));
        this.surfaceView.getHolder().addCallback((SurfaceHolder.Callback)this);
        Bundle bundle = this.getIntent().getExtras();
        this.fileName = bundle.getString(EXTRA_FILE_NAME);
        if (this.getIntent().hasExtra(EXTRA_VIDEOS) && bundle.getSerializable(EXTRA_VIDEOS) != null) {
            ArrayList array = (ArrayList)bundle.getSerializable(EXTRA_VIDEOS);
            this.otherVideos = new VideoProperty[array.size()];
            for (int index = 0; index < this.otherVideos.length; ++index) {
                this.otherVideos[index] = (VideoProperty)array.get(index);
            }
            if (this.otherVideos != null && this.otherVideos.length > 0) {
                Object[] locales = new String[this.otherVideos.length];
                int selectedIndex = -1;
                for (int index = 0; index < locales.length; ++index) {
                    String languageSuffix = this.otherVideos[index].getLocale();
                    if (languageSuffix.toLowerCase().contains("he")) {
                        languageSuffix = languageSuffix.replace("he", "iw");
                    } else if (languageSuffix.toLowerCase().contains("id")) {
                        languageSuffix = languageSuffix.replace("id", "in");
                    } else if (languageSuffix.toLowerCase().contains("yi")) {
                        languageSuffix = languageSuffix.replace("yi", "ji");
                    }
                    if (this.otherVideos[index].getLocale().equals(this.fileName)) {
                        selectedIndex = index;
                    }
                    locales[index] = languageSuffix;
                }
                if (savedInstanceState != null && savedInstanceState.containsKey(SELECTED_ITEM)) {
                    selectedIndex = savedInstanceState.getInt(SELECTED_ITEM);
                    this.contentUri = Uri.parse((String)this.otherVideos[selectedIndex].getSrc().getDestination());
                } else if (selectedIndex == -1) {
                    selectedIndex = 0;
                    this.contentUri = Uri.parse((String)this.otherVideos[0].getSrc().getDestination());
                }
                ArrayAdapter adapter = new ArrayAdapter((Context)this, 17367043, locales);
                this.videoChooser.setVisibility(0);
                this.videoChooser.setAdapter((SpinnerAdapter)adapter);
                this.videoChooser.setSelection(selectedIndex);
                this.videoChooser.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

                    public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                        if (VideoPlayerActivity.this.playCount++ > 0) {
                            VideoPlayerActivity.this.contentUri = Uri.parse((String)VideoPlayerActivity.this.otherVideos[position].getSrc().getDestination());
                            VideoPlayerActivity.this.autoPlay = true;
                            if (VideoPlayerActivity.this.player != null) {
                                VideoPlayerActivity.this.player.release();
                                VideoPlayerActivity.this.player = null;
                            }
                            VideoPlayerActivity.this.preparePlayer();
                        }
                    }

                    public void onNothingSelected(AdapterView<?> parent) {
                    }
                });
            }
        } else if (this.getIntent().hasExtra("stormui.uri") && bundle.getString("stormui.uri") != null) {
            this.videoChooser.setVisibility(8);
            this.contentUri = Uri.parse((String)bundle.getString("stormui.uri"));
        }
    }

    public void onResume() {
        super.onResume();
        this.preparePlayer();
    }

    protected void onPause() {
        super.onPause();
        this.releasePlayer();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.releasePlayer();
    }

    public void onSaveInstanceState(Bundle savedInstanceState) {
        savedInstanceState.putInt(SELECTED_ITEM, this.videoChooser.getSelectedItemPosition());
        super.onSaveInstanceState(savedInstanceState);
    }

    private void preparePlayer() {
        if (this.player == null) {
            ExoMediaPlayer.RendererBuilder builder = this.getRendererBuilder();
            if (builder == null) {
                return;
            }
            this.player = new ExoMediaPlayer(builder);
            this.player.addListener(this);
            this.playerNeedsPrepare = true;
            this.videoControllerView.setMediaPlayer(this.player.getPlayerControl());
            this.videoControllerView.setEnabled(true);
        }
        if (this.playerNeedsPrepare) {
            this.player.prepare();
            this.playerNeedsPrepare = false;
        }
        this.player.setSurface(this.surfaceView.getHolder().getSurface());
        this.maybeStartPlayback();
    }

    private void prepareYoutubePlayer(ExoMediaPlayer.RendererBuilder rendererBuilder) {
        if (this.player == null) {
            if (rendererBuilder == null) {
                return;
            }
            this.player = new ExoMediaPlayer(rendererBuilder);
            this.player.addListener(this);
            this.playerNeedsPrepare = true;
            this.videoControllerView.setMediaPlayer(this.player.getPlayerControl());
            this.videoControllerView.setEnabled(true);
        }
        if (this.playerNeedsPrepare) {
            this.player.prepare();
            this.playerNeedsPrepare = false;
        }
        this.player.setSurface(this.surfaceView.getHolder().getSurface());
        this.maybeStartPlayback();
    }

    private void maybeStartPlayback() {
        if (this.autoPlay && (this.player.getSurface().isValid() || this.player.getSelectedTrackIndex(0) == -1)) {
            this.player.setPlayWhenReady(true);
        }
    }

    private ExoMediaPlayer.RendererBuilder getRendererBuilder() {
        if (this.contentUri.getScheme().equals("assets")) {
            return new DefaultRendererBuilder(this, this.contentUri);
        }
        if (this.contentUri.getScheme().equals("file")) {
            File f = new File(this.contentUri.getPath());
            if (!f.exists()) {
                this.videoFailed();
                return null;
            }
            return new DefaultRendererBuilder(this, this.contentUri);
        }
        if (this.isYoutubeVideo(this.contentUri)) {
            YouTubeHelper.getStreamingUrl(this.contentUri.toString(), new YouTubeHelper.Callback(){

                @Override
                public void onStreamingUrlFetched(String streamingUrl) {
                    VideoPlayerActivity.this.prepareYoutubePlayer(new DefaultRendererBuilder(VideoPlayerActivity.this, Uri.parse((String)streamingUrl)));
                }

                @Override
                public void onFailed(String failMessage) {
                    VideoPlayerActivity.this.videoFailed();
                }
            });
            return null;
        }
        Resolver fallbackResolver = UiSettings.getInstance().getUriResolvers().get(this.contentUri.getScheme());
        if (fallbackResolver != null) {
            this.contentUri = fallbackResolver.resolveUri(this.contentUri);
            return this.getRendererBuilder();
        }
        this.videoFailed();
        return null;
    }

    public void videoFailed() {
        Toast.makeText((Context)this, (CharSequence)"Failed to load video", (int)1).show();
        this.finish();
    }

    @Override
    public void onStateChanged(boolean playWhenReady, int playbackState) {
        if (playbackState == 5) {
            this.showControls();
        }
    }

    private void showControls() {
        this.videoControllerView.show(0);
    }

    private void toggleControlsVisibility() {
        if (this.videoControllerView.isShowing()) {
            this.videoControllerView.hide();
        } else {
            this.videoControllerView.show(0);
        }
    }

    private void releasePlayer() {
        if (this.player != null) {
            this.player.release();
            this.player = null;
        }
    }

    public boolean isYoutubeVideo(Uri uri) {
        return uri.getHost().endsWith("youtube.com") && uri.getQueryParameter("v") != null || uri.getHost().endsWith("youtu.be") && uri.getPathSegments().size() > 0;
    }

    public void surfaceCreated(SurfaceHolder holder) {
        if (this.player != null) {
            this.player.setSurface(holder.getSurface());
            this.maybeStartPlayback();
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        if (this.player != null) {
            this.player.blockingClearSurface();
        }
    }

    @Override
    public void onError(Exception e) {
    }

    @Override
    public void onVideoSizeChanged(int width, int height) {
        this.shutterView.setVisibility(8);
        this.surfaceView.setVideoWidthHeightRatio(height == 0 ? 1.0f : (float)width / (float)height);
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }
}

