/*
 * Decompiled with CFR 0.152.
 */
package com.cube.storm.ui.activity;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.view.MenuItemCompat;
import android.support.v7.app.ActionBarActivity;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import android.widget.Toast;
import com.cube.storm.ui.R;

public class StormWebActivity
extends ActionBarActivity
implements View.OnClickListener {
    public static final String EXTRA_FILE_NAME = "extra_file_name";
    public static final String EXTRA_TITLE = "extra_title";
    public View mWeb;
    public View mShare;
    public View mBack;
    public View mForward;
    public View mClose;
    public View mButtonContainer;
    private WebView webView;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.supportRequestWindowFeature(5);
        if (this.getIntent().getExtras() != null && this.getIntent().getExtras().containsKey(EXTRA_FILE_NAME)) {
            if (this.getIntent().getExtras().containsKey(EXTRA_TITLE)) {
                this.setTitle(this.getIntent().getExtras().getString(EXTRA_TITLE));
            }
            this.setContentView(R.layout.web_view);
            this.mButtonContainer = this.findViewById(R.id.button_container);
            this.mWeb = this.findViewById(R.id.icon_web);
            this.mBack = this.findViewById(R.id.icon_back);
            this.mForward = this.findViewById(R.id.icon_forward);
            this.mClose = this.findViewById(R.id.icon_close);
            this.mShare = this.findViewById(R.id.icon_share);
            this.webView = (WebView)this.findViewById(R.id.web_view);
            this.mWeb.setOnClickListener((View.OnClickListener)this);
            this.mBack.setOnClickListener((View.OnClickListener)this);
            this.mForward.setOnClickListener((View.OnClickListener)this);
            this.mClose.setOnClickListener((View.OnClickListener)this);
            this.mShare.setOnClickListener((View.OnClickListener)this);
            WebSettings settings = this.webView.getSettings();
            settings.setJavaScriptEnabled(true);
            settings.setBuiltInZoomControls(true);
            settings.setLoadWithOverviewMode(true);
            settings.setUseWideViewPort(true);
            if (Build.VERSION.SDK_INT >= 11) {
                settings.setDisplayZoomControls(false);
            }
            final ProgressBar progressBar = (ProgressBar)this.findViewById(R.id.progress_bar);
            this.webView.setWebViewClient(new WebViewClient());
            this.webView.setWebChromeClient(new WebChromeClient(){

                public void onProgressChanged(WebView view, int progress) {
                    if (progress < 100 && progressBar.getVisibility() == 8) {
                        progressBar.setVisibility(0);
                    }
                    progressBar.setProgress(progress);
                    if (progress == 100) {
                        progressBar.setVisibility(8);
                    }
                    super.onProgressChanged(view, progress);
                }
            });
            if (savedInstanceState != null) {
                this.webView.restoreState(savedInstanceState);
            } else {
                String toLoad = this.getIntent().getExtras().getString(EXTRA_FILE_NAME);
                this.webView.loadUrl(toLoad);
            }
        } else {
            Toast.makeText((Context)this, (CharSequence)"No url set", (int)1).show();
            this.finish();
        }
    }

    public void onClick(View v) {
        if (v == this.mWeb) {
            Intent i = new Intent("android.intent.action.VIEW");
            i.setData(Uri.parse((String)(this.webView.getUrl() == null ? this.getIntent().getExtras().getString(EXTRA_FILE_NAME) : this.webView.getUrl())));
            this.startActivity(i);
        } else if (v == this.mBack) {
            this.webView.goBack();
        } else if (v == this.mForward) {
            this.webView.goForward();
        } else if (v == this.mClose) {
            this.finish();
        } else if (v == this.mShare) {
            Intent shareIntent = new Intent("android.intent.action.SEND");
            shareIntent.putExtra("android.intent.extra.TEXT", this.webView.getUrl());
            shareIntent.setType("text/plain");
            this.startActivity(shareIntent);
        }
    }

    public void onSaveInstanceState(Bundle savedInstanceState) {
        this.webView.saveState(savedInstanceState);
        super.onSaveInstanceState(savedInstanceState);
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        this.webView.restoreState(savedInstanceState);
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        MenuItem back = menu.add(0, 2, 0, (CharSequence)"Back");
        MenuItem forward = menu.add(0, 3, 0, (CharSequence)"Forward");
        MenuItem refresh = menu.add(0, 1, 0, (CharSequence)"Refresh");
        MenuItem open = menu.add(0, 4, 0, (CharSequence)"Open external");
        MenuItemCompat.setShowAsAction((MenuItem)back, (int)8);
        MenuItemCompat.setShowAsAction((MenuItem)forward, (int)8);
        MenuItemCompat.setShowAsAction((MenuItem)refresh, (int)8);
        MenuItemCompat.setShowAsAction((MenuItem)open, (int)8);
        return super.onCreateOptionsMenu(menu);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && this.webView.canGoBack()) {
            this.webView.goBack();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 4) {
            this.onClick(this.mWeb);
        } else if (item.getItemId() == 2) {
            this.onClick(this.mBack);
        } else if (item.getItemId() == 3) {
            this.webView.goForward();
        } else if (item.getItemId() == 1) {
            this.webView.reload();
        }
        return super.onOptionsItemSelected(item);
    }
}

