/*
 * Decompiled with CFR 0.152.
 */
package com.treebo.internetavailabilitychecker;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import com.treebo.internetavailabilitychecker.CheckInternetTask;
import com.treebo.internetavailabilitychecker.InternetConnectivityListener;
import com.treebo.internetavailabilitychecker.NetworkChangeReceiver;
import com.treebo.internetavailabilitychecker.TaskFinished;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class InternetAvailabilityChecker
implements NetworkChangeReceiver.NetworkChangeListener {
    private static final Object LOCK = new Object();
    private static volatile InternetAvailabilityChecker sInstance;
    private volatile boolean taskRunning = false;
    private WeakReference<Context> mContextWeakReference;
    private List<WeakReference<InternetConnectivityListener>> mInternetConnectivityListenersWeakReferences;
    private NetworkChangeReceiver mNetworkChangeReceiver;
    private boolean mIsNetworkChangeRegistered = false;
    private boolean online = false;
    private TaskFinished<Boolean> mCheckConnectivityCallback;
    private static final String CONNECTIVITY_CHANGE_INTENT_ACTION = "android.net.conn.CONNECTIVITY_CHANGE";

    private InternetAvailabilityChecker(Context context) {
        Context appContext = context.getApplicationContext();
        this.mContextWeakReference = new WeakReference<Context>(appContext);
        this.mInternetConnectivityListenersWeakReferences = new ArrayList<WeakReference<InternetConnectivityListener>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InternetAvailabilityChecker init(Context context) {
        if (context == null) {
            throw new NullPointerException("context can not be null");
        }
        if (sInstance == null) {
            Object object = LOCK;
            synchronized (object) {
                if (sInstance == null) {
                    sInstance = new InternetAvailabilityChecker(context);
                }
            }
        }
        return sInstance;
    }

    public static InternetAvailabilityChecker getInstance() {
        if (sInstance == null) {
            throw new IllegalStateException("call init(Context) in your application class before calling getInstance()");
        }
        return sInstance;
    }

    public void addInternetConnectivityListener(InternetConnectivityListener internetConnectivityListener) {
        if (internetConnectivityListener == null) {
            return;
        }
        this.mInternetConnectivityListenersWeakReferences.add(new WeakReference<InternetConnectivityListener>(internetConnectivityListener));
        if (this.mInternetConnectivityListenersWeakReferences.size() == 1) {
            this.registerNetworkChangeReceiver();
        }
    }

    public void removeInternetConnectivityChangeListener(InternetConnectivityListener internetConnectivityListener) {
        if (internetConnectivityListener == null) {
            return;
        }
        if (this.mInternetConnectivityListenersWeakReferences == null) {
            return;
        }
        Iterator<WeakReference<InternetConnectivityListener>> iterator = this.mInternetConnectivityListenersWeakReferences.iterator();
        while (iterator.hasNext()) {
            WeakReference<InternetConnectivityListener> reference = iterator.next();
            if (reference == null) {
                iterator.remove();
                continue;
            }
            InternetConnectivityListener listener = (InternetConnectivityListener)reference.get();
            if (listener == null) {
                reference.clear();
                iterator.remove();
                continue;
            }
            if (listener != internetConnectivityListener) continue;
            reference.clear();
            iterator.remove();
            break;
        }
        if (this.mInternetConnectivityListenersWeakReferences.size() == 0) {
            this.unregisterNetworkChangeReceiver();
        }
    }

    public void removeAllInternetConnectivityChangeListeners() {
        if (this.mInternetConnectivityListenersWeakReferences == null) {
            return;
        }
        Iterator<WeakReference<InternetConnectivityListener>> iterator = this.mInternetConnectivityListenersWeakReferences.iterator();
        while (iterator.hasNext()) {
            WeakReference<InternetConnectivityListener> reference = iterator.next();
            if (reference != null) {
                reference.clear();
            }
            iterator.remove();
        }
        this.unregisterNetworkChangeReceiver();
    }

    private void registerNetworkChangeReceiver() {
        Context context = (Context)this.mContextWeakReference.get();
        if (context != null && !this.mIsNetworkChangeRegistered) {
            this.mNetworkChangeReceiver = new NetworkChangeReceiver();
            this.mNetworkChangeReceiver.setNetworkChangeListener(this);
            context.registerReceiver((BroadcastReceiver)this.mNetworkChangeReceiver, new IntentFilter(CONNECTIVITY_CHANGE_INTENT_ACTION));
            this.mIsNetworkChangeRegistered = true;
        }
    }

    private void unregisterNetworkChangeReceiver() {
        Context context = (Context)this.mContextWeakReference.get();
        if (context != null && this.mNetworkChangeReceiver != null && this.mIsNetworkChangeRegistered) {
            try {
                context.unregisterReceiver((BroadcastReceiver)this.mNetworkChangeReceiver);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.mNetworkChangeReceiver.removeNetworkChangeListener();
        }
        this.mNetworkChangeReceiver = null;
        this.mIsNetworkChangeRegistered = false;
        this.mCheckConnectivityCallback = null;
    }

    @Override
    public synchronized void onNetworkChange(boolean isNetworkAvailable) {
        if (this.taskRunning) {
            return;
        }
        if (isNetworkAvailable) {
            this.mCheckConnectivityCallback = new TaskFinished<Boolean>(){

                @Override
                public void onTaskFinished(Boolean isInternetAvailable) {
                    InternetAvailabilityChecker.this.mCheckConnectivityCallback = null;
                    InternetAvailabilityChecker.this.publishInternetAvailabilityStatus(isInternetAvailable);
                    InternetAvailabilityChecker.this.taskRunning = false;
                }
            };
            this.taskRunning = true;
            new CheckInternetTask(this.mCheckConnectivityCallback).execute(new Void[0]);
        } else {
            this.publishInternetAvailabilityStatus(false);
        }
    }

    private void publishInternetAvailabilityStatus(boolean isInternetAvailable) {
        if (this.online == isInternetAvailable) {
            return;
        }
        this.online = isInternetAvailable;
        if (this.mInternetConnectivityListenersWeakReferences == null) {
            return;
        }
        Iterator<WeakReference<InternetConnectivityListener>> iterator = this.mInternetConnectivityListenersWeakReferences.iterator();
        while (iterator.hasNext()) {
            WeakReference<InternetConnectivityListener> reference = iterator.next();
            if (reference == null) {
                iterator.remove();
                continue;
            }
            InternetConnectivityListener listener = (InternetConnectivityListener)reference.get();
            if (listener == null) {
                iterator.remove();
                continue;
            }
            listener.onInternetConnectivityChanged(isInternetAvailable);
        }
        if (this.mInternetConnectivityListenersWeakReferences.size() == 0) {
            this.unregisterNetworkChangeReceiver();
        }
    }

    public boolean isOnline() {
        return this.online;
    }
}

