/*
 * Decompiled with CFR 0.152.
 */
package co.pushe.plus.utils.keyval;

import co.pushe.plus.utils.keyval.KVStorage;
import co.pushe.plus.utils.keyval.KVStorageEditor;
import java.util.Map;

public class MultiLevelKVStorage
implements KVStorage {
    private KVStorage mainStorage;
    private KVStorage levelStorage;
    private int defaultLevel;

    public MultiLevelKVStorage(KVStorage mainStorage, KVStorage levelStorage, int defaultLevel) {
        this.mainStorage = mainStorage;
        this.levelStorage = levelStorage;
        this.defaultLevel = defaultLevel;
    }

    @Override
    public boolean contains(String key) {
        return this.mainStorage.contains(key);
    }

    @Override
    public String getString(String key, String defVal) {
        return this.mainStorage.getString(key, defVal);
    }

    @Override
    public int getInt(String key, int defVal) {
        return this.mainStorage.getInt(key, defVal);
    }

    @Override
    public float getFloat(String key, float defVal) {
        return this.mainStorage.getFloat(key, defVal);
    }

    @Override
    public boolean getBoolean(String key, boolean defVal) {
        return this.mainStorage.getBoolean(key, defVal);
    }

    @Override
    public String[] getStringArray(String key) {
        return this.mainStorage.getStringArray(key);
    }

    public void saveString(String key, String value, int level) {
        this.edit(level).putString(key, value).apply();
    }

    @Override
    public void saveString(String key, String value) {
        this.saveString(key, value, this.defaultLevel);
    }

    public void saveInt(String key, int value, int level) {
        this.edit(level).putInt(key, value);
    }

    @Override
    public void saveInt(String key, int value) {
        this.saveInt(key, value, this.defaultLevel);
    }

    public void saveFloat(String key, float value, int level) {
        this.edit(level).putFloat(key, value);
    }

    @Override
    public void saveFloat(String key, float value) {
        this.saveFloat(key, value, this.defaultLevel);
    }

    public void saveBoolean(String key, boolean value, int level) {
        this.edit(level).putBoolean(key, value);
    }

    @Override
    public void saveBoolean(String key, boolean value) {
        this.saveBoolean(key, value, this.defaultLevel);
    }

    public void saveStringArray(String key, String[] value, int level) {
        this.edit(level).putStringArray(key, value);
    }

    @Override
    public void saveStringArray(String key, String[] value) {
        this.saveStringArray(key, value, this.defaultLevel);
    }

    @Override
    public void remove(String key) {
        this.mainStorage.remove(key);
        this.levelStorage.remove(key);
    }

    @Override
    public Map<String, ?> getAll() {
        return this.mainStorage.getAll();
    }

    public KVStorageEditor edit(int level) {
        return new Editor(level);
    }

    @Override
    public KVStorageEditor edit() {
        return new Editor(this.defaultLevel);
    }

    public class Editor
    implements KVStorageEditor {
        private int level;
        private KVStorageEditor mainEditor;
        private KVStorageEditor levelEditor;

        public Editor(int level) {
            this.level = level;
        }

        private KVStorageEditor getMainEditor() {
            if (this.mainEditor == null) {
                this.mainEditor = MultiLevelKVStorage.this.mainStorage.edit();
            }
            return this.mainEditor;
        }

        private KVStorageEditor getLevelEditor() {
            if (this.levelEditor == null) {
                this.levelEditor = MultiLevelKVStorage.this.levelStorage.edit();
            }
            return this.levelEditor;
        }

        @Override
        public KVStorageEditor putString(String key, String value) {
            int storedLevel = MultiLevelKVStorage.this.levelStorage.getInt(key, 0);
            if (this.level >= storedLevel) {
                this.getMainEditor().putString(key, value);
                if (this.level != storedLevel) {
                    this.getLevelEditor().putInt(key, this.level);
                }
            }
            return this;
        }

        @Override
        public KVStorageEditor putInt(String key, int value) {
            int storedLevel = MultiLevelKVStorage.this.levelStorage.getInt(key, 0);
            if (this.level >= storedLevel) {
                this.getMainEditor().putInt(key, value);
                if (this.level != storedLevel) {
                    this.getLevelEditor().putInt(key, this.level);
                }
            }
            return this;
        }

        @Override
        public KVStorageEditor putFloat(String key, float value) {
            int storedLevel = MultiLevelKVStorage.this.levelStorage.getInt(key, 0);
            if (this.level >= storedLevel) {
                this.getMainEditor().putFloat(key, value);
                if (this.level != storedLevel) {
                    this.getLevelEditor().putInt(key, this.level);
                }
            }
            return this;
        }

        @Override
        public KVStorageEditor putBoolean(String key, boolean value) {
            int storedLevel = MultiLevelKVStorage.this.levelStorage.getInt(key, 0);
            if (this.level >= storedLevel) {
                this.getMainEditor().putBoolean(key, value);
                if (this.level != storedLevel) {
                    this.getLevelEditor().putInt(key, this.level);
                }
            }
            return this;
        }

        @Override
        public KVStorageEditor putStringArray(String key, String[] value) {
            int storedLevel = MultiLevelKVStorage.this.levelStorage.getInt(key, 0);
            if (this.level >= storedLevel) {
                this.getMainEditor().putStringArray(key, value);
                if (this.level != storedLevel) {
                    this.getLevelEditor().putInt(key, this.level);
                }
            }
            return this;
        }

        @Override
        public KVStorageEditor remove(String key) {
            this.getMainEditor().remove(key);
            this.getLevelEditor().remove(key);
            return this;
        }

        @Override
        public void apply() {
            if (this.mainEditor != null) {
                this.mainEditor.apply();
            }
            if (this.levelEditor != null) {
                this.levelEditor.apply();
            }
        }

        @Override
        public void commit() {
            if (this.mainEditor != null) {
                this.mainEditor.commit();
            }
            if (this.levelEditor != null) {
                this.levelEditor.commit();
            }
        }
    }
}

