/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.InferenceConfigUpdate;
import co.elastic.clients.elasticsearch.ml.InferenceConfigUpdateVariant;
import co.elastic.clients.elasticsearch.ml.NlpTokenizationUpdateOptions;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class QuestionAnsweringInferenceUpdateOptions
implements InferenceConfigUpdateVariant,
JsonpSerializable {
    private final String question;
    @Nullable
    private final Integer numTopClasses;
    @Nullable
    private final NlpTokenizationUpdateOptions tokenization;
    @Nullable
    private final String resultsField;
    @Nullable
    private final Integer maxAnswerLength;
    public static final JsonpDeserializer<QuestionAnsweringInferenceUpdateOptions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QuestionAnsweringInferenceUpdateOptions::setupQuestionAnsweringInferenceUpdateOptionsDeserializer);

    private QuestionAnsweringInferenceUpdateOptions(Builder builder) {
        this.question = ApiTypeHelper.requireNonNull(builder.question, this, "question");
        this.numTopClasses = builder.numTopClasses;
        this.tokenization = builder.tokenization;
        this.resultsField = builder.resultsField;
        this.maxAnswerLength = builder.maxAnswerLength;
    }

    public static QuestionAnsweringInferenceUpdateOptions of(Function<Builder, ObjectBuilder<QuestionAnsweringInferenceUpdateOptions>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public InferenceConfigUpdate.Kind _inferenceConfigUpdateKind() {
        return InferenceConfigUpdate.Kind.QuestionAnswering;
    }

    public final String question() {
        return this.question;
    }

    @Nullable
    public final Integer numTopClasses() {
        return this.numTopClasses;
    }

    @Nullable
    public final NlpTokenizationUpdateOptions tokenization() {
        return this.tokenization;
    }

    @Nullable
    public final String resultsField() {
        return this.resultsField;
    }

    @Nullable
    public final Integer maxAnswerLength() {
        return this.maxAnswerLength;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("question");
        generator.write(this.question);
        if (this.numTopClasses != null) {
            generator.writeKey("num_top_classes");
            generator.write(this.numTopClasses.intValue());
        }
        if (this.tokenization != null) {
            generator.writeKey("tokenization");
            this.tokenization.serialize(generator, mapper);
        }
        if (this.resultsField != null) {
            generator.writeKey("results_field");
            generator.write(this.resultsField);
        }
        if (this.maxAnswerLength != null) {
            generator.writeKey("max_answer_length");
            generator.write(this.maxAnswerLength.intValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupQuestionAnsweringInferenceUpdateOptionsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::question, JsonpDeserializer.stringDeserializer(), "question");
        op.add(Builder::numTopClasses, JsonpDeserializer.integerDeserializer(), "num_top_classes");
        op.add(Builder::tokenization, NlpTokenizationUpdateOptions._DESERIALIZER, "tokenization");
        op.add(Builder::resultsField, JsonpDeserializer.stringDeserializer(), "results_field");
        op.add(Builder::maxAnswerLength, JsonpDeserializer.integerDeserializer(), "max_answer_length");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<QuestionAnsweringInferenceUpdateOptions> {
        private String question;
        @Nullable
        private Integer numTopClasses;
        @Nullable
        private NlpTokenizationUpdateOptions tokenization;
        @Nullable
        private String resultsField;
        @Nullable
        private Integer maxAnswerLength;

        public final Builder question(String value) {
            this.question = value;
            return this;
        }

        public final Builder numTopClasses(@Nullable Integer value) {
            this.numTopClasses = value;
            return this;
        }

        public final Builder tokenization(@Nullable NlpTokenizationUpdateOptions value) {
            this.tokenization = value;
            return this;
        }

        public final Builder tokenization(Function<NlpTokenizationUpdateOptions.Builder, ObjectBuilder<NlpTokenizationUpdateOptions>> fn) {
            return this.tokenization(fn.apply(new NlpTokenizationUpdateOptions.Builder()).build());
        }

        public final Builder resultsField(@Nullable String value) {
            this.resultsField = value;
            return this;
        }

        public final Builder maxAnswerLength(@Nullable Integer value) {
            this.maxAnswerLength = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public QuestionAnsweringInferenceUpdateOptions build() {
            this._checkSingleUse();
            return new QuestionAnsweringInferenceUpdateOptions(this);
        }
    }
}

