/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AppendProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String field;
    private final List<JsonData> value;
    @Nullable
    private final String mediaType;
    @Nullable
    private final String copyFrom;
    @Nullable
    private final Boolean allowDuplicates;
    @Nullable
    private final Boolean ignoreEmptyValues;
    public static final JsonpDeserializer<AppendProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AppendProcessor::setupAppendProcessorDeserializer);

    private AppendProcessor(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.value = ApiTypeHelper.unmodifiable(builder.value);
        this.mediaType = builder.mediaType;
        this.copyFrom = builder.copyFrom;
        this.allowDuplicates = builder.allowDuplicates;
        this.ignoreEmptyValues = builder.ignoreEmptyValues;
    }

    public static AppendProcessor of(Function<Builder, ObjectBuilder<AppendProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Append;
    }

    public final String field() {
        return this.field;
    }

    public final List<JsonData> value() {
        return this.value;
    }

    @Nullable
    public final String mediaType() {
        return this.mediaType;
    }

    @Nullable
    public final String copyFrom() {
        return this.copyFrom;
    }

    @Nullable
    public final Boolean allowDuplicates() {
        return this.allowDuplicates;
    }

    @Nullable
    public final Boolean ignoreEmptyValues() {
        return this.ignoreEmptyValues;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (ApiTypeHelper.isDefined(this.value)) {
            generator.writeKey("value");
            generator.writeStartArray();
            for (JsonData item0 : this.value) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.mediaType != null) {
            generator.writeKey("media_type");
            generator.write(this.mediaType);
        }
        if (this.copyFrom != null) {
            generator.writeKey("copy_from");
            generator.write(this.copyFrom);
        }
        if (this.allowDuplicates != null) {
            generator.writeKey("allow_duplicates");
            generator.write(this.allowDuplicates.booleanValue());
        }
        if (this.ignoreEmptyValues != null) {
            generator.writeKey("ignore_empty_values");
            generator.write(this.ignoreEmptyValues.booleanValue());
        }
    }

    protected static void setupAppendProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::value, JsonpDeserializer.arrayDeserializer(JsonData._DESERIALIZER), "value");
        op.add(Builder::mediaType, JsonpDeserializer.stringDeserializer(), "media_type");
        op.add(Builder::copyFrom, JsonpDeserializer.stringDeserializer(), "copy_from");
        op.add(Builder::allowDuplicates, JsonpDeserializer.booleanDeserializer(), "allow_duplicates");
        op.add(Builder::ignoreEmptyValues, JsonpDeserializer.booleanDeserializer(), "ignore_empty_values");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<AppendProcessor> {
        private String field;
        @Nullable
        private List<JsonData> value;
        @Nullable
        private String mediaType;
        @Nullable
        private String copyFrom;
        @Nullable
        private Boolean allowDuplicates;
        @Nullable
        private Boolean ignoreEmptyValues;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder value(List<JsonData> list) {
            this.value = Builder._listAddAll(this.value, list);
            return this;
        }

        public final Builder value(JsonData value, JsonData ... values) {
            this.value = Builder._listAdd(this.value, value, values);
            return this;
        }

        public final Builder mediaType(@Nullable String value) {
            this.mediaType = value;
            return this;
        }

        public final Builder copyFrom(@Nullable String value) {
            this.copyFrom = value;
            return this;
        }

        public final Builder allowDuplicates(@Nullable Boolean value) {
            this.allowDuplicates = value;
            return this;
        }

        public final Builder ignoreEmptyValues(@Nullable Boolean value) {
            this.ignoreEmptyValues = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AppendProcessor build() {
            this._checkSingleUse();
            return new AppendProcessor(this);
        }
    }
}

